/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.framework;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jftp.gui.base.dir.DirEntry;
import net.sf.jftp.gui.framework.ProgressbarItem;

public class ProgressBarList
extends JPanel {
    private int index = -1;

    public ProgressBarList() {
        this.setLayout(new GridLayout(0, 1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Component c = ProgressBarList.this.getComponentAt(e.getX(), e.getY());
                ProgressBarList.this.deselectAll();
                for (int i = 0; i < ProgressBarList.this.getComponentCount(); ++i) {
                    ProgressbarItem item;
                    if (!(ProgressBarList.this.getComponent(i) instanceof ProgressbarItem) || (item = (ProgressbarItem)ProgressBarList.this.getComponent(i)) != c) continue;
                    item.select();
                    ProgressBarList.this.index = i;
                }
                if (c instanceof ProgressbarItem) {
                    // empty if block
                }
            }
        });
    }

    public void setListData(DirEntry[] items) {
        this.removeAll();
        for (int i = 0; i < items.length; ++i) {
            ProgressbarItem p = new ProgressbarItem(items[i]);
            p.update((int)items[i].getTransferred() / 1024, (int)items[i].getRawSize() / 1024, items[i].file);
            this.add(p);
        }
        while (this.getComponentCount() < 10) {
            this.add(new JLabel(" "));
        }
        this.revalidate();
        this.setSelectedIndex(this.index);
    }

    public ProgressbarItem getSelectedValue() {
        return (ProgressbarItem)this.getComponent(this.index);
    }

    public int getSelectedIndex() {
        return this.index;
    }

    private void deselectAll() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof ProgressbarItem)) continue;
            ((ProgressbarItem)this.getComponent(i)).deselect();
        }
    }

    public void setSelectedIndex(int idx) {
        this.deselectAll();
        this.index = idx;
        if (this.index >= 0 && this.getComponentCount() > this.index && this.getComponent(this.index) instanceof ProgressbarItem) {
            ((ProgressbarItem)this.getComponent(this.index)).select();
        }
    }

    private String strip(String in) {
        if (in.indexOf("<") >= 0) {
            in = in.substring(in.lastIndexOf("<") + 1);
            in = in.substring(0, in.lastIndexOf(">"));
        }
        return in;
    }

    public void setTransferred(String file, long bytes, String message, long max) {
        boolean ok = false;
        for (int i = 0; i < this.getComponentCount() && !ok; ++i) {
            if (this.getComponent(i) instanceof ProgressbarItem) {
                ProgressbarItem item = (ProgressbarItem)this.getComponent(i);
                String f = this.strip(item.getDirEntry().file);
                if (!f.equals(file)) continue;
                item.update(bytes, max, message);
                ok = true;
                continue;
            }
            ok = false;
        }
    }
}

