/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.framework;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sf.jftp.gui.base.dir.DirEntry;

public class ProgressbarItem
extends JPanel {
    private DirEntry d;
    private JProgressBar bar = new JProgressBar();

    public ProgressbarItem(DirEntry d) {
        this.d = d;
        this.setLayout(new BorderLayout(2, 2));
        this.add("Center", this.bar);
        this.bar.setStringPainted(true);
        this.bar.setString(d.file);
        this.setBackground(Color.WHITE);
        this.setSize(300, 25);
    }

    public void update(long size, long max, String lbl) {
        while (max > Integer.MAX_VALUE) {
            max /= 1000L;
            size /= 1000L;
        }
        if (max > 0L && max >= size) {
            this.bar.setMaximum((int)max);
            this.bar.setValue((int)size);
        } else {
            this.bar.setMaximum(99999999);
            this.bar.setValue(0);
        }
        this.bar.setString(lbl);
    }

    public DirEntry getDirEntry() {
        return this.d;
    }

    public void deselect() {
        this.setBackground(Color.WHITE);
        this.repaint();
    }

    public void select() {
        this.setBackground(Color.LIGHT_GRAY);
        this.repaint();
    }

    @Override
    public Insets getInsets() {
        Insets in = super.getInsets();
        return new Insets(in.top + 3, in.left + 3, in.bottom + 3, in.right + 3);
    }
}

