/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;

class Frame {
    protected ID3v2Frame frame;
    protected ID3v2 id3v2;
    protected String type;

    public Frame(ID3v2 id3v2, String type, byte[] content, boolean tag_preservation, boolean file_preservation, boolean use_compression) {
        try {
            this.frame = new ID3v2Frame(type, content, tag_preservation, file_preservation, false, use_compression ? (byte)2 : 0, 0, 0, true);
        }
        catch (ID3v2DecompressionException e) {
            // empty catch block
        }
        this.id3v2 = id3v2;
        this.type = type;
    }

    public void write() {
        try {
            this.id3v2.removeFrame(this.type);
        }
        catch (ID3v2Exception iD3v2Exception) {
            // empty catch block
        }
        this.id3v2.addFrame(this.frame);
    }

    public static byte[] read(ID3v2 id3v2, String type) {
        try {
            return ((ID3v2Frame)id3v2.getFrame(type).elementAt(0)).getContent();
        }
        catch (ID3v2Exception e) {
            return null;
        }
    }
}

