/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.util.Debug;

public class HTTPUSocket {
    private DatagramSocket ssdpUniSock = null;
    private String localAddr = "";

    public DatagramSocket getDatagramSocket() {
        return this.ssdpUniSock;
    }

    public HTTPUSocket() {
        this.open();
    }

    public HTTPUSocket(String bindAddr, int bindPort) throws IOException {
        this.open(bindAddr, bindPort);
    }

    public HTTPUSocket(int bindPort) {
        this.open(bindPort);
    }

    protected void finalize() {
        this.close();
    }

    public void setLocalAddress(String addr) {
        this.localAddr = addr;
    }

    public String getLocalAddress() {
        if (this.localAddr == null) {
            return null;
        }
        if (0 < this.localAddr.length()) {
            return this.localAddr;
        }
        if (this.ssdpUniSock != null && this.ssdpUniSock.getLocalAddress() != null) {
            return this.ssdpUniSock.getLocalAddress().getHostAddress();
        }
        return null;
    }

    public synchronized boolean open() {
        this.close();
        try {
            this.ssdpUniSock = new DatagramSocket();
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        return true;
    }

    public synchronized boolean open(String bindAddr, int bindPort) throws IOException {
        this.close();
        InetAddress addr = InetAddress.getLocalHost();
        if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) {
            addr = null;
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                block0: while (addr == null && interfaces.hasMoreElements()) {
                    NetworkInterface nif = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = nif.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                        addr = address;
                        continue block0;
                    }
                }
            }
        }
        InetSocketAddress bindSock = new InetSocketAddress(addr, bindPort);
        this.ssdpUniSock = new DatagramSocket(null);
        this.ssdpUniSock.setReuseAddress(true);
        this.ssdpUniSock.bind(bindSock);
        this.setLocalAddress(bindAddr);
        return true;
    }

    public synchronized boolean open(int bindPort) {
        this.close();
        try {
            InetSocketAddress bindSock = new InetSocketAddress(bindPort);
            this.ssdpUniSock = new DatagramSocket(null);
            this.ssdpUniSock.setReuseAddress(true);
            this.ssdpUniSock.bind(bindSock);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public synchronized boolean close() {
        if (this.ssdpUniSock == null) {
            return true;
        }
        try {
            this.ssdpUniSock.close();
            this.ssdpUniSock = null;
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        return true;
    }

    public synchronized boolean post(String addr, int port, String msg) {
        try {
            InetAddress inetAddr = InetAddress.getByName(addr);
            DatagramPacket dgmPacket = new DatagramPacket(msg.getBytes(), msg.length(), inetAddr, port);
            this.ssdpUniSock.send(dgmPacket);
        }
        catch (Exception e) {
            Debug.warning("addr = " + this.ssdpUniSock.getLocalAddress().getHostName());
            Debug.warning("port = " + this.ssdpUniSock.getLocalPort());
            Debug.warning(e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSDPPacket receive() {
        DatagramSocket sock;
        byte[] ssdvRecvBuf = new byte[1024];
        SSDPPacket recvPacket = new SSDPPacket(ssdvRecvBuf, ssdvRecvBuf.length);
        recvPacket.setLocalAddress(this.getLocalAddress());
        HTTPUSocket hTTPUSocket = this;
        synchronized (hTTPUSocket) {
            sock = this.ssdpUniSock;
        }
        if (sock == null) {
            return null;
        }
        try {
            sock.receive(recvPacket.getDatagramPacket());
            recvPacket.setTimeStamp(System.currentTimeMillis());
        }
        catch (Exception e) {
            return null;
        }
        return recvPacket;
    }
}

