/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.ByteUtil;
import de.kapsi.net.daap.chunks.Chunk;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractChunk
implements Chunk {
    private static final int HEADER_SIZE = 8;
    private String contentCode;
    private String name;

    protected AbstractChunk(String contentCode, String name) {
        if (contentCode.length() != 4) {
            throw new IndexOutOfBoundsException("Content Code must have 4 characters");
        }
        this.contentCode = contentCode;
        this.name = name;
    }

    public String getContentCode() {
        return this.contentCode;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return 8 + this.getLength();
    }

    public abstract int getLength();

    public abstract int getType();

    public void serialize(OutputStream out) throws IOException {
        byte[] buffer = new byte[8];
        ByteUtil.toFourCharBytes(this.contentCode, buffer, 0);
        ByteUtil.toByteBE(this.getLength(), buffer, 4);
        out.write(buffer, 0, buffer.length);
    }

    public String toString() {
        return this.name + "('" + this.contentCode + "')";
    }
}

