/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.chunks.IntChunk;

public class VersionChunk
extends IntChunk {
    private int majorVersion;
    private int minorVersion;
    private int patchLevel;

    protected VersionChunk(String type, String name, int value) {
        super(type, name, value);
    }

    protected VersionChunk(String type, String name, int majorVersion, int minorVersion, int patchLevel) {
        super(type, name, 0);
        this.majorVersion = majorVersion & 0xFFFF;
        this.minorVersion = minorVersion & 0xFF;
        this.patchLevel = patchLevel & 0xFF;
        this.setValue(this.createVersion());
    }

    private final int createVersion() {
        return DaapUtil.toVersion(this.majorVersion, this.minorVersion, this.patchLevel);
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion & 0xFFFF;
        this.setValue(this.createVersion());
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion & 0xFF;
        this.setValue(this.createVersion());
    }

    public void setPatchlevel(int patchLevel) {
        this.patchLevel = patchLevel & 0xFF;
        this.setValue(this.createVersion());
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchLevel() {
        return this.patchLevel;
    }

    public int getType() {
        return 11;
    }

    public String toString() {
        return super.toString() + "=" + this.majorVersion + "." + this.minorVersion + "." + this.patchLevel;
    }
}

