/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Iterator;

public class ExtendedEndpoint
extends Endpoint {
    static final long DEFAULT_TIME_RECORDED = 0L;
    private long timeRecorded = -1L;
    static final int DEFAULT_DAILY_UPTIME = 345;
    private int dailyUptime = -1;
    static final int HISTORY_SIZE = 3;
    static final long WINDOW_TIME = 86400000L;
    private Buffer connectSuccesses = new Buffer(3);
    private Buffer connectFailures = new Buffer(3);
    private String _clientLocale = ApplicationSettings.DEFAULT_LOCALE.getValue();
    private int udpHostCacheFailures = -1;
    private static final String ownLocale = ApplicationSettings.LANGUAGE.getValue();
    private static final String LIST_SEPARATOR = ";";
    private static final String FIELD_SEPARATOR = ",";
    static final String EOL = "\n";
    private static final Comparator PRIORITY_COMPARATOR = new PriorityComparator();

    public ExtendedEndpoint(String host, int port, int dailyUptime) {
        super(host, port);
        this.dailyUptime = dailyUptime;
        this.timeRecorded = this.now();
    }

    public ExtendedEndpoint(String host, int port) {
        super(host, port);
        this.timeRecorded = this.now();
    }

    public ExtendedEndpoint(String host, int port, boolean strict) {
        super(host, port, strict);
        this.timeRecorded = this.now();
    }

    public ExtendedEndpoint(String host, int port, int dailyUptime, String locale) {
        super(host, port);
        this.dailyUptime = dailyUptime;
        this.timeRecorded = this.now();
        this._clientLocale = locale;
    }

    public ExtendedEndpoint(String host, int port, String locale) {
        this(host, port);
        this._clientLocale = locale;
    }

    public long getTimeRecorded() {
        if (this.timeRecorded < 0L) {
            return 0L;
        }
        return this.timeRecorded;
    }

    public int getDailyUptime() {
        if (this.dailyUptime < 0) {
            return 345;
        }
        return this.dailyUptime;
    }

    public void setDailyUptime(int uptime) {
        this.dailyUptime = uptime;
    }

    public void recordConnectionSuccess() {
        this.recordConnectionAttempt(this.connectSuccesses, this.now());
    }

    public void recordConnectionFailure() {
        this.recordConnectionAttempt(this.connectFailures, this.now());
    }

    public Iterator getConnectionSuccesses() {
        return this.connectSuccesses.iterator();
    }

    public Iterator getConnectionFailures() {
        return this.connectFailures.iterator();
    }

    public String getClientLocale() {
        return this._clientLocale;
    }

    public void setClientLocale(String l) {
        this._clientLocale = l;
    }

    public boolean isUDPHostCache() {
        return this.udpHostCacheFailures != -1;
    }

    public void recordUDPHostCacheFailure() {
        Assert.that(this.isUDPHostCache());
        ++this.udpHostCacheFailures;
    }

    public void decrementUDPHostCacheFailure() {
        Assert.that(this.isUDPHostCache());
        this.udpHostCacheFailures = Math.max(0, this.udpHostCacheFailures - 1);
    }

    public void recordUDPHostCacheSuccess() {
        Assert.that(this.isUDPHostCache());
        this.udpHostCacheFailures = 0;
    }

    public int getUDPHostCacheFailures() {
        return this.udpHostCacheFailures;
    }

    public ExtendedEndpoint setUDPHostCache(boolean cache) {
        this.udpHostCacheFailures = cache ? 0 : -1;
        return this;
    }

    private void recordConnectionAttempt(Buffer buf, long now) {
        if (buf.isEmpty()) {
            buf.addFirst(new Long(now));
        } else if (now - (Long)buf.first() >= 86400000L) {
            buf.addFirst(new Long(now));
        } else {
            buf.removeFirst();
            buf.addFirst(new Long(now));
        }
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    public void write(Writer out) throws IOException {
        out.write(this.getAddress());
        out.write(":");
        out.write(this.getPort() + "");
        out.write(FIELD_SEPARATOR);
        if (this.dailyUptime >= 0) {
            out.write(this.dailyUptime + "");
        }
        out.write(FIELD_SEPARATOR);
        if (this.timeRecorded >= 0L) {
            out.write(this.timeRecorded + "");
        }
        out.write(FIELD_SEPARATOR);
        this.write(out, this.getConnectionSuccesses());
        out.write(FIELD_SEPARATOR);
        this.write(out, this.getConnectionFailures());
        out.write(FIELD_SEPARATOR);
        out.write(this._clientLocale);
        out.write(FIELD_SEPARATOR);
        if (this.isUDPHostCache()) {
            out.write(this.udpHostCacheFailures + "");
        }
        out.write(EOL);
    }

    private void write(Writer out, Iterator objects) throws IOException {
        while (objects.hasNext()) {
            out.write(objects.next().toString());
            if (!objects.hasNext()) continue;
            out.write(LIST_SEPARATOR);
        }
    }

    public static ExtendedEndpoint read(String line) throws ParseException {
        int i;
        String[] times;
        boolean pureNumeric;
        int port;
        String host;
        String[] linea = StringUtils.splitNoCoalesce(line, FIELD_SEPARATOR);
        if (linea.length == 0) {
            throw new ParseException("Empty line", 0);
        }
        try {
            Endpoint tmp = new Endpoint(linea[0], true);
            host = tmp.getAddress();
            port = tmp.getPort();
            pureNumeric = true;
        }
        catch (IllegalArgumentException e) {
            try {
                Endpoint tmp = new Endpoint(linea[0], false, false);
                host = tmp.getAddress();
                port = tmp.getPort();
                pureNumeric = false;
            }
            catch (IllegalArgumentException e2) {
                ParseException e3 = new ParseException("Couldn't extract address and port from: " + linea[0], 0);
                if (CommonUtils.isJava14OrLater()) {
                    e3.initCause(e2);
                }
                throw e3;
            }
        }
        ExtendedEndpoint ret = new ExtendedEndpoint(host, port, false);
        if (linea.length >= 2) {
            try {
                ret.dailyUptime = Integer.parseInt(linea[1].trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        ret.timeRecorded = 0L;
        if (linea.length >= 3) {
            try {
                ret.timeRecorded = Long.parseLong(linea[2].trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (linea.length >= 4) {
            try {
                times = StringUtils.split(linea[3], LIST_SEPARATOR);
                for (i = times.length - 1; i >= 0; --i) {
                    ret.recordConnectionAttempt(ret.connectSuccesses, Long.parseLong(times[i].trim()));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (linea.length >= 5) {
            try {
                times = StringUtils.split(linea[4], LIST_SEPARATOR);
                for (i = times.length - 1; i >= 0; --i) {
                    ret.recordConnectionAttempt(ret.connectFailures, Long.parseLong(times[i].trim()));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (linea.length >= 6) {
            ret.setClientLocale(linea[5]);
        }
        if (linea.length >= 7) {
            try {
                int i2 = Integer.parseInt(linea[6]);
                if (i2 >= 0) {
                    ret.udpHostCacheFailures = i2;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (pureNumeric && !NetworkUtils.isValidAddress(host)) {
            throw new ParseException("invalid dotted addr: " + ret, 0);
        }
        if (!ret.isUDPHostCache() && !pureNumeric) {
            throw new ParseException("illegal non-UHC endpoint: " + ret, 0);
        }
        return ret;
    }

    public static Comparator priorityComparator() {
        return PRIORITY_COMPARATOR;
    }

    private int localeScore() {
        if (!ConnectionSettings.USE_LOCALE_PREF.getValue()) {
            return 0;
        }
        if (ownLocale.equals(this._clientLocale)) {
            return 1;
        }
        return -1;
    }

    private int connectScore() {
        long failure;
        if (this.connectSuccesses.isEmpty() && this.connectFailures.isEmpty()) {
            return 0;
        }
        if (this.connectSuccesses.isEmpty()) {
            return -1;
        }
        if (this.connectFailures.isEmpty()) {
            return 1;
        }
        long success = (Long)this.connectSuccesses.last();
        if (success > (failure = ((Long)this.connectFailures.last()).longValue())) {
            return 1;
        }
        if (success < failure) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    static class PriorityComparator
    implements Comparator {
        PriorityComparator() {
        }

        public int compare(Object extEndpoint1, Object extEndpoint2) {
            ExtendedEndpoint a = (ExtendedEndpoint)extEndpoint1;
            ExtendedEndpoint b = (ExtendedEndpoint)extEndpoint2;
            int ret = a.connectScore() - b.connectScore();
            if (ret != 0) {
                return ret;
            }
            ret = a.localeScore() - b.localeScore();
            if (ret != 0) {
                return ret;
            }
            return a.getDailyUptime() - b.getDailyUptime();
        }
    }
}

