/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortImpl;
import com.limegroup.gnutella.util.NetworkUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;

public class PushEndpointForSelf
extends PushEndpoint {
    private static PushEndpointForSelf _instance;

    private PushEndpointForSelf() {
        super(RouterService.getMyGUID(), Collections.EMPTY_SET, 0, 1);
    }

    public static PushEndpointForSelf instance() {
        if (_instance == null) {
            _instance = new PushEndpointForSelf();
        }
        return _instance;
    }

    public Set getProxies() {
        return RouterService.getConnectionManager().getPushProxies();
    }

    public int getFeatures() {
        return 0;
    }

    public int supportsFWTVersion() {
        return UDPService.instance().canDoFWT() ? 1 : 0;
    }

    public String getAddress() {
        byte[] addr = RouterService.getExternalAddress();
        if (NetworkUtils.isValidAddress(addr) && !NetworkUtils.isPrivateAddress(addr)) {
            return NetworkUtils.ip2string(addr);
        }
        return "1.1.1.1";
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.getAddress());
        }
        catch (UnknownHostException bad) {
            return null;
        }
    }

    public int getPort() {
        if (UDPService.instance().canDoFWT() && !RouterService.acceptedIncomingConnection()) {
            return UDPService.instance().getStableUDPPort();
        }
        return RouterService.getPort();
    }

    protected IpPort getValidExternalAddress() {
        try {
            String addr = this.getAddress();
            int port = this.getPort();
            if (addr.equals("1.1.1.1") || !NetworkUtils.isValidPort(port)) {
                return null;
            }
            return new IpPortImpl(addr, this.getPort());
        }
        catch (UnknownHostException bad) {
            return null;
        }
    }
}

