/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollector;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.util.FixedSizeSortedSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class AlternateLocationCollection
implements HTTPHeaderValue,
AlternateLocationCollector {
    private static final int MAX_SIZE = 100;
    private final FixedSizeSortedSet LOCATIONS = new FixedSizeSortedSet(100);
    private final URN SHA1;
    static /* synthetic */ Class class$com$limegroup$gnutella$altlocs$AlternateLocationCollection;

    public static AlternateLocationCollection create(URN sha1) {
        return new AlternateLocationCollection(sha1);
    }

    public static AlternateLocationCollection createCollectionFromHttpValue(String value) {
        if (value == null) {
            throw new NullPointerException("cannot create an AlternateLocationCollection from a null value");
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        AlternateLocationCollection alc = null;
        while (st.hasMoreTokens()) {
            String curTok = st.nextToken();
            try {
                AlternateLocation al = AlternateLocation.create(curTok);
                if (alc == null) {
                    alc = new AlternateLocationCollection(al.getSHA1Urn());
                }
                if (!al.getSHA1Urn().equals(alc.getSHA1Urn())) continue;
                alc.add(al);
            }
            catch (IOException e) {}
        }
        return alc;
    }

    private AlternateLocationCollection(URN sha1) {
        if (sha1 == null) {
            throw new NullPointerException("null URN");
        }
        if (sha1 != null && !sha1.isSHA1()) {
            throw new IllegalArgumentException("URN must be a SHA1");
        }
        this.SHA1 = sha1;
    }

    public URN getSHA1Urn() {
        return this.SHA1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(AlternateLocation al) {
        URN sha1 = al.getSHA1Urn();
        if (!sha1.equals(this.SHA1)) {
            throw new IllegalArgumentException("SHA1 does not match");
        }
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            AlternateLocation alt = (AlternateLocation)this.LOCATIONS.get(al);
            boolean ret = false;
            if (alt == null) {
                ret = true;
                this.LOCATIONS.add(al);
            } else {
                this.LOCATIONS.remove(alt);
                alt.increment();
                alt.promote();
                ret = false;
                this.LOCATIONS.add(alt);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(AlternateLocation al) {
        URN sha1 = al.getSHA1Urn();
        if (!sha1.equals(this.SHA1)) {
            return false;
        }
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            AlternateLocation loc = (AlternateLocation)this.LOCATIONS.get(al);
            if (loc == null) {
                return false;
            }
            if (loc.isDemoted()) {
                this.LOCATIONS.remove(loc);
                return true;
            }
            this.LOCATIONS.remove(loc);
            loc.demote();
            this.LOCATIONS.add(loc);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAll(AlternateLocationCollection alc) {
        if (alc == null) {
            throw new NullPointerException("ALC is null");
        }
        if (!alc.getSHA1Urn().equals(this.SHA1)) {
            throw new IllegalArgumentException("SHA1 does not match");
        }
        int added = 0;
        Iterator iter = null;
        AlternateLocationCollection alternateLocationCollection = alc;
        synchronized (alternateLocationCollection) {
            iter = ((FixedSizeSortedSet)alc.LOCATIONS.clone()).iterator();
        }
        while (iter.hasNext()) {
            AlternateLocation curLoc = (AlternateLocation)iter.next();
            if (!this.add(curLoc)) continue;
            ++added;
        }
        return added;
    }

    public synchronized void clear() {
        this.LOCATIONS.clear();
    }

    public synchronized boolean hasAlternateLocations() {
        return !this.LOCATIONS.isEmpty();
    }

    public synchronized boolean contains(AlternateLocation loc) {
        return this.LOCATIONS.contains(loc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpStringValue() {
        String commaSpace = ", ";
        StringBuffer writeBuffer = new StringBuffer();
        boolean wrote = false;
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            Iterator iter = this.LOCATIONS.iterator();
            while (iter.hasNext()) {
                AlternateLocation current = (AlternateLocation)iter.next();
                writeBuffer.append(current.httpStringValue());
                writeBuffer.append(", ");
                wrote = true;
            }
        }
        if (wrote) {
            writeBuffer.setLength(writeBuffer.length() - 2);
        }
        return writeBuffer.toString();
    }

    public synchronized int getAltLocsSize() {
        return this.LOCATIONS.size();
    }

    public Iterator iterator() {
        return this.LOCATIONS.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Alternate Locations: ");
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            Iterator iter = this.LOCATIONS.iterator();
            while (iter.hasNext()) {
                AlternateLocation curLoc = (AlternateLocation)iter.next();
                sb.append(curLoc.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlternateLocationCollection)) {
            return false;
        }
        AlternateLocationCollection alc = (AlternateLocationCollection)o;
        boolean ret = this.SHA1.equals(alc.SHA1);
        if (!ret) {
            return false;
        }
        Class clazz = class$com$limegroup$gnutella$altlocs$AlternateLocationCollection == null ? (class$com$limegroup$gnutella$altlocs$AlternateLocationCollection = AlternateLocationCollection.class$("com.limegroup.gnutella.altlocs.AlternateLocationCollection")) : class$com$limegroup$gnutella$altlocs$AlternateLocationCollection;
        synchronized (clazz) {
            AlternateLocationCollection alternateLocationCollection = this;
            synchronized (alternateLocationCollection) {
                AlternateLocationCollection alternateLocationCollection2 = alc;
                synchronized (alternateLocationCollection2) {
                    ret = this.LOCATIONS.equals(alc.LOCATIONS);
                }
            }
        }
        return ret;
    }

    public byte[] toBytes() {
        return this.toBytes(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(int number) {
        FixedSizeSortedSet clone = null;
        if (number <= 0) {
            return null;
        }
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            clone = (FixedSizeSortedSet)this.LOCATIONS.clone();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Iterator iter = clone.iterator();
            while (iter.hasNext() && number > 0) {
                Object o = iter.next();
                if (!(o instanceof DirectAltLoc)) continue;
                DirectAltLoc current = (DirectAltLoc)o;
                byte[] addr = current.getHost().getInetAddress().getAddress();
                baos.write(addr);
                ByteOrder.short2leb((short)current.getHost().getPort(), baos);
                --number;
            }
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
        }
        return baos.toByteArray();
    }

    public byte[] toBytesPush() {
        return this.toBytesPush(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytesPush(int number) {
        FixedSizeSortedSet clone;
        if (number <= 0) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            clone = (FixedSizeSortedSet)this.LOCATIONS.clone();
        }
        int total = 0;
        try {
            Iterator iter = clone.iterator();
            while (iter.hasNext() && total < number) {
                PushAltLoc current;
                Object o = iter.next();
                if (!(o instanceof PushAltLoc) || (current = (PushAltLoc)o).getPushAddress().getProxies().isEmpty()) continue;
                baos.write(current.getPushAddress().toBytes());
                ++total;
            }
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
        }
        return baos.toByteArray();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

