/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointForSelf;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public class PushAltLoc
extends AlternateLocation {
    private final PushEndpoint _pushAddress;

    protected PushAltLoc(PushEndpoint address, URN sha1) throws IOException {
        super(sha1);
        if (address == null) {
            throw new IOException("null address");
        }
        this._pushAddress = address;
    }

    protected PushAltLoc(URN sha1) throws IOException {
        super(sha1);
        this._pushAddress = PushEndpointForSelf.instance();
    }

    protected String generateHTTPString() {
        return this._pushAddress.httpStringValue();
    }

    public RemoteFileDesc createRemoteFileDesc(int size) {
        HashSet<URN> urnSet = new HashSet<URN>();
        urnSet.add(this.getSHA1Urn());
        int quality = 3;
        RemoteFileDesc ret = new RemoteFileDesc(this._pushAddress.getAddress(), this._pushAddress.getPort(), 0L, "/uri-res/N2R?" + this.SHA1_URN, size, 1000, true, quality, false, null, urnSet, false, true, "ALT", System.currentTimeMillis(), -1L, this._pushAddress);
        return ret;
    }

    public synchronized AlternateLocation createClone() {
        PushAltLoc ret = null;
        try {
            ret = new PushAltLoc(this._pushAddress, this.SHA1_URN);
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
            return null;
        }
        ret._count = this._count;
        return ret;
    }

    public boolean isMe() {
        return Arrays.equals(this._pushAddress.getClientGUID(), RouterService.getMyGUID());
    }

    public void updateProxies(boolean isGood) {
        this._pushAddress.updateProxies(isGood);
    }

    public PushEndpoint getPushAddress() {
        return this._pushAddress;
    }

    public int supportsFWTVersion() {
        return this._pushAddress.supportsFWTVersion();
    }

    void promote() {
    }

    void demote() {
    }

    public boolean isDemoted() {
        return this._pushAddress.getProxies().isEmpty();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PushAltLoc)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PushAltLoc other = (PushAltLoc)o;
        return this._pushAddress.equals(other._pushAddress);
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        int ret = super.compareTo(obj);
        if (ret != 0) {
            return ret;
        }
        if (!(obj instanceof PushAltLoc)) {
            return 1;
        }
        PushAltLoc pal = (PushAltLoc)obj;
        return GUID.GUID_BYTE_COMPARATOR.compare(this._pushAddress.getClientGUID(), pal.getPushAddress().getClientGUID());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = super.hashCode();
            this.hashCode = result = 37 * result + this._pushAddress.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._pushAddress + "," + this._count;
    }
}

