/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.chat;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.util.Comparators;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class ChatManager {
    private static final ChatManager CHAT_MANAGER = new ChatManager();
    private List _chatsInProgress = Collections.synchronizedList(new LinkedList());

    public static ChatManager instance() {
        return CHAT_MANAGER;
    }

    public void accept(Socket socket) {
        Thread.currentThread().setName("IncommingChatThread");
        boolean allowChats = ChatSettings.CHAT_ENABLED.getValue();
        if (!allowChats) {
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        String host = socket.getInetAddress().getHostAddress();
        String[] bannedIPs = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        List<String> bannedList = Arrays.asList(bannedIPs);
        if (bannedList.contains(host)) {
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        try {
            ActivityCallback callback = RouterService.getCallback();
            InstantMessenger im = new InstantMessenger(socket, this, callback);
            this._chatsInProgress.add(im);
            callback.acceptChat(im);
            im.start();
        }
        catch (IOException e) {
            try {
                socket.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
        }
    }

    public Chatter request(String host, int port) {
        InstantMessenger im = null;
        try {
            ActivityCallback callback = RouterService.getCallback();
            im = new InstantMessenger(host, port, this, callback);
            this._chatsInProgress.add(im);
            im.start();
        }
        catch (IOException e) {
            // empty catch block
        }
        return im;
    }

    public void removeChat(InstantMessenger chat) {
        this._chatsInProgress.remove(chat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockHost(String host) {
        String[] bannedIPs = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        Arrays.sort(bannedIPs, Comparators.stringComparator());
        ChatManager chatManager = this;
        synchronized (chatManager) {
            if (Arrays.binarySearch(bannedIPs, host, Comparators.stringComparator()) < 0) {
                String[] more_banned = new String[bannedIPs.length + 1];
                System.arraycopy(bannedIPs, 0, more_banned, 0, bannedIPs.length);
                more_banned[bannedIPs.length] = host;
                FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue(more_banned);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblockHost(String host) {
        String[] bannedIPs = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        List<String> bannedList = Arrays.asList(bannedIPs);
        ChatManager chatManager = this;
        synchronized (chatManager) {
            if (bannedList.remove(host)) {
                FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue((String[])bannedList.toArray());
            }
        }
    }
}

