/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.settings.DaapSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import de.kapsi.net.daap.DaapAuthenticator;
import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapFilter;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapServerFactory;
import de.kapsi.net.daap.DaapStreamSource;
import de.kapsi.net.daap.DaapThreadFactory;
import de.kapsi.net.daap.Database;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.Playlist;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.Transaction;
import de.kapsi.net.daap.TransactionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DaapManager
implements FinalizeListener,
TransactionListener {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$gui$DaapManager == null ? (class$com$limegroup$gnutella$gui$DaapManager = DaapManager.class$("com.limegroup.gnutella.gui.DaapManager")) : class$com$limegroup$gnutella$gui$DaapManager);
    private static final DaapManager INSTANCE = new DaapManager();
    private static final String AUDIO_SCHEMA = "http://www.limewire.com/schemas/audio.xsd";
    private SongURNMap map;
    private Library library;
    private Database database;
    private Playlist whatsNew;
    private Playlist creativecommons;
    private DaapServer server;
    private RendezvousService rendezvous;
    private boolean annotateEnabled = false;
    private int maxPlaylistSize;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$DaapManager;

    public static DaapManager instance() {
        return INSTANCE;
    }

    private DaapManager() {
        if (!CommonUtils.isJava14OrLater()) {
            throw new RuntimeException("Cannot instance DaapManager");
        }
        GUIMediator.addFinalizeListener(this);
    }

    public synchronized void init() {
        if (this.isServerRunning()) {
            this.setAnnotateEnabled(this.annotateEnabled);
        }
    }

    public synchronized void start() throws IOException {
        if (!this.isServerRunning()) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) {
                    addr = null;
                    Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                    if (interfaces != null) {
                        block4: while (addr == null && interfaces.hasMoreElements()) {
                            NetworkInterface nif = interfaces.nextElement();
                            Enumeration<InetAddress> addresses = nif.getInetAddresses();
                            while (addresses.hasMoreElements()) {
                                InetAddress address = addresses.nextElement();
                                if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                                addr = address;
                                continue block4;
                            }
                        }
                    }
                }
                if (addr == null) {
                    this.stop();
                    return;
                }
                this.rendezvous = new RendezvousService(addr);
                this.map = new SongURNMap();
                this.maxPlaylistSize = DaapSettings.DAAP_MAX_LIBRARY_SIZE.getValue();
                String name = DaapSettings.DAAP_LIBRARY_NAME.getValue();
                int revisions = DaapSettings.DAAP_LIBRARY_REVISIONS.getValue();
                boolean useLibraryGC = DaapSettings.DAAP_LIBRARY_GC.getValue();
                this.library = new Library(name, revisions, useLibraryGC);
                this.database = new Database(name);
                this.whatsNew = new Playlist(GUIMediator.getStringResource("SEARCH_TYPE_WHATSNEW"));
                this.creativecommons = new Playlist(GUIMediator.getStringResource("LICENSE_CC"));
                Transaction txn = this.library.open(false);
                this.library.add(txn, this.database);
                this.database.add(txn, this.creativecommons);
                this.database.add(txn, this.whatsNew);
                this.creativecommons.setSmartPlaylist(txn, true);
                this.whatsNew.setSmartPlaylist(txn, true);
                txn.commit();
                LimeConfig config = new LimeConfig(addr);
                boolean NIO = DaapSettings.DAAP_USE_NIO.getValue();
                this.server = DaapServerFactory.createServer(this.library, config, NIO);
                this.server.setAuthenticator(new LimeAuthenticator());
                this.server.setStreamSource(new LimeStreamSource());
                this.server.setFilter(new LimeFilter());
                if (!NIO) {
                    this.server.setThreadFactory(new LimeThreadFactory());
                }
                int maxAttempts = 10;
                for (int i = 0; i < 10; ++i) {
                    try {
                        this.server.bind();
                        break;
                    }
                    catch (BindException bindErr) {
                        if (i >= 9) {
                            throw bindErr;
                        }
                        config.nextPort();
                        continue;
                    }
                }
                ManagedThread serverThread = new ManagedThread((Runnable)this.server, "DaapServerThread"){

                    protected void managedRun() {
                        block3: {
                            try {
                                super.managedRun();
                            }
                            catch (Throwable t) {
                                DaapManager.this.stop();
                                if (DaapManager.this.handleError(t)) break block3;
                                GUIMediator.showError("ERROR_DAAP_RUN_ERROR");
                                DaapSettings.DAAP_ENABLED.setValue(false);
                                if (t instanceof RuntimeException) {
                                    throw (RuntimeException)t;
                                }
                                throw new RuntimeException(t);
                            }
                        }
                    }
                };
                serverThread.setDaemon(true);
                serverThread.start();
                this.rendezvous.registerService();
            }
            catch (IOException err) {
                this.stop();
                throw err;
            }
        }
    }

    public synchronized void stop() {
        if (this.rendezvous != null) {
            this.rendezvous.close();
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (this.map != null) {
            this.map.clear();
        }
        this.rendezvous = null;
        this.server = null;
        this.map = null;
        this.library = null;
        this.whatsNew = null;
        this.creativecommons = null;
        this.database = null;
    }

    public synchronized void restart() throws IOException {
        if (this.isServerRunning()) {
            this.stop();
        }
        this.start();
        this.init();
    }

    public void doFinalize() {
        this.stop();
    }

    public synchronized void updateService() throws IOException {
        if (this.isServerRunning()) {
            this.rendezvous.updateService();
            Transaction txn = this.library.open(false);
            String name = DaapSettings.DAAP_LIBRARY_NAME.getValue();
            this.library.setName(txn, name);
            this.database.setName(txn, name);
            txn.commit();
            this.server.update();
        }
    }

    public synchronized void disconnectAll() {
        if (this.isServerRunning()) {
            this.server.disconnectAll();
        }
    }

    public synchronized boolean isServerRunning() {
        if (this.server != null) {
            return this.server.isRunning();
        }
        return false;
    }

    private boolean handleError(Throwable t) {
        if (t == null) {
            return false;
        }
        String msg = t.getMessage();
        if (msg == null || msg.indexOf("Unable to establish loopback connection") == -1) {
            return this.handleError(t.getCause());
        }
        if (CommonUtils.isWindowsXP()) {
            int answer = GUIMediator.showYesNoCancelMessage("ERROR_DAAP_LOOPBACK_FAILED");
            switch (answer) {
                case 101: {
                    GUIMediator.openURL("http://support.microsoft.com/default.aspx?kbid=884020");
                    break;
                }
                case 102: {
                    DaapSettings.DAAP_ENABLED.setValue(false);
                }
            }
        } else {
            int answer = GUIMediator.showYesNoMessage("ERROR_DAAP_LOOPBACK_FAILED_NONXP");
            if (answer == 102) {
                DaapSettings.DAAP_ENABLED.setValue(false);
            }
        }
        return true;
    }

    private static boolean isSupportedFormat(String name) {
        String[] types = DaapSettings.DAAP_SUPPORTED_FILE_TYPES.getValue();
        for (int i = 0; i < types.length; ++i) {
            if (!name.endsWith(types[i])) continue;
            return true;
        }
        return false;
    }

    private void handleChangeEvent(FileManagerEvent evt) {
        FileDesc oldDesc = evt.getFileDesc()[0];
        Song song = this.map.remove(oldDesc.getSHA1Urn());
        if (song != null) {
            FileDesc newDesc = evt.getFileDesc()[1];
            this.map.put(song, newDesc.getSHA1Urn());
            String format = song.getFormat();
            if (this.updateSongMeta(song, newDesc)) {
                Transaction txn = this.library.open(true);
                txn.addTransactionListener(this);
                this.database.update(txn, song);
            }
        }
    }

    private void handleAddEvent(FileManagerEvent evt) {
        String name;
        if (this.database.getMasterPlaylist().size() >= this.maxPlaylistSize) {
            return;
        }
        FileDesc file = evt.getFileDesc()[0];
        if (!(file instanceof IncompleteFileDesc) && DaapManager.isSupportedFormat(name = file.getName().toLowerCase(Locale.US))) {
            Song song = this.createSong(file);
            this.map.put(song, file.getSHA1Urn());
            Transaction txn = this.library.open(true);
            txn.addTransactionListener(this);
            this.database.getMasterPlaylist().add(txn, song);
            this.whatsNew.add(txn, song);
            if (file.isLicensed()) {
                this.creativecommons.add(txn, song);
            }
        }
    }

    private void handleRenameEvent(FileManagerEvent evt) {
        FileDesc oldDesc = evt.getFileDesc()[0];
        Song song = this.map.remove(oldDesc.getSHA1Urn());
        if (song != null) {
            FileDesc newDesc = evt.getFileDesc()[1];
            this.map.put(song, newDesc.getSHA1Urn());
        }
    }

    private void handleRemoveEvent(FileManagerEvent evt) {
        FileDesc file = evt.getFileDesc()[0];
        Song song = this.map.remove(file.getSHA1Urn());
        if (song != null) {
            Transaction txn = this.library.open(true);
            txn.addTransactionListener(this);
            this.database.remove(txn, song);
        }
    }

    public synchronized void handleFileManagerEvent(FileManagerEvent evt) {
        if (!this.isServerRunning()) {
            return;
        }
        if (evt.isChangeEvent()) {
            this.handleChangeEvent(evt);
        } else if (evt.isAddEvent()) {
            this.handleAddEvent(evt);
        } else if (evt.isRenameEvent()) {
            this.handleRenameEvent(evt);
        } else if (evt.isRemoveEvent()) {
            this.handleRemoveEvent(evt);
        }
    }

    public synchronized void setAnnotateEnabled(boolean enabled) {
        this.annotateEnabled = enabled;
        if (!this.isServerRunning() || !enabled) {
            return;
        }
        int size = this.database.getMasterPlaylist().size();
        Transaction txn = this.library.open(false);
        SongURNMap tmpMap = new SongURNMap();
        FileDesc[] files = RouterService.getFileManager().getAllSharedFileDescriptors();
        for (int i = 0; i < files.length; ++i) {
            String name;
            FileDesc file = files[i];
            if (file instanceof IncompleteFileDesc || !DaapManager.isSupportedFormat(name = file.getName().toLowerCase(Locale.US))) continue;
            URN urn = file.getSHA1Urn();
            Song song = this.map.remove(urn);
            if (tmpMap.contains(urn)) continue;
            if (song != null) {
                tmpMap.put(song, urn);
                if (!this.updateSongMeta(song, file)) continue;
                this.database.update(txn, song);
                continue;
            }
            if (size >= this.maxPlaylistSize) continue;
            song = this.createSong(file);
            tmpMap.put(song, urn);
            this.database.getMasterPlaylist().add(txn, song);
            if (file.isLicensed()) {
                this.creativecommons.add(txn, song);
            }
            ++size;
        }
        Iterator it = this.map.getSongIterator();
        while (it.hasNext()) {
            Song song = (Song)it.next();
            this.database.remove(txn, song);
        }
        this.map.clear();
        this.map = tmpMap;
        txn.addTransactionListener(this);
        txn.commit();
    }

    private Song createSong(FileDesc desc) {
        Song song = new Song(desc.getName());
        song.setSize((int)desc.getSize());
        song.setDateAdded((int)(System.currentTimeMillis() / 1000L));
        File file = desc.getFile();
        String ext = FileUtils.getFileExtension(file);
        if (ext != null) {
            song.setFormat(ext.toLowerCase(Locale.US));
            this.updateSongMeta(song, desc);
        }
        return song;
    }

    private boolean updateSongMeta(Song song, FileDesc desc) {
        String currentTitle;
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection collection = map.getReplyCollection(AUDIO_SCHEMA);
        if (collection == null) {
            LOG.error("LimeXMLReplyCollection is null");
            return false;
        }
        LimeXMLDocument doc = collection.getDocForHash(desc.getSHA1Urn());
        if (doc == null) {
            return false;
        }
        boolean update = false;
        String title = doc.getValue("audios__audio__title__");
        String track = doc.getValue("audios__audio__track__");
        String artist = doc.getValue("audios__audio__artist__");
        String album = doc.getValue("audios__audio__album__");
        String genre = doc.getValue("audios__audio__genre__");
        String bitrate = doc.getValue("audios__audio__bitrate__");
        String comments = doc.getValue("audios__audio__comments__");
        String time = doc.getValue("audios__audio__seconds__");
        String year = doc.getValue("audios__audio__year__");
        if (!(title == null || (currentTitle = song.getName()) != null && title.equals(currentTitle))) {
            update = true;
            song.setName(title);
        }
        int currentTrack = song.getTrackNumber();
        if (track != null) {
            try {
                int num = Integer.parseInt(track);
                if (num > 0 && num != currentTrack) {
                    update = true;
                    song.setTrackNumber(num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentTrack != 0) {
            update = true;
            song.setTrackNumber(0);
        }
        String currentArtist = song.getArtist();
        if (artist != null) {
            if (currentArtist == null || !artist.equals(currentArtist)) {
                update = true;
                song.setArtist(artist);
            }
        } else if (currentArtist != null) {
            update = true;
            song.setArtist(null);
        }
        String currentAlbum = song.getAlbum();
        if (album != null) {
            if (currentAlbum == null || !album.equals(currentAlbum)) {
                update = true;
                song.setAlbum(album);
            }
        } else if (currentAlbum != null) {
            update = true;
            song.setAlbum(null);
        }
        String currentGenre = song.getGenre();
        if (genre != null) {
            if (currentGenre == null || !genre.equals(currentGenre)) {
                update = true;
                song.setGenre(genre);
            }
        } else if (currentGenre != null) {
            update = true;
            song.setGenre(null);
        }
        String currentComments = song.getComment();
        if (comments != null) {
            if (currentComments == null || !comments.equals(currentComments)) {
                update = true;
                song.setComment(comments);
            }
        } else if (currentComments != null) {
            update = true;
            song.setComment(null);
        }
        int currentBitrate = song.getBitrate();
        if (bitrate != null) {
            try {
                int num = Integer.parseInt(bitrate);
                if (num > 0 && num != currentBitrate) {
                    update = true;
                    song.setBitrate(num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentBitrate != 0) {
            update = true;
            song.setBitrate(0);
        }
        int currentTime = song.getTime();
        if (time != null) {
            try {
                int num = Integer.parseInt(time) * 1000;
                if (num > 0 && num != currentTime) {
                    update = true;
                    song.setTime(num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentTime != 0) {
            update = true;
            song.setTime(0);
        }
        int currentYear = song.getYear();
        if (year != null) {
            try {
                int num = Integer.parseInt(year);
                if (num > 0 && num != currentYear) {
                    update = true;
                    song.setYear(num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentYear != 0) {
            update = true;
            song.setYear(0);
        }
        int mod = (int)(desc.lastModified() / 1000L);
        if (song.getDateModified() != mod) {
            update = true;
            song.setDateModified(mod);
        }
        return update;
    }

    public synchronized void commit(Transaction txn) {
        if (this.isServerRunning()) {
            this.server.update();
        }
    }

    public void rollback(Transaction txn) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class SongURNMap {
        private HashMap songToUrn = new HashMap();
        private HashMap urnToSong = new HashMap();

        public void put(Song song, URN urn) {
            this.songToUrn.put(song, urn);
            this.urnToSong.put(urn, song);
        }

        public URN get(Song song) {
            return (URN)this.songToUrn.get(song);
        }

        public Song get(URN urn) {
            return (Song)this.urnToSong.get(urn);
        }

        public Song remove(URN urn) {
            Song song = (Song)this.urnToSong.remove(urn);
            if (song != null) {
                this.songToUrn.remove(song);
            }
            return song;
        }

        public URN remove(Song song) {
            URN urn = (URN)this.songToUrn.remove(song);
            if (urn != null) {
                this.urnToSong.remove(urn);
            }
            return urn;
        }

        public boolean contains(URN urn) {
            return this.urnToSong.containsKey(urn);
        }

        public boolean contains(Song song) {
            return this.songToUrn.containsKey(song);
        }

        public Iterator getSongIterator() {
            return this.songToUrn.keySet().iterator();
        }

        public Iterator getURNIterator() {
            return this.urnToSong.keySet().iterator();
        }

        public void clear() {
            this.urnToSong.clear();
            this.songToUrn.clear();
        }

        public int size() {
            return this.songToUrn.size();
        }
    }

    private final class RendezvousService {
        private static final String VERSION = "Version";
        private static final String MACHINE_NAME = "Machine Name";
        private static final String PASSWORD = "Password";
        private final JmDNS zeroConf;
        private ServiceInfo service;

        public RendezvousService(InetAddress addr) throws IOException {
            this.zeroConf = new JmDNS(addr);
        }

        public boolean isRegistered() {
            return this.service != null;
        }

        private ServiceInfo createServiceInfo() {
            String type = DaapSettings.DAAP_TYPE_NAME.getValue();
            String name = DaapSettings.DAAP_SERVICE_NAME.getValue();
            int port = DaapSettings.DAAP_PORT.getValue();
            int weight = DaapSettings.DAAP_WEIGHT.getValue();
            int priority = DaapSettings.DAAP_PRIORITY.getValue();
            boolean password = DaapSettings.DAAP_REQUIRES_PASSWORD.getValue();
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put(VERSION, Integer.toString(196608));
            props.put(MACHINE_NAME, name);
            props.put(PASSWORD, Boolean.toString(password));
            String qualifiedName = null;
            qualifiedName = password ? name + "_PW." + type : name + "." + type;
            ServiceInfo service = new ServiceInfo(type, qualifiedName, port, weight, priority, props);
            return service;
        }

        public void registerService() throws IOException {
            if (this.isRegistered()) {
                throw new IOException();
            }
            ServiceInfo service = this.createServiceInfo();
            this.zeroConf.registerService(service);
            this.service = service;
        }

        public void unregisterService() {
            if (!this.isRegistered()) {
                return;
            }
            this.zeroConf.unregisterService(this.service);
            this.service = null;
        }

        public void updateService() throws IOException {
            if (!this.isRegistered()) {
                throw new IOException();
            }
            if (this.service.getPort() != DaapSettings.DAAP_PORT.getValue()) {
                this.unregisterService();
            }
            ServiceInfo service = this.createServiceInfo();
            this.zeroConf.registerService(service);
            this.service = service;
        }

        public void close() {
            this.unregisterService();
            this.zeroConf.close();
        }
    }

    private final class LimeConfig
    implements DaapConfig {
        private InetAddress addr;

        public LimeConfig(InetAddress addr) {
            this.addr = addr;
            DaapSettings.DAAP_PORT.revertToDefault();
        }

        public String getServerName() {
            return CommonUtils.getHttpServer();
        }

        public void nextPort() {
            int port = DaapSettings.DAAP_PORT.getValue();
            DaapSettings.DAAP_PORT.setValue(port + 1);
        }

        public int getBacklog() {
            return 0;
        }

        public InetSocketAddress getInetSocketAddress() {
            int port = DaapSettings.DAAP_PORT.getValue();
            return new InetSocketAddress(this.addr, port);
        }

        public int getMaxConnections() {
            return DaapSettings.DAAP_MAX_CONNECTIONS.getValue();
        }
    }

    private final class LimeFilter
    implements DaapFilter {
        private LimeFilter() {
        }

        public boolean accept(InetAddress address) {
            byte[] addr = address.getAddress();
            try {
                if (!NetworkUtils.isVeryCloseIP(addr) && !NetworkUtils.isPrivateAddress(addr)) {
                    return false;
                }
            }
            catch (IllegalArgumentException err) {
                LOG.error(err);
                return false;
            }
            return IPFilter.instance().allow(addr);
        }
    }

    private final class LimeAuthenticator
    implements DaapAuthenticator {
        private LimeAuthenticator() {
        }

        public boolean requiresAuthentication() {
            return DaapSettings.DAAP_REQUIRES_PASSWORD.getValue();
        }

        public boolean authenticate(String username, String password) {
            return password.equals(DaapSettings.DAAP_PASSWORD.getValue());
        }
    }

    private final class LimeStreamSource
    implements DaapStreamSource {
        private LimeStreamSource() {
        }

        public FileInputStream getSource(Song song) throws IOException {
            FileDesc fileDesc;
            URN urn = DaapManager.this.map.get(song);
            if (urn != null && (fileDesc = RouterService.getFileManager().getFileDescForUrn(urn)) != null) {
                return new FileInputStream(fileDesc.getFile());
            }
            return null;
        }
    }

    private final class LimeThreadFactory
    implements DaapThreadFactory {
        private LimeThreadFactory() {
        }

        public Thread createDaapThread(Runnable runner, String name) {
            ManagedThread thread = new ManagedThread(runner, name);
            thread.setDaemon(true);
            return thread;
        }
    }
}

