/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.WindowsUtils;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public final class GUIUtils {
    private static final NumberFormat NUMBER_FORMAT0 = NumberFormat.getNumberInstance();
    private static final NumberFormat NUMBER_FORMAT1;
    private static final DateFormat DATETIME_FORMAT;
    public static final String GENERAL_UNIT_KILOBYTES;
    public static final String GENERAL_UNIT_MEGABYTES;
    public static final String GENERAL_UNIT_GIGABYTES;
    public static final String GENERAL_UNIT_TERABYTES;
    public static final String GENERAL_UNIT_KBPSEC;
    public static final HyperlinkListener HYPER_LISTENER;
    public static Action ACTION_DISPOSE;

    private GUIUtils() {
    }

    public static String toLocalizedInteger(long value) {
        return NUMBER_FORMAT0.format(value);
    }

    public static String toKilobytes(long bytes) {
        if (bytes < 0L) {
            return "? " + GENERAL_UNIT_KILOBYTES;
        }
        long kbytes = bytes / 1024L;
        if ((bytes & 0x200L) != 0L || bytes > 0L && bytes < 1024L) {
            ++kbytes;
        }
        return NUMBER_FORMAT0.format(kbytes) + GENERAL_UNIT_KILOBYTES;
    }

    public static String toUnitbytes(long bytes) {
        String unitName;
        long unitValue;
        if (bytes < 0L) {
            return "? " + GENERAL_UNIT_KILOBYTES;
        }
        if (bytes < 0x6400000L) {
            unitValue = 1024L;
            unitName = GENERAL_UNIT_KILOBYTES;
        } else if (bytes < 0x1900000000L) {
            unitValue = 0x100000L;
            unitName = GENERAL_UNIT_MEGABYTES;
        } else if (bytes < 0x640000000000L) {
            unitValue = 0x40000000L;
            unitName = GENERAL_UNIT_GIGABYTES;
        } else {
            unitValue = 0x10000000000L;
            unitName = GENERAL_UNIT_TERABYTES;
        }
        NumberFormat numberFormat = (double)bytes * 100.0 / (double)unitValue < 99995.0 ? NUMBER_FORMAT1 : NUMBER_FORMAT0;
        try {
            return numberFormat.format((double)bytes / (double)unitValue) + " " + unitName;
        }
        catch (ArithmeticException ae) {
            return "0 " + unitName;
        }
    }

    public static String toUnitnumber(double value, boolean allowFractional) {
        String unitName;
        long unitValue;
        double abs;
        double d = abs = value < 0.0 ? -value : value;
        if (abs < 100000.0) {
            unitValue = 1L;
            unitName = "";
        } else if (abs < 1.0E8) {
            unitValue = 1000L;
            unitName = "k";
            allowFractional = true;
        } else if (abs < 1.0E11) {
            unitValue = 1000000L;
            unitName = "M";
            allowFractional = true;
        } else if (abs < 1.0E14) {
            unitValue = 1000000000L;
            unitName = "G";
            allowFractional = true;
        } else {
            unitValue = 1000000000000L;
            unitName = "T";
            allowFractional = true;
        }
        NumberFormat numberFormat = allowFractional && abs * 100.0 / (double)unitValue < 99995.0 ? NUMBER_FORMAT1 : NUMBER_FORMAT0;
        return numberFormat.format(value / (double)unitValue) + unitName;
    }

    public static MultiLineLabel getSizedLabel(String msg) {
        Dimension dim = new Dimension();
        MultiLineLabel label = new MultiLineLabel(msg);
        FontMetrics fm = label.getFontMetrics(label.getFont());
        int width = fm.stringWidth(msg);
        dim.setSize(Integer.MAX_VALUE, width / 9);
        label.setPreferredSize(dim);
        return label;
    }

    public static String speed2name(int rate) {
        if (rate <= 56) {
            return GUIConstants.MODEM_SPEED;
        }
        if (rate <= 350) {
            return GUIConstants.CABLE_SPEED;
        }
        if (rate <= 1000) {
            return GUIConstants.T1_SPEED;
        }
        if (rate < Integer.MAX_VALUE) {
            return GUIConstants.T3_SPEED;
        }
        return GUIConstants.MULTICAST_SPEED;
    }

    public static String rate2speed(double rate) {
        return NUMBER_FORMAT0.format(rate) + GENERAL_UNIT_KBPSEC;
    }

    public static String seconds2time(int seconds) {
        int minutes = seconds / 60;
        seconds -= minutes * 60;
        int hours = minutes / 60;
        minutes -= hours * 60;
        int days = hours / 24;
        hours -= days * 24;
        StringBuffer time = new StringBuffer();
        if (days != 0) {
            time.append(Integer.toString(days));
            time.append(":");
            if (hours < 10) {
                time.append("0");
            }
        }
        if (days != 0 || hours != 0) {
            time.append(Integer.toString(hours));
            time.append(":");
            if (minutes < 10) {
                time.append("0");
            }
        }
        time.append(Integer.toString(minutes));
        time.append(":");
        if (seconds < 10) {
            time.append("0");
        }
        time.append(Integer.toString(seconds));
        return time.toString();
    }

    public static String msec2DateTime(long milliseconds) {
        Date d = new Date(milliseconds);
        return DATETIME_FORMAT.format(d);
    }

    public static void setOpaque(boolean op, JComponent c) {
        c.setOpaque(op);
        Component[] cs = c.getComponents();
        for (int i = 0; i < cs.length; ++i) {
            if (!(cs[i] instanceof JComponent) || cs[i] instanceof JTextField || !ThemeSettings.isNativeOSXTheme() && cs[i] instanceof JButton) continue;
            ((JComponent)cs[i]).setOpaque(op);
            GUIUtils.setOpaque(op, (JComponent)cs[i]);
        }
    }

    public static JPanel center(JComponent c) {
        JPanel p = new JPanel(new FlowLayout(1, 0, 0));
        p.add(c);
        return p;
    }

    public static JPanel left(JComponent c) {
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        p.add(c);
        return p;
    }

    public static int width(JLabel c) {
        FontMetrics fm = c.getFontMetrics(c.getFont());
        return fm.stringWidth(c.getText()) + 3;
    }

    public static boolean canDisplay(Font f, String s) {
        int upTo = f.canDisplayUpTo(s);
        return upTo >= s.length() || upTo == -1;
    }

    public static void addHideAction(JComponent jc) {
        InputMap map = jc.getInputMap(1);
        map.put(GUIUtils.getHideKeystroke(), "limewire.hideWindow");
        jc.getActionMap().put("limewire.hideWindow", GUIUtils.getDisposeAction());
    }

    public static KeyStroke getHideKeystroke() {
        if (CommonUtils.isMacOSX()) {
            return KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
        return KeyStroke.getKeyStroke(27, 0);
    }

    public static Action getDisposeAction() {
        if (ACTION_DISPOSE == null) {
            ACTION_DISPOSE = new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    Window parent = ae.getSource() instanceof Window ? (Window)ae.getSource() : SwingUtilities.getWindowAncestor((Component)ae.getSource());
                    if (parent != null) {
                        parent.dispatchEvent(new WindowEvent(parent, 201));
                    }
                }
            };
        }
        return ACTION_DISPOSE;
    }

    public static void fixInputMap(JComponent jc) {
        InputMap map = jc.getInputMap(1);
        if (CommonUtils.isMacOSX()) {
            GUIUtils.replaceAction(map, 'A');
            GUIUtils.replaceAction(map, 'C');
            GUIUtils.replaceAction(map, 'V');
            GUIUtils.replaceAction(map, 'X');
        }
    }

    private static void replaceAction(InputMap map, char c) {
        KeyStroke ctrl = KeyStroke.getKeyStroke("control pressed " + c);
        KeyStroke meta = KeyStroke.getKeyStroke("meta pressed " + c);
        if (ctrl == null || meta == null) {
            return;
        }
        Object action = map.get(ctrl);
        if (action != null) {
            map.remove(ctrl);
            map.put(meta, action);
        }
    }

    public static HyperlinkListener getHyperlinkListener() {
        return HYPER_LISTENER;
    }

    public static MouseListener getURLInputListener(final String url) {
        return new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getDefaultCursor());
            }

            public void mouseClicked(MouseEvent e) {
                GUIMediator.openURL(url);
            }
        };
    }

    public static boolean shouldShowStartOnStartupWindow() {
        return CommonUtils.isMacOSX() && CommonUtils.isJava14OrLater() && CommonUtils.isCocoaFoundationAvailable() || WindowsUtils.isLoginStatusAvailable();
    }

    static {
        NUMBER_FORMAT0.setMaximumFractionDigits(0);
        NUMBER_FORMAT0.setMinimumFractionDigits(0);
        NUMBER_FORMAT0.setGroupingUsed(true);
        NUMBER_FORMAT1 = NumberFormat.getNumberInstance();
        NUMBER_FORMAT1.setMaximumFractionDigits(1);
        NUMBER_FORMAT1.setMinimumFractionDigits(1);
        NUMBER_FORMAT1.setGroupingUsed(true);
        DATETIME_FORMAT = DateFormat.getDateTimeInstance();
        GENERAL_UNIT_KILOBYTES = GUIMediator.getStringResource("GENERAL_UNIT_KILOBYTES");
        GENERAL_UNIT_MEGABYTES = GUIMediator.getStringResource("GENERAL_UNIT_MEGABYTES");
        GENERAL_UNIT_GIGABYTES = GUIMediator.getStringResource("GENERAL_UNIT_GIGABYTES");
        GENERAL_UNIT_TERABYTES = GUIMediator.getStringResource("GENERAL_UNIT_TERABYTES");
        GENERAL_UNIT_KBPSEC = GUIMediator.getStringResource("GENERAL_UNIT_KBPSEC");
        HYPER_LISTENER = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent he) {
                URL url;
                if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = he.getURL()) != null) {
                    GUIMediator.openURL(url.toExternalForm());
                }
            }
        };
    }
}

