/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LimeTextField;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListEditor
extends JPanel {
    protected Vector model;
    protected DefaultListModel realModel;
    protected Vector listeners = new Vector();
    private static final int DEFAULT_COLUMNS = 10;
    protected JTextField editor;
    protected JButton addButton;
    protected JButton removeButton;
    protected JList list;
    private boolean addTail = true;

    public ListEditor() {
        this(new Vector());
    }

    public ListEditor(Vector model) {
        JPanel controls = new JPanel();
        this.editor = new LimeTextField("");
        this.editor.setColumns(10);
        this.editor.setPreferredSize(new Dimension(500, 20));
        this.editor.setMaximumSize(new Dimension(500, 20));
        this.addButton = new JButton(GUIMediator.getStringResource("LIST_EDITOR_ADD_BUTTON_2"));
        this.addButton.addActionListener(new AddListener());
        this.removeButton = new JButton(GUIMediator.getStringResource("LIST_EDITOR_REMOVE_BUTTON"));
        this.removeButton.addActionListener(new RemoveListener());
        controls.setLayout(new BoxLayout(controls, 0));
        controls.add(this.editor);
        controls.add(this.addButton);
        controls.add(this.removeButton);
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListListener());
        JScrollPane scrollPane = new JScrollPane(this.list, 22, 30);
        this.setModel(model);
        scrollPane.setPreferredSize(new Dimension(500, 50));
        scrollPane.setMaximumSize(new Dimension(500, 50));
        this.setLayout(new BoxLayout(this, 1));
        this.add(controls);
        this.add(scrollPane);
    }

    public Vector getModel() {
        return this.model;
    }

    public synchronized void setModel(Vector model) {
        this.model = model;
        this.realModel = new DefaultListModel();
        for (int i = 0; i < model.size(); ++i) {
            this.realModel.addElement(model.get(i));
        }
        this.list.setModel(this.realModel);
    }

    public void setAddTail(boolean addTail) {
        this.addTail = addTail;
    }

    public boolean getAddTail() {
        return this.addTail;
    }

    public synchronized void removeItem(int i) {
        this.model.remove(i);
        this.realModel.remove(i);
        this.editor.setText("");
        ListDataEvent event = new ListDataEvent(this.model, 2, i, i);
        for (int j = 0; j < this.listeners.size(); ++j) {
            ListDataListener listener = (ListDataListener)this.listeners.get(j);
            listener.intervalRemoved(event);
        }
    }

    public synchronized void addListDataListener(ListDataListener listener) {
        this.listeners.add(listener);
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int i = ListEditor.this.list.getSelectedIndex();
            if (i != -1) {
                ListEditor.this.removeItem(i);
            }
        }
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String text = ListEditor.this.editor.getText();
            if (text.trim().equals("")) {
                return;
            }
            int i = ListEditor.this.list.getSelectedIndex();
            if (i != -1) {
                ListEditor.this.model.setElementAt(text, i);
                ListEditor.this.realModel.setElementAt(text, i);
                ListDataEvent event = new ListDataEvent(ListEditor.this.model, 0, i, i);
                for (int j = 0; j < ListEditor.this.listeners.size(); ++j) {
                    ListDataListener listener = (ListDataListener)ListEditor.this.listeners.get(j);
                    listener.contentsChanged(event);
                }
            } else {
                int last;
                if (ListEditor.this.addTail) {
                    ListEditor.this.model.addElement(text);
                    ListEditor.this.realModel.addElement(text);
                    last = ListEditor.this.model.size() - 1;
                } else {
                    ListEditor.this.model.add(0, text);
                    ListEditor.this.realModel.add(0, text);
                    last = 0;
                }
                ListDataEvent event = new ListDataEvent(ListEditor.this.model, 1, last, last);
                for (int j = 0; j < ListEditor.this.listeners.size(); ++j) {
                    ListDataListener listener = (ListDataListener)ListEditor.this.listeners.get(j);
                    listener.intervalAdded(event);
                }
            }
            ListEditor.this.editor.setText("");
            ListEditor.this.list.clearSelection();
        }
    }

    private class ListListener
    implements ListSelectionListener {
        private ListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            Object val = ListEditor.this.list.getSelectedValue();
            if (val == null) {
                return;
            }
            ListEditor.this.editor.setText((String)val);
        }
    }
}

