/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public final class ProgTabUIFactory {
    private static final Class aquaUI = ProgTabUIFactory.loadClass("apple.laf.AquaTabbedPaneUI");
    private static final Class macUI = ProgTabUIFactory.loadClass("com.apple.mrj.swing.MacTabbedPaneUI");
    private static final Class windowsUI = ProgTabUIFactory.loadClass("com.sun.java.swing.plaf.windows.WindowsTabbedPaneUI");
    private static final Class metalUI = class$javax$swing$plaf$metal$MetalTabbedPaneUI == null ? (class$javax$swing$plaf$metal$MetalTabbedPaneUI = ProgTabUIFactory.class$("javax.swing.plaf.metal.MetalTabbedPaneUI")) : class$javax$swing$plaf$metal$MetalTabbedPaneUI;
    private static final Class basicUI = class$javax$swing$plaf$basic$BasicTabbedPaneUI == null ? (class$javax$swing$plaf$basic$BasicTabbedPaneUI = ProgTabUIFactory.class$("javax.swing.plaf.basic.BasicTabbedPaneUI")) : class$javax$swing$plaf$basic$BasicTabbedPaneUI;
    static /* synthetic */ Class class$javax$swing$plaf$metal$MetalTabbedPaneUI;
    static /* synthetic */ Class class$javax$swing$plaf$basic$BasicTabbedPaneUI;

    private ProgTabUIFactory() {
    }

    private static final Class loadClass(String toLoad) {
        try {
            return Class.forName(toLoad);
        }
        catch (ClassNotFoundException cfnfe) {
            return null;
        }
    }

    private static TabbedPaneUI createNewUI(String toLoad, TabbedPaneUI def) {
        Class clazz = ProgTabUIFactory.loadClass(toLoad);
        if (clazz == null) {
            return def;
        }
        try {
            return (TabbedPaneUI)clazz.newInstance();
        }
        catch (IllegalAccessException iae) {
            return def;
        }
        catch (InstantiationException iae) {
            return def;
        }
        catch (ExceptionInInitializerError eiie) {
            return def;
        }
        catch (SecurityException se) {
            return def;
        }
        catch (ClassCastException cce) {
            return def;
        }
    }

    public static void extendUI(JTabbedPane pane) {
        TabbedPaneUI oldUI;
        TabbedPaneUI newUI = oldUI = pane.getUI();
        if (aquaUI != null && aquaUI.isInstance(oldUI)) {
            newUI = ProgTabUIFactory.createNewUI("com.limegroup.gnutella.gui.AquaTab", newUI);
        } else if (macUI != null && macUI.isInstance(oldUI)) {
            newUI = ProgTabUIFactory.createNewUI("com.limegroup.gnutella.gui.MacTab", newUI);
        } else if (windowsUI != null && windowsUI.isInstance(oldUI)) {
            newUI = ProgTabUIFactory.createNewUI("com.limegroup.gnutella.gui.WinTab", newUI);
        } else if (metalUI != null && metalUI.isInstance(oldUI)) {
            newUI = new MetalTab();
        } else if (oldUI.getClass() == basicUI) {
            newUI = new BasicTab();
        }
        pane.setUI(newUI);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Progressor {
        public double calculatePercentage(long var1);
    }

    private static class MetalTab
    extends MetalTabbedPaneUI {
        private final JProgressBar PROGRESS = new JProgressBar();
        private final CellRendererPane PANE = new CellRendererPane();

        public MetalTab() {
            this.PROGRESS.setMinimum(0);
            this.PROGRESS.setMaximum(100);
            this.PROGRESS.setBorderPainted(false);
            this.PROGRESS.setOpaque(false);
        }

        protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
            long currentTime = System.currentTimeMillis();
            Progressor p = (Progressor)((Object)this.tabPane.getComponentAt(tabIndex));
            double percent = p.calculatePercentage(currentTime);
            if (percent > 1.0) {
                percent = 1.0;
            }
            this.PROGRESS.setValue((int)(percent * 100.0));
            Rectangle tabRect = this.tabPane.getBoundsAt(tabIndex);
            int x = textRect.x - 4;
            int y = textRect.y;
            int w = tabRect.width + tabRect.x - x - 1;
            int h = tabRect.height + tabRect.y - y;
            this.PANE.paintComponent(g, this.PROGRESS, this.tabPane.getParent(), x, y, w, h);
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        }
    }

    private static class BasicTab
    extends BasicTabbedPaneUI {
        private BasicTab() {
        }

        protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
            super.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
            Color darker = this.tabPane.getBackgroundAt(tabIndex).darker();
            g.setColor(darker);
            long currentTime = System.currentTimeMillis();
            Progressor p = (Progressor)((Object)this.tabPane.getComponentAt(tabIndex));
            double percent = p.calculatePercentage(currentTime);
            if (percent > 1.0) {
                percent = 1.0;
            }
            g.fillRect(x + 1, y + 1, (int)((double)(w - 3) * percent), h - 1);
        }
    }
}

