/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.LimeTextField;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WholeNumberField
extends LimeTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.US);

    public WholeNumberField(int value, int columns) {
        super(columns);
        this.integerFormatter.setParseIntegerOnly(true);
        this.setValue(value);
    }

    public WholeNumberField(int columns) {
        super(columns);
        this.integerFormatter.setParseIntegerOnly(true);
    }

    public int getValue() {
        int retVal = 0;
        try {
            retVal = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException e) {
            this.toolkit.beep();
        }
        return retVal;
    }

    public void setValue(int value) {
        this.setText(this.integerFormatter.format(value));
    }

    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (Character.isDigit(source[i])) {
                    result[j++] = source[i];
                    continue;
                }
                if (source[i] == ',' && (result.length - i) % 4 == 0 && result.length != i - 1) continue;
                WholeNumberField.this.toolkit.beep();
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

