/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.connection;

import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.connection.ConnectionButtons;
import com.limegroup.gnutella.gui.connection.ConnectionModel;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.util.NetworkUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public final class ConnectionMediator
extends AbstractTableMediator {
    ActionListener ADD_LISTENER;
    ActionListener BROWSE_HOST_LISTENER;
    private static final String IS_ULTRAPEER = GUIMediator.getStringResource("CV_STRING_ULTRAPEER");
    private static final String IS_LEAF = GUIMediator.getStringResource("CV_STRING_CLIENT");
    private static final String CONNECTING = GUIMediator.getStringResource("CV_TABLE_STRING_CONNECTINGS");
    private static final String LEAVES = GUIMediator.getStringResource("CV_TABLE_STRING_LEAVES");
    private static final String ULTRAPEERS = GUIMediator.getStringResource("CV_TABLE_STRING_ULTRAPEERS");
    private static final String PEERS = GUIMediator.getStringResource("CV_TABLE_STRING_PEERS");
    private static final String STANDARD = GUIMediator.getStringResource("CV_TABLE_STRING_STANDARDS");
    private static final ConnectionMediator INSTANCE = new ConnectionMediator();
    private JLabel SERVENT_STATUS;
    private JLabel NEIGHBORS;

    public static ConnectionMediator instance() {
        return INSTANCE;
    }

    protected void buildListeners() {
        super.buildListeners();
        this.ADD_LISTENER = new AddListener();
        this.BROWSE_HOST_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionMediator.this.doBrowseHost();
            }
        };
    }

    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID){

            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    protected void addListeners() {
        super.addListeners();
    }

    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel();
        this.DATA_MODEL = new ConnectionModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.BUTTON_ROW = new ConnectionButtons(this).getComponent();
        this.SERVENT_STATUS = new JLabel("");
        this.NEIGHBORS = new JLabel("");
    }

    protected JComponent getScrolledTablePane() {
        JComponent pane = super.getScrolledTablePane();
        this.SCROLL_PANE.setPreferredSize(new Dimension(3000, 5000));
        return pane;
    }

    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_CONNECTION_WINDOW"));
    }

    protected void setupMainPanel() {
        if (this.MAIN_PANEL != null) {
            JPanel status = new JPanel();
            status.setLayout(new BorderLayout());
            status.add((Component)this.SERVENT_STATUS, "West");
            status.add((Component)this.NEIGHBORS, "East");
            this.MAIN_PANEL.add(status);
            this.MAIN_PANEL.add(this.getScrolledTablePane());
            this.MAIN_PANEL.add(this.BUTTON_ROW);
            this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
        }
    }

    private ConnectionMediator() {
        super("CONNECTION_TABLE");
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
        this.doRefresh();
    }

    public void removeSelection() {
        int[] sel = this.TABLE.getSelectedRows();
        Arrays.sort(sel);
        for (int counter = sel.length - 1; counter >= 0; --counter) {
            int i = sel[counter];
            ManagedConnection c = (ManagedConnection)this.DATA_MODEL.get(i).getInitializeObject();
            RouterService.removeConnection(c);
        }
        this.clearSelection();
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu jpm = new JPopupMenu();
        JMenuItem jmi = new JMenuItem(GUIMediator.getStringResource("CV_BUTTON_ADD"));
        jmi.addActionListener(this.ADD_LISTENER);
        jpm.add(jmi);
        jpm.addSeparator();
        jmi = new JMenuItem(GUIMediator.getStringResource("CV_BUTTON_REMOVE"));
        jmi.addActionListener(this.REMOVE_LISTENER);
        jpm.add(jmi);
        jpm.addSeparator();
        jmi = new JMenuItem(GUIMediator.getStringResource("GENERAL_BROWSE_HOST_LABEL"));
        jmi.addActionListener(this.BROWSE_HOST_LISTENER);
        jpm.add(jmi);
        return jpm;
    }

    public void handleSelection(int row) {
        this.setButtonEnabled(1, true);
        this.setButtonEnabled(2, true);
    }

    public void handleNoSelection() {
        this.setButtonEnabled(1, false);
        this.setButtonEnabled(2, false);
    }

    public void handleActionKey() {
        this.doBrowseHost();
    }

    private void doBrowseHost() {
        int[] rows = this.TABLE.getSelectedRows();
        if (rows.length > 0) {
            ManagedConnection c = (ManagedConnection)this.DATA_MODEL.get(rows[0]).getInitializeObject();
            GUIMediator.instance().doBrowseHost(c.getAddress(), c.getPort());
        }
    }

    public void doRefresh() {
        super.doRefresh();
        this.SERVENT_STATUS.setText(GUIMediator.getStringResource("CV_STRING_STATUS") + "  " + (RouterService.isSupernode() ? IS_ULTRAPEER : IS_LEAF) + "      ");
        int[] counts = ((ConnectionModel)this.DATA_MODEL).getConnectionInfo();
        ConnectionModel cm = (ConnectionModel)this.DATA_MODEL;
        this.NEIGHBORS.setText("( " + counts[1] + " " + ULTRAPEERS + ", " + counts[2] + " " + PEERS + ", " + counts[3] + " " + LEAVES + ", " + counts[0] + " " + CONNECTING + ", " + counts[4] + " " + STANDARD + " )");
    }

    public int getConnectingCount() {
        return ((ConnectionModel)this.DATA_MODEL).getConnectingCount();
    }

    private void tryConnection(final String hostname, final int portnum) {
        GUIMediator.instance().schedule(new Runnable(){

            public void run() {
                RouterService.connectToHostAsynchronously(hostname, portnum);
            }
        });
    }

    public void clearConnections() {
        this.DATA_MODEL.clear();
    }

    void addKnownHost(String host, int port) {
    }

    static /* synthetic */ void access$500(ConnectionMediator x0, String x1, int x2) {
        x0.tryConnection(x1, x2);
    }

    private final class AddListener
    implements ActionListener {
        private JDialog dialog = null;
        private AutoCompleteTextField HOST_INPUT = new AutoCompleteTextField(20);
        private JTextField PORT_INPUT = new WholeNumberField(6346, 4);
        private JButton OK_BUTTON = new JButton(GUIMediator.getStringResource("GENERAL_OK_BUTTON_LABEL"));
        private JButton CANCEL_BUTTON = new JButton(GUIMediator.getStringResource("GENERAL_CANCEL_BUTTON_LABEL"));

        private AddListener() {
        }

        private void createDialog() {
            if (this.dialog != null) {
                return;
            }
            this.dialog = new JDialog(GUIMediator.getAppFrame(), GUIMediator.getStringResource("CV_ADD_DIALOG_TITLE"), true);
            JPanel jp = (JPanel)this.dialog.getContentPane();
            GUIUtils.addHideAction(jp);
            jp.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 5;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.gridy = 0;
            jp.add(this.getHorizontalSpacer(), gbc);
            gbc.gridwidth = 1;
            gbc.gridheight = 5;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            gbc.fill = 3;
            gbc.gridx = 0;
            gbc.gridy = 1;
            jp.add(this.getVerticalSpacer(), gbc);
            gbc.gridwidth = 1;
            gbc.gridheight = 5;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            gbc.fill = 3;
            gbc.gridx = 4;
            gbc.gridy = 1;
            jp.add(this.getVerticalSpacer(), gbc);
            gbc.gridwidth = 5;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.gridy = 6;
            jp.add(this.getHorizontalSpacer(), gbc);
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.gridx = 1;
            gbc.gridy = 1;
            jp.add((Component)new JLabel(GUIMediator.getStringResource("CV_ADD_HOST_LABEL")), gbc);
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.gridx = 2;
            gbc.gridy = 1;
            jp.add(this.getVerticalSpacer(), gbc);
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.gridx = 3;
            gbc.gridy = 1;
            jp.add((Component)this.HOST_INPUT, gbc);
            gbc.gridwidth = 3;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.gridx = 1;
            gbc.gridy = 2;
            jp.add(this.getHorizontalSpacer(), gbc);
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.gridx = 1;
            gbc.gridy = 3;
            jp.add((Component)new JLabel(GUIMediator.getStringResource("CV_ADD_PORT_LABEL")), gbc);
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.gridx = 2;
            gbc.gridy = 3;
            jp.add(this.getVerticalSpacer(), gbc);
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.gridx = 3;
            gbc.gridy = 3;
            jp.add((Component)this.PORT_INPUT, gbc);
            gbc.gridwidth = 3;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.gridx = 1;
            gbc.gridy = 4;
            jp.add(this.getHorizontalSpacer(), gbc);
            JPanel buttons = new JPanel();
            this.OK_BUTTON.addActionListener(new ActionListener(this){
                private final /* synthetic */ AddListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    String hostnamestr = AddListener.access$200(this.this$1).getText();
                    String portstr = AddListener.access$300(this.this$1).getText();
                    int idx = hostnamestr.lastIndexOf(58);
                    if (idx != -1) {
                        AddListener.access$300(this.this$1).setText(hostnamestr.substring(idx + 1));
                        portstr = AddListener.access$300(this.this$1).getText();
                        AddListener.access$200(this.this$1).setText(hostnamestr.substring(0, idx));
                        hostnamestr = AddListener.access$200(this.this$1).getText();
                    }
                    int portnum = -1;
                    try {
                        portnum = Integer.parseInt(portstr);
                    }
                    catch (NumberFormatException ee) {
                        portnum = 6346;
                    }
                    if (!NetworkUtils.isValidPort(portnum)) {
                        portnum = 6346;
                    }
                    AddListener.access$300(this.this$1).setText("" + portnum);
                    if (!hostnamestr.equals("")) {
                        ConnectionMediator.access$500(AddListener.access$400(this.this$1), hostnamestr, portnum);
                        AddListener.access$600(this.this$1).hide();
                        AddListener.access$600(this.this$1).dispose();
                    } else {
                        AddListener.access$200(this.this$1).requestFocus();
                    }
                }
            });
            this.CANCEL_BUTTON.addActionListener(GUIUtils.getDisposeAction());
            buttons.add(this.OK_BUTTON);
            buttons.add(this.CANCEL_BUTTON);
            gbc.gridwidth = 3;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.gridx = 1;
            gbc.gridy = 5;
            jp.add((Component)buttons, gbc);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.dialog == null) {
                this.createDialog();
            }
            this.dialog.getRootPane().setDefaultButton(this.OK_BUTTON);
            this.dialog.pack();
            this.dialog.setLocation(GUIMediator.getScreenCenterPoint(this.dialog));
            this.dialog.show();
        }

        private Component getVerticalSpacer() {
            return Box.createRigidArea(new Dimension(6, 0));
        }

        private Component getHorizontalSpacer() {
            return Box.createRigidArea(new Dimension(0, 6));
        }

        static /* synthetic */ AutoCompleteTextField access$200(AddListener x0) {
            return x0.HOST_INPUT;
        }

        static /* synthetic */ JTextField access$300(AddListener x0) {
            return x0.PORT_INPUT;
        }

        static /* synthetic */ ConnectionMediator access$400(AddListener x0) {
            return x0.ConnectionMediator.this;
        }

        static /* synthetic */ JDialog access$600(AddListener x0) {
            return x0.dialog;
        }
    }
}

