/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

final class ScanConfirmWindow
extends SetupWindow {
    private final int SHARED_DIRECTORY_LIMIT = 5;
    private JCheckBox[] _dirCheckBoxes = new JCheckBox[5];
    private JPanel CHECK_BOX_PANEL = new BoxPanel(1);
    private boolean _windowOpened = false;

    ScanConfirmWindow(SetupManager manager) {
        super(manager, "SETUP_CONFIRM_TITLE", "SETUP_CONFIRM_LABEL");
    }

    protected void createWindow() {
        if (!this._windowOpened) {
            String[] dirNames = this._manager.getScannedPaths();
            boolean hasDirectories = this.setDirectories(dirNames);
            this._windowOpened = true;
            if (!hasDirectories) {
                this.setLabelKey("SETUP_CONFIRM_LABEL_NO_DIRECTORIES");
            }
        }
        super.createWindow();
        BoxPanel mainPanel = new BoxPanel(0);
        mainPanel.add(this.CHECK_BOX_PANEL);
        mainPanel.add(Box.createHorizontalGlue());
        this.addSetupComponent(mainPanel);
    }

    public void applySettings() throws ApplySettingsException {
        File[] dirs = this.getSelectedDirectories();
        boolean gotSaveDir = false;
        int finalLength = dirs.length;
        File saveDir = null;
        try {
            saveDir = SharingSettings.getSaveDirectory();
            if (saveDir == null || !saveDir.exists()) {
                throw new FileNotFoundException();
            }
            ++finalLength;
            gotSaveDir = true;
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
        File[] finalDirs = new File[finalLength];
        for (int i = 0; i < dirs.length; ++i) {
            finalDirs[i] = dirs[i];
        }
        if (gotSaveDir) {
            finalDirs[dirs.length] = saveDir;
        }
        SharingSettings.DIRECTORIES_TO_SHARE.setValue(finalDirs);
    }

    private File[] getSelectedDirectories() {
        ArrayList<File> fileList = new ArrayList<File>();
        int numDirsSelected = 0;
        for (int i = 0; i < this._dirCheckBoxes.length; ++i) {
            if (this._dirCheckBoxes[i] == null || !this._dirCheckBoxes[i].isSelected()) continue;
            ++numDirsSelected;
            fileList.add(new File(this._dirCheckBoxes[i].getText()));
        }
        File[] files = new File[numDirsSelected];
        for (int r = 0; r < numDirsSelected; ++r) {
            files[r] = (File)fileList.get(r);
        }
        return files;
    }

    private boolean setDirectories(String[] dirPaths) {
        if (dirPaths == null) {
            return false;
        }
        boolean exists = false;
        for (int i = 0; i < dirPaths.length; ++i) {
            if (dirPaths[i] == null) continue;
            this._dirCheckBoxes[i] = new JCheckBox("", false);
            this._dirCheckBoxes[i].setText(dirPaths[i]);
            this.CHECK_BOX_PANEL.add(this._dirCheckBoxes[i]);
            exists = true;
        }
        this.CHECK_BOX_PANEL.revalidate();
        return exists;
    }
}

