/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LicenseWindow;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableButtons;
import com.limegroup.gnutella.gui.library.LibraryTableCellEditor;
import com.limegroup.gnutella.gui.library.LibraryTableDataLine;
import com.limegroup.gnutella.gui.library.LibraryTableModel;
import com.limegroup.gnutella.gui.library.LibraryTablePopupMenu;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DragManager;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.xml.MetaEditorFrame;
import com.limegroup.gnutella.gui.xml.editor.MetaEditor;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.VerificationListener;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.util.Launcher;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

final class LibraryTableMediator
extends AbstractTableMediator
implements VerificationListener {
    private static final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    public static ActionListener LAUNCH_LISTENER;
    public static ActionListener ADD_PLAY_LIST_LISTENER;
    public static ActionListener ANNOTATE_LISTENER;
    public static ActionListener BITZI_LOOKUP_LISTENER;
    public static ActionListener MAGNET_LOOKUP_LISTENER;
    public static ActionListener HTTP_LOOKUP_LISTENER;
    public static ActionListener RESUME_LISTENER;
    public static ActionListener LICENSE_LISTENER;
    public static ActionListener RENAME_LISTENER;
    private boolean _allowAnnotate;
    private boolean _isIncomplete;
    private static LibraryTableMediator _instance;

    public static LibraryTableMediator instance() {
        return _instance;
    }

    protected void buildListeners() {
        super.buildListeners();
        LAUNCH_LISTENER = new LaunchListener();
        ADD_PLAY_LIST_LISTENER = new AddPLFileListener();
        ANNOTATE_LISTENER = new AnnotateListener();
        BITZI_LOOKUP_LISTENER = new BitziLookupListener();
        MAGNET_LOOKUP_LISTENER = new MagnetLookupListener();
        RESUME_LISTENER = new ResumeListener();
        LICENSE_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibraryTableMediator.this.showLicenseWindow();
            }
        };
        RENAME_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibraryTableMediator.this.startRename();
            }
        };
    }

    protected void setupConstants() {
        this.MAIN_PANEL = null;
        this.DATA_MODEL = new LibraryTableModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        ((LibraryTableModel)this.DATA_MODEL).setTable(this.TABLE);
        this.BUTTON_ROW = new LibraryTableButtons(this).getComponent();
    }

    protected JPopupMenu createPopupMenu() {
        DataLine dl;
        boolean selection;
        JPopupMenu menu = new LibraryTablePopupMenu(this).getComponent();
        boolean bl = selection = !this.TABLE.getSelectionModel().isSelectionEmpty();
        if (GUIMediator.isPlaylistVisible()) {
            menu.getComponent(6).setEnabled(selection);
        }
        boolean license = (dl = this.TABLE.getSelectedDataLine()) != null && ((LibraryTableDataLine)dl).isLicensed();
        menu.getComponent(2).setEnabled(selection && this._allowAnnotate && !this._isIncomplete);
        menu.getComponent(3).setEnabled(selection && !this._isIncomplete);
        menu.getComponent(4).setEnabled(selection && this._isIncomplete);
        menu.getComponent(0).setEnabled(selection);
        menu.getComponent(1).setEnabled(selection);
        menu.getComponent(7).setEnabled(selection);
        menu.getComponent(8).setEnabled(selection);
        menu.getComponent(5).setEnabled(license);
        return menu;
    }

    public JComponent getScrolledTablePane() {
        return super.getScrolledTablePane();
    }

    protected void updateSplashScreen() {
    }

    private LibraryTableMediator() {
        super("LIBRARY_TABLE");
        ThemeMediator.addThemeObserver(this);
    }

    protected void setupDragAndDrop() {
        DragManager.install(this.TABLE);
    }

    public JComponent getComponent() {
        return null;
    }

    protected void setDefaultEditors() {
        TableColumnModel model = this.TABLE.getColumnModel();
        TableColumn tc = model.getColumn(1);
        tc.setCellEditor(new LibraryTableCellEditor(this));
    }

    void cancelEditing() {
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
    }

    void addMouseInputListener(MouseInputListener listener) {
        this.TABLE.addMouseListener(listener);
        this.TABLE.addMouseMotionListener(listener);
    }

    public void setAnnotateEnabled(boolean enabled) {
        this._allowAnnotate = enabled;
        LibraryTableDataLine.setXMLEnabled(enabled);
        this.DATA_MODEL.refresh();
        if (!enabled) {
            this.setButtonEnabled(LibraryTableButtons.ANNOTATE_BUTTON, false);
        } else if (!this.TABLE.getSelectionModel().isSelectionEmpty()) {
            this.setButtonEnabled(LibraryTableButtons.ANNOTATE_BUTTON, !this._isIncomplete);
        }
    }

    void setIncompleteSelected(boolean enabled) {
        this._isIncomplete = enabled;
        if (!enabled) {
            this.setButtonEnabled(LibraryTableButtons.RESUME_BUTTON, false);
        } else if (!this.TABLE.getSelectionModel().isSelectionEmpty()) {
            this.setButtonEnabled(LibraryTableButtons.RESUME_BUTTON, true);
        }
        this.setButtonEnabled(LibraryTableButtons.ANNOTATE_BUTTON, this._allowAnnotate && !enabled);
    }

    File getFile(int row) {
        return ((LibraryTableModel)this.DATA_MODEL).getFile(row);
    }

    JTable getTable() {
        return this.TABLE;
    }

    ButtonRow getButtonRow() {
        return this.BUTTON_ROW;
    }

    ListSelectionModel getSelectionModel() {
        return this.TABLE.getSelectionModel();
    }

    void editMeta() {
        int[] rows = this.TABLE.getSelectedRows();
        int k = rows.length;
        if (k == 0) {
            return;
        }
        int index = rows[k - 1];
        FileDesc fd = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(index);
        if (fd == null) {
            return;
        }
        String fullName = "";
        try {
            fullName = fd.getFile().getCanonicalPath();
        }
        catch (IOException ee) {
            return;
        }
        JFrame mainFrame = GUIMediator.getAppFrame();
        if (LimeXMLUtils.isSupportedAudioFormat(fullName)) {
            MetaEditor metaEditor = new MetaEditor(fd, fullName, mainFrame);
            metaEditor.show();
        } else {
            MetaEditorFrame metaEditor = new MetaEditorFrame(fd, fullName, mainFrame);
            metaEditor.show();
        }
    }

    void doBitziLookup() {
        int[] rows = this.TABLE.getSelectedRows();
        int k = rows.length;
        if (k == 0) {
            return;
        }
        int index = rows[k - 1];
        FileDesc fd = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(index);
        if (fd == null) {
            return;
        }
        URN urn = fd.getSHA1Urn();
        if (urn == null) {
            return;
        }
        String urnStr = urn.toString();
        int hashstart = 1 + urnStr.indexOf(":", 4);
        String lookupUrl = "http://bitzi.com/lookup/" + urnStr.substring(hashstart) + "?ref=limewire";
        try {
            Launcher.openURL(lookupUrl);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    void startRename() {
        int row = this.TABLE.getSelectedRow();
        if (row == -1) {
            return;
        }
        int viewIdx = this.TABLE.convertColumnIndexToView(1);
        this.TABLE.editCellAt(row, viewIdx, LibraryTableCellEditor.EVENT);
    }

    void showLicenseWindow() {
        DataLine dl = this.TABLE.getSelectedDataLine();
        if (dl == null) {
            return;
        }
        LibraryTableDataLine ldl = (LibraryTableDataLine)dl;
        FileDesc fd = ldl.getFileDesc();
        License license = fd.getLicense();
        URN urn = fd.getSHA1Urn();
        LicenseWindow window = new LicenseWindow(license, urn, this);
        window.show();
    }

    public void licenseVerified(License license) {
        this.DATA_MODEL.refresh();
    }

    void doMagnetLookup() {
        this.doMagnetCommand("/magcmd/detail?");
    }

    void doMagnetCommand(String cmd) {
        int[] rows = this.TABLE.getSelectedRows();
        int k = rows.length;
        if (k == 0) {
            return;
        }
        boolean haveValidMagnet = false;
        int count = 0;
        int port = RouterService.getHTTPAcceptor().getPort();
        int eport = RouterService.getAcceptor().getPort(true);
        byte[] eaddr = RouterService.getAcceptor().getAddress(true);
        String lookupUrl = "http://localhost:" + port + cmd + "addr=" + NetworkUtils.ip2string(eaddr) + ":" + eport;
        for (int i = 0; i < k; ++i) {
            FileDesc fd = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(rows[i]);
            if (fd == null) continue;
            URN urn = fd.getSHA1Urn();
            String urnStr = urn.toString();
            int hashstart = 1 + urnStr.indexOf(":", 4);
            if (urn == null) continue;
            String sha1 = urnStr.substring(hashstart);
            lookupUrl = lookupUrl + "&n" + count + "=" + URLEncoder.encode(fd.getName()) + "&u" + count + "=" + sha1;
            ++count;
            haveValidMagnet = true;
        }
        if (haveValidMagnet) {
            try {
                Launcher.openURL(lookupUrl);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public void removeSelection() {
        int i;
        String msgKey = "MESSAGE_CONFIRM_FILE_DELETE";
        int response = GUIMediator.showYesNoMessage(msgKey);
        if (response != 101) {
            return;
        }
        int[] rows = this.TABLE.getSelectedRows();
        if (rows.length <= 0) {
            return;
        }
        Arrays.sort(rows);
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (i = rows.length - 1; i >= 0; --i) {
            FileDesc fd;
            File file = ((LibraryTableModel)this.DATA_MODEL).getFile(rows[i]);
            RouterService.getFileManager().removeFileIfShared(file);
            boolean removed = file.delete();
            if (!removed && (fd = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(rows[i])) != null) {
                RouterService.getUploadManager().killUploadsForFileDesc(fd);
                removed = file.delete();
            }
            if (removed) {
                this.DATA_MODEL.remove(rows[i]);
                continue;
            }
            errors.add(file.getName());
        }
        this.clearSelection();
        for (i = 0; i < errors.size(); ++i) {
            String name = (String)errors.get(i);
            String key1 = "MESSAGE_UNABLE_TO_DELETE_FILE_START";
            String key2 = "MESSAGE_UNABLE_TO_DELETE_FILE_END";
            String msg = "'" + name + "'.";
            GUIMediator.showError("MESSAGE_UNABLE_TO_DELETE_FILE_START", (Object)msg, "MESSAGE_UNABLE_TO_DELETE_FILE_END");
        }
    }

    String handleNameChange(String newName) {
        int row = this.TABLE.getEditingRow();
        LibraryTableModel ltm = (LibraryTableModel)this.DATA_MODEL;
        File oldFile = ltm.getFile(row);
        String parent = oldFile.getParent();
        String nameWithExtension = newName + "." + ltm.getType(row);
        File newFile = new File(parent, nameWithExtension);
        if (!ltm.getName(row).equals(newName)) {
            if (oldFile.renameTo(newFile)) {
                ltm.handleFileChangeInternal(row, newFile);
                RouterService.getFileManager().renameFileIfShared(oldFile, newFile);
                return newName;
            }
            GUIMediator.showError("MESSAGE_UNABLE_TO_RENAME_FILE_START", (Object)("'" + ltm.getName(row) + "'."), "MESSAGE_UNABLE_TO_RENAME_FILE_END");
            return ltm.getName(row);
        }
        return newName;
    }

    public void handleActionKey() {
        this.launch();
    }

    void resumeIncomplete() {
        int i;
        int[] rows = this.TABLE.getSelectedRows();
        boolean startedDownload = false;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (i = 0; i < rows.length; ++i) {
            File incomplete = ((LibraryTableModel)this.DATA_MODEL).getFile(rows[i]);
            try {
                RouterService.download(incomplete);
                startedDownload = true;
                continue;
            }
            catch (AlreadyDownloadingException e) {
                errors.add(e);
                continue;
            }
            catch (CantResumeException e) {
                errors.add(e);
            }
        }
        for (i = 0; i < errors.size(); ++i) {
            Exception e = (Exception)errors.get(i);
            if (e instanceof AlreadyDownloadingException) {
                GUIMediator.showError("ERROR_ALREADY_DOWNLOADING", (Object)("\"" + ((AlreadyDownloadingException)e).getFilename() + "\"."), QuestionsHandler.ALREADY_DOWNLOADING);
                continue;
            }
            if (!(e instanceof CantResumeException)) continue;
            GUIMediator.showError("ERROR_CANT_RESUME_START", "\"" + ((CantResumeException)e).getFilename() + "\"", "ERROR_CANT_RESUME_END", QuestionsHandler.CANT_RESUME);
        }
        if (startedDownload) {
            GUIMediator.instance().setWindow(0);
        }
    }

    void launch() {
        int[] rows = this.TABLE.getSelectedRows();
        boolean audioLaunched = false;
        int l = rows.length;
        for (int i = 0; i < l; ++i) {
            File currFile = ((LibraryTableModel)this.DATA_MODEL).getFile(rows[i]);
            if (!audioLaunched && GUIMediator.isValidPlaylistFile(currFile)) {
                LIBRARY_MEDIATOR.launchAudio(currFile);
                audioLaunched = true;
                continue;
            }
            try {
                GUIMediator.launchFile(currFile);
                continue;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    public void handleSelection(int row) {
        this.setButtonEnabled(LibraryTableButtons.LAUNCH_BUTTON, true);
        this.setButtonEnabled(LibraryTableButtons.DELETE_BUTTON, true);
        if (GUIMediator.isPlaylistVisible()) {
            this.setButtonEnabled(LibraryTableButtons.PLAYLIST_BUTTON, true);
        }
        if (this._allowAnnotate && !this._isIncomplete) {
            this.setButtonEnabled(LibraryTableButtons.ANNOTATE_BUTTON, true);
        }
        if (this._isIncomplete) {
            this.setButtonEnabled(LibraryTableButtons.RESUME_BUTTON, true);
        }
    }

    public void handleNoSelection() {
        this.setButtonEnabled(LibraryTableButtons.LAUNCH_BUTTON, false);
        this.setButtonEnabled(LibraryTableButtons.DELETE_BUTTON, false);
        if (GUIMediator.isPlaylistVisible()) {
            this.setButtonEnabled(LibraryTableButtons.PLAYLIST_BUTTON, false);
        }
        this.setButtonEnabled(LibraryTableButtons.ANNOTATE_BUTTON, false);
        this.setButtonEnabled(LibraryTableButtons.RESUME_BUTTON, false);
    }

    static {
        _instance = new LibraryTableMediator();
    }

    private final class AddPLFileListener
    implements ActionListener {
        private AddPLFileListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            int[] rows = LibraryTableMediator.this.TABLE.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                int index = rows[i];
                File file = ((LibraryTableModel)LibraryTableMediator.this.DATA_MODEL).getFile(index);
                LIBRARY_MEDIATOR.addFileToPlayList(file);
            }
        }
    }

    private final class LaunchListener
    implements ActionListener {
        private LaunchListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            LibraryTableMediator.this.launch();
        }
    }

    private final class MagnetLookupListener
    implements ActionListener {
        private MagnetLookupListener() {
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTableMediator.this.doMagnetLookup();
        }
    }

    private final class BitziLookupListener
    implements ActionListener {
        private BitziLookupListener() {
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTableMediator.this.doBitziLookup();
        }
    }

    private final class ResumeListener
    implements ActionListener {
        private ResumeListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            LibraryTableMediator.this.resumeIncomplete();
        }
    }

    private final class AnnotateListener
    implements ActionListener {
        private AnnotateListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            LibraryTableMediator.this.editMeta();
        }
    }
}

