/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.mp3.AudioPlayer;
import com.limegroup.gnutella.gui.mp3.AudioPlayerListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractAudioPlayer
implements AudioPlayer {
    private List _listeners;

    AbstractAudioPlayer() {
    }

    public abstract int getStatus();

    public abstract void unpause();

    public abstract void pause();

    public abstract void stop();

    public abstract boolean play(File var1) throws IOException;

    public abstract int getFrameSeek();

    public abstract void refresh();

    public void addAudioPlayerListener(AudioPlayerListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(listener);
    }

    protected void fireAudioPositionUpdated(int pos) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((AudioPlayerListener)this._listeners.get(i)).updateAudioPosition(pos);
        }
    }

    protected void fireSeekSetupRequired(int numberOfFrames) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((AudioPlayerListener)this._listeners.get(i)).setUpSeek(numberOfFrames);
        }
    }

    protected void firePlayComplete() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((AudioPlayerListener)this._listeners.get(i)).playComplete();
        }
    }
}

