/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.metadata.MP3Info;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlayList {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$gui$mp3$PlayList == null ? (class$com$limegroup$gnutella$gui$mp3$PlayList = PlayList.class$("com.limegroup.gnutella.gui.mp3.PlayList")) : class$com$limegroup$gnutella$gui$mp3$PlayList);
    private File _file;
    private Vector _songs;
    private boolean _dirty;
    private static final String M3U_HEADER = "#EXTM3U";
    private static final String SONG_DELIM = "#EXTINF";
    private static final String SEC_DELIM = ":";
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$mp3$PlayList;

    public PlayList(String filename) {
        LOG.trace("PlayList(): entered.");
        this._file = new File(filename);
        if (this._file.isDirectory()) {
            throw new IllegalArgumentException(filename + " is a directory");
        }
        this._songs = new Vector();
        if (this._file.exists()) {
            try {
                this.loadM3UFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("songs = " + this._songs);
            LOG.trace("returning.  size is now " + this.getNumSongs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadM3UFile() throws IOException {
        BufferedReader m3uFile = null;
        try {
            m3uFile = new BufferedReader(new FileReader(this._file));
            String currLine = null;
            currLine = m3uFile.readLine();
            if (currLine == null || !currLine.startsWith(M3U_HEADER)) {
                throw new IOException();
            }
            currLine = m3uFile.readLine();
            while (currLine != null) {
                if (currLine.startsWith(SONG_DELIM)) {
                    currLine = m3uFile.readLine();
                    if (currLine == null) break;
                    File toAdd = new File(currLine);
                    if (toAdd.exists() && !toAdd.isDirectory()) {
                        this._songs.add(toAdd);
                    }
                }
                currLine = m3uFile.readLine();
            }
            Object var5_4 = null;
            if (m3uFile == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (m3uFile == null) throw throwable;
            try {
                m3uFile.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            m3uFile.close();
            return;
        }
        catch (IOException ioe) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() throws IOException {
        if (!this._dirty) {
            return;
        }
        if (this._songs.size() == 0) {
            if (this._file.exists()) {
                this._file.delete();
            }
            return;
        }
        boolean fileExists = this._file.exists();
        PrintWriter m3uFile = null;
        try {
            m3uFile = new PrintWriter(new FileWriter(this._file.getCanonicalPath(), false));
            if (!fileExists) {
                m3uFile.write(M3U_HEADER);
                m3uFile.println();
            }
            Iterator i = this._songs.iterator();
            while (i.hasNext()) {
                File currFile = (File)i.next();
                m3uFile.write(SONG_DELIM);
                m3uFile.write(SEC_DELIM);
                try {
                    MP3Info currMP3 = new MP3Info(currFile.getCanonicalPath());
                    m3uFile.write("" + currMP3.getLengthInSeconds() + ",");
                }
                catch (IOException ignored) {
                    m3uFile.write("-1,");
                }
                m3uFile.write(currFile.getName());
                m3uFile.println();
                m3uFile.write(currFile.getCanonicalPath());
                m3uFile.println();
            }
            Object var7_7 = null;
            this._dirty = false;
            if (m3uFile != null) {
                m3uFile.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this._dirty = false;
            if (m3uFile != null) {
                m3uFile.close();
            }
            throw throwable;
        }
    }

    public int getNumSongs() {
        return this._songs.size();
    }

    public void deleteSong(int index) {
        this._dirty = true;
        this._songs.remove(index);
    }

    public void addSong(File newEntry, int idx) {
        this._dirty = true;
        this._songs.add(idx, newEntry);
    }

    public synchronized List getSongs() {
        return new LinkedList(this._songs);
    }

    public synchronized void setSongs(List l) {
        this._dirty = true;
        this._songs.clear();
        this._songs.addAll(l);
    }

    public File getSong(int index) {
        return (File)this._songs.get(index);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

