/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.options.OptionsButtonPanel;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.OptionsPane;
import com.limegroup.gnutella.gui.options.OptionsPaneImpl;
import com.limegroup.gnutella.gui.options.OptionsPaneManager;
import com.limegroup.gnutella.gui.options.OptionsTreeManager;
import com.limegroup.gnutella.gui.options.panes.AllowMessagesPaneItem;
import com.limegroup.gnutella.gui.options.panes.AudioPlayerPaneItem;
import com.limegroup.gnutella.gui.options.panes.AutoClearDownloadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.AutoClearUploadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.AutoCompletePaneItem;
import com.limegroup.gnutella.gui.options.panes.BrowserPaneItem;
import com.limegroup.gnutella.gui.options.panes.BugsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ChatActivePaneItem;
import com.limegroup.gnutella.gui.options.panes.ConnectOnStartupPaneItem;
import com.limegroup.gnutella.gui.options.panes.ConnectionPreferencingPaneItem;
import com.limegroup.gnutella.gui.options.panes.DaapPasswordPaneItem;
import com.limegroup.gnutella.gui.options.panes.DaapSupportPaneItem;
import com.limegroup.gnutella.gui.options.panes.DisableOOBSearchingPaneItem;
import com.limegroup.gnutella.gui.options.panes.DisableSupernodeModePaneItem;
import com.limegroup.gnutella.gui.options.panes.DownloadBandwidthPaneItem;
import com.limegroup.gnutella.gui.options.panes.ExtensionsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ForceIPPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreMessagesPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreResultTypesPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreResultsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ImageViewerPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumDownloadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumSearchesPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumUploadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.PartialFileSharingPaneItem;
import com.limegroup.gnutella.gui.options.panes.PerPersonUploadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.PlayerPreferencePaneItem;
import com.limegroup.gnutella.gui.options.panes.PopupsPaneItem;
import com.limegroup.gnutella.gui.options.panes.PortPaneItem;
import com.limegroup.gnutella.gui.options.panes.ProxyLoginPaneItem;
import com.limegroup.gnutella.gui.options.panes.ProxyPaneItem;
import com.limegroup.gnutella.gui.options.panes.PurgeIncompletePaneItem;
import com.limegroup.gnutella.gui.options.panes.SaveDirPaneItem;
import com.limegroup.gnutella.gui.options.panes.SearchQualityPaneItem;
import com.limegroup.gnutella.gui.options.panes.SearchSpeedPaneItem;
import com.limegroup.gnutella.gui.options.panes.SharedDirPaneItem;
import com.limegroup.gnutella.gui.options.panes.ShutdownPaneItem;
import com.limegroup.gnutella.gui.options.panes.SpeedPaneItem;
import com.limegroup.gnutella.gui.options.panes.StartupPaneItem;
import com.limegroup.gnutella.gui.options.panes.UploadBandwidthPaneItem;
import com.limegroup.gnutella.gui.options.panes.VideoPlayerPaneItem;
import com.limegroup.gnutella.gui.options.panes.iTunesPreferencePaneItem;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;

public final class OptionsConstructor {
    private final JDialog DIALOG;
    private final int OPTIONS_WIDTH = 600;
    private final int OPTIONS_HEIGHT = 460;
    private final OptionsTreeManager TREE_MANAGER;
    private final OptionsPaneManager PANE_MANAGER;

    public OptionsConstructor(OptionsTreeManager treeManager, OptionsPaneManager paneManager) {
        this.TREE_MANAGER = treeManager;
        this.PANE_MANAGER = paneManager;
        String title = GUIMediator.getStringResource("OPTIONS_TITLE");
        boolean shouldBeModal = !CommonUtils.isMacOSX() || !CommonUtils.isJava14OrLater();
        this.DIALOG = new JDialog(GUIMediator.getAppFrame(), title, shouldBeModal);
        this.DIALOG.setDefaultCloseOperation(0);
        GUIUtils.addHideAction((JComponent)this.DIALOG.getContentPane());
        if (CommonUtils.isWindows() && CommonUtils.isJava14OrLater() || CommonUtils.isMacOSX()) {
            this.DIALOG.setResizable(false);
        }
        this.DIALOG.setSize(600, 460);
        this.DIALOG.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    int answer = -1;
                    if (OptionsMediator.instance().isDirty() && (answer = GUIMediator.showYesNoCancelMessage("OPTIONS_SAVE_ON_CLOSE")) == 101) {
                        OptionsMediator.instance().applyOptions();
                        SettingsHandler.save();
                    }
                    if (answer != 103) {
                        OptionsConstructor.this.DIALOG.dispose();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        PaddedPanel mainPanel = new PaddedPanel();
        Box splitBox = new Box(0);
        Component treeComponent = this.TREE_MANAGER.getComponent();
        Component paneComponent = this.PANE_MANAGER.getComponent();
        splitBox.add(treeComponent);
        splitBox.add(paneComponent);
        mainPanel.add(splitBox);
        mainPanel.add(Box.createVerticalStrut(17));
        mainPanel.add(new OptionsButtonPanel().getComponent());
        this.DIALOG.getContentPane().add(mainPanel);
        String SAVE_KEY = "OPTIONS_SAVE_MAIN_TITLE";
        String SHARED_KEY = "OPTIONS_SHARED_MAIN_TITLE";
        String SPEED_KEY = "OPTIONS_SPEED_MAIN_TITLE";
        String DOWNLOAD_KEY = "OPTIONS_DOWNLOAD_MAIN_TITLE";
        String UPLOAD_KEY = "OPTIONS_UPLOAD_MAIN_TITLE";
        String UPLOAD_BASIC_KEY = "OPTIONS_UPLOAD_BASIC_MAIN_TITLE";
        String UPLOAD_SLOTS_KEY = "OPTIONS_UPLOAD_SLOTS_MAIN_TITLE";
        String CONNECTIONS_KEY = "OPTIONS_CONNECTIONS_MAIN_TITLE";
        String SHUTDOWN_KEY = "OPTIONS_SHUTDOWN_MAIN_TITLE";
        String CHAT_KEY = "OPTIONS_CHAT_MAIN_TITLE";
        String PLAYER_KEY = "OPTIONS_PLAYER_MAIN_TITLE";
        String ITUNES_KEY = "OPTIONS_ITUNES_MAIN_TITLE";
        String ITUNES_IMPORT_KEY = "OPTIONS_ITUNES_PREFERENCE_MAIN_TITLE";
        String ITUNES_DAAP_KEY = "OPTIONS_ITUNES_DAAP_MAIN_TITLE";
        String POPUPS_KEY = "OPTIONS_POPUPS_MAIN_TITLE";
        String BUGS_KEY = "OPTIONS_BUGS_MAIN_TITLE";
        String APPS_KEY = "OPTIONS_APPS_MAIN_TITLE";
        String SEARCH_KEY = "OPTIONS_SEARCH_MAIN_TITLE";
        String SEARCH_LIMIT_KEY = "OPTIONS_SEARCH_LIMIT_MAIN_TITLE";
        String SEARCH_QUALITY_KEY = "OPTIONS_SEARCH_QUALITY_MAIN_TITLE";
        String SEARCH_SPEED_KEY = "OPTIONS_SEARCH_SPEED_MAIN_TITLE";
        String FILTERS_KEY = "OPTIONS_FILTERS_MAIN_TITLE";
        String RESULTS_KEY = "OPTIONS_RESULTS_MAIN_TITLE";
        String MESSAGES_KEY = "OPTIONS_MESSAGES_MAIN_TITLE";
        String ADVANCED_KEY = "OPTIONS_ADVANCED_MAIN_TITLE";
        String PREFERENCING_KEY = "OPTIONS_PREFERENCING_MAIN_TITLE";
        String FIREWALL_KEY = "OPTIONS_FIREWALL_MAIN_TITLE";
        String GUI_KEY = "OPTIONS_GUI_MAIN_TITLE";
        String AUTOCOMPLETE_KEY = "OPTIONS_AUTOCOMPLETE_MAIN_TITLE";
        String STARTUP_KEY = "OPTIONS_STARTUP_MAIN_TITLE";
        String PROXY_KEY = "OPTIONS_PROXY_MAIN_TITLE";
        OptionsPaneImpl savingPane = new OptionsPaneImpl("OPTIONS_SAVE_MAIN_TITLE");
        savingPane.add(new SaveDirPaneItem("SAVE_DIR"));
        savingPane.add(new PurgeIncompletePaneItem("PURGE_INCOMPLETE_TIME"));
        this.addOption("OPTIONS_ROOT_NODE", savingPane);
        OptionsPaneImpl sharingPane = new OptionsPaneImpl("OPTIONS_SHARED_MAIN_TITLE");
        sharingPane.add(new SharedDirPaneItem("SHARED_DIRS"));
        sharingPane.add(new ExtensionsPaneItem("SHARED_EXTENSIONS"));
        this.addOption("OPTIONS_ROOT_NODE", sharingPane);
        OptionsPaneImpl speedPane = new OptionsPaneImpl("OPTIONS_SPEED_MAIN_TITLE");
        speedPane.add(new SpeedPaneItem("SPEED"));
        speedPane.add(new DisableSupernodeModePaneItem("DISABLE_SUPERNODE_MODE"));
        speedPane.add(new DisableOOBSearchingPaneItem("DISABLE_OOB_SEARCHING"));
        this.addOption("OPTIONS_ROOT_NODE", speedPane);
        OptionsPaneImpl downloadPane = new OptionsPaneImpl("OPTIONS_DOWNLOAD_MAIN_TITLE");
        downloadPane.add(new MaximumDownloadsPaneItem("DOWNLOAD_MAX"));
        downloadPane.add(new AutoClearDownloadsPaneItem("DOWNLOAD_CLEAR"));
        downloadPane.add(new DownloadBandwidthPaneItem("DOWNLOAD_BANDWIDTH"));
        this.addOption("OPTIONS_ROOT_NODE", downloadPane);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", "OPTIONS_UPLOAD_MAIN_TITLE");
        OptionsPaneImpl uploadBasicPane = new OptionsPaneImpl("OPTIONS_UPLOAD_BASIC_MAIN_TITLE");
        uploadBasicPane.add(new AutoClearUploadsPaneItem("UPLOAD_CLEAR"));
        uploadBasicPane.add(new UploadBandwidthPaneItem("UPLOAD_BANDWIDTH"));
        uploadBasicPane.add(new PartialFileSharingPaneItem("UPLOAD_ALLOW_PARTIAL_SHARING"));
        this.addOption("OPTIONS_UPLOAD_MAIN_TITLE", uploadBasicPane);
        OptionsPaneImpl uploadSlotsPane = new OptionsPaneImpl("OPTIONS_UPLOAD_SLOTS_MAIN_TITLE");
        uploadSlotsPane.add(new PerPersonUploadsPaneItem("UPLOAD_PER_PERSON"));
        uploadSlotsPane.add(new MaximumUploadsPaneItem("UPLOAD_MAX"));
        this.addOption("OPTIONS_UPLOAD_MAIN_TITLE", uploadSlotsPane);
        OptionsPaneImpl connectionsPane = new OptionsPaneImpl("OPTIONS_CONNECTIONS_MAIN_TITLE");
        connectionsPane.add(new ConnectOnStartupPaneItem("CONNECT_ON_STARTUP"));
        this.addOption("OPTIONS_ROOT_NODE", connectionsPane);
        OptionsPaneImpl shutdownPane = new OptionsPaneImpl("OPTIONS_SHUTDOWN_MAIN_TITLE");
        shutdownPane.add(new ShutdownPaneItem("SHUTDOWN"));
        this.addOption("OPTIONS_ROOT_NODE", shutdownPane);
        OptionsPaneImpl chatPane = new OptionsPaneImpl("OPTIONS_CHAT_MAIN_TITLE");
        chatPane.add(new ChatActivePaneItem("CHAT_ACTIVE"));
        this.addOption("OPTIONS_ROOT_NODE", chatPane);
        OptionsPaneImpl playerPane = new OptionsPaneImpl("OPTIONS_PLAYER_MAIN_TITLE");
        playerPane.add(new PlayerPreferencePaneItem("PLAYER_PREFERENCE"));
        this.addOption("OPTIONS_ROOT_NODE", playerPane);
        if (CommonUtils.isJava14OrLater() || CommonUtils.isMacOSX()) {
            this.addGroupTreeNode("OPTIONS_ROOT_NODE", "OPTIONS_ITUNES_MAIN_TITLE");
            if (CommonUtils.isMacOSX()) {
                OptionsPaneImpl itunesPane = new OptionsPaneImpl("OPTIONS_ITUNES_PREFERENCE_MAIN_TITLE");
                itunesPane.add(new iTunesPreferencePaneItem("ITUNES_PREFERENCE"));
                this.addOption("OPTIONS_ITUNES_MAIN_TITLE", itunesPane);
            }
            if (CommonUtils.isJava14OrLater()) {
                OptionsPaneImpl daapPane = new OptionsPaneImpl("OPTIONS_ITUNES_DAAP_MAIN_TITLE");
                daapPane.add(new DaapSupportPaneItem("ITUNES_DAAP_PREFERENCE"));
                daapPane.add(new DaapPasswordPaneItem("ITUNES_DAAP_PASSWORD"));
                this.addOption("OPTIONS_ITUNES_MAIN_TITLE", daapPane);
            }
        }
        if (!CommonUtils.isWindows() && !CommonUtils.isAnyMac()) {
            OptionsPaneImpl browserPane = new OptionsPaneImpl("OPTIONS_APPS_MAIN_TITLE");
            browserPane.add(new BrowserPaneItem("BROWSER_PREFERENCE"));
            browserPane.add(new ImageViewerPaneItem("IMAGE_VIEWER_PREFERENCE"));
            browserPane.add(new VideoPlayerPaneItem("VIDEO_PLAYER_PREFERENCE"));
            browserPane.add(new AudioPlayerPaneItem("AUDIO_PLAYER_PREFERENCE"));
            this.addOption("OPTIONS_ROOT_NODE", browserPane);
        }
        OptionsPaneImpl bugsPane = new OptionsPaneImpl("OPTIONS_BUGS_MAIN_TITLE");
        bugsPane.add(new BugsPaneItem("BUGS"));
        this.addOption("OPTIONS_ROOT_NODE", bugsPane);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", "OPTIONS_GUI_MAIN_TITLE");
        OptionsPaneImpl popupsPane = new OptionsPaneImpl("OPTIONS_POPUPS_MAIN_TITLE");
        popupsPane.add(new PopupsPaneItem("POPUPS"));
        this.addOption("OPTIONS_GUI_MAIN_TITLE", popupsPane);
        OptionsPaneImpl autocompletePane = new OptionsPaneImpl("OPTIONS_AUTOCOMPLETE_MAIN_TITLE");
        autocompletePane.add(new AutoCompletePaneItem("AUTOCOMPLETE"));
        this.addOption("OPTIONS_GUI_MAIN_TITLE", autocompletePane);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", "OPTIONS_SEARCH_MAIN_TITLE");
        OptionsPaneImpl searchLimitPane = new OptionsPaneImpl("OPTIONS_SEARCH_LIMIT_MAIN_TITLE");
        searchLimitPane.add(new MaximumSearchesPaneItem("SEARCH_MAX"));
        this.addOption("OPTIONS_SEARCH_MAIN_TITLE", searchLimitPane);
        OptionsPaneImpl searchQualityPane = new OptionsPaneImpl("OPTIONS_SEARCH_QUALITY_MAIN_TITLE");
        searchQualityPane.add(new SearchQualityPaneItem("SEARCH_QUALITY"));
        this.addOption("OPTIONS_SEARCH_MAIN_TITLE", searchQualityPane);
        OptionsPaneImpl searchSpeedPane = new OptionsPaneImpl("OPTIONS_SEARCH_SPEED_MAIN_TITLE");
        searchSpeedPane.add(new SearchSpeedPaneItem("SEARCH_SPEED"));
        this.addOption("OPTIONS_SEARCH_MAIN_TITLE", searchSpeedPane);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", "OPTIONS_FILTERS_MAIN_TITLE");
        OptionsPaneImpl filtersResultsPane = new OptionsPaneImpl("OPTIONS_RESULTS_MAIN_TITLE");
        filtersResultsPane.add(new IgnoreResultsPaneItem("IGNORE_RESULTS"));
        filtersResultsPane.add(new IgnoreResultTypesPaneItem("IGNORE_RESULT_TYPES"));
        this.addOption("OPTIONS_FILTERS_MAIN_TITLE", filtersResultsPane);
        OptionsPaneImpl filtersMessagesPane = new OptionsPaneImpl("OPTIONS_MESSAGES_MAIN_TITLE");
        filtersMessagesPane.add(new IgnoreMessagesPaneItem("IGNORE_MESSAGES"));
        filtersMessagesPane.add(new AllowMessagesPaneItem("ALLOW_MESSAGES"));
        this.addOption("OPTIONS_FILTERS_MAIN_TITLE", filtersMessagesPane);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", "OPTIONS_ADVANCED_MAIN_TITLE");
        OptionsPaneImpl preferencingPane = new OptionsPaneImpl("OPTIONS_PREFERENCING_MAIN_TITLE");
        preferencingPane.add(new ConnectionPreferencingPaneItem("CONNECT_PREF"));
        this.addOption("OPTIONS_ADVANCED_MAIN_TITLE", preferencingPane);
        OptionsPaneImpl portPane = new OptionsPaneImpl("OPTIONS_FIREWALL_MAIN_TITLE");
        portPane.add(new PortPaneItem("PORT"));
        portPane.add(new ForceIPPaneItem("ROUTER"));
        this.addOption("OPTIONS_ADVANCED_MAIN_TITLE", portPane);
        OptionsPaneImpl proxyPane = new OptionsPaneImpl("OPTIONS_PROXY_MAIN_TITLE");
        proxyPane.add(new ProxyPaneItem("PROXY"));
        proxyPane.add(new ProxyLoginPaneItem("PROXY_LOGIN"));
        this.addOption("OPTIONS_ADVANCED_MAIN_TITLE", proxyPane);
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            OptionsPaneImpl startupPane = new OptionsPaneImpl("OPTIONS_STARTUP_MAIN_TITLE");
            startupPane.add(new StartupPaneItem("STARTUP"));
            this.addOption("OPTIONS_ADVANCED_MAIN_TITLE", startupPane);
        }
    }

    private final void addGroupTreeNode(String parentKey, String childKey) {
        this.TREE_MANAGER.addNode(parentKey, childKey, GUIMediator.getStringResource(childKey));
    }

    private final void addOption(String parentKey, OptionsPane pane) {
        this.TREE_MANAGER.addNode(parentKey, pane.getName(), GUIMediator.getStringResource(pane.getName()));
        this.PANE_MANAGER.addPane(pane);
    }

    public final void setOptionsVisible(boolean visible) {
        if (!visible) {
            this.DIALOG.dispose();
        } else {
            if (GUIMediator.isAppVisible()) {
                this.DIALOG.setLocationRelativeTo(GUIMediator.getAppFrame());
            } else {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension dialogSize = this.DIALOG.getSize();
                this.DIALOG.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
            }
            this.DIALOG.show();
        }
    }

    public final boolean isOptionsVisible() {
        return this.DIALOG.isVisible();
    }

    JDialog getMainOptionsComponent() {
        return this.DIALOG;
    }
}

