/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.limegroup.gnutella.xml.XMLStringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DisplayManager {
    private static DisplayManager instance;
    private HashMap schemaToDispProps = new HashMap();

    private DisplayManager() {
        Collection schemas = LimeXMLSchemaRepository.instance().getAvailableSchemas();
        Iterator i = schemas.iterator();
        while (i.hasNext()) {
            this.loadDisplayProperties((LimeXMLSchema)i.next());
        }
    }

    public static DisplayManager instance() {
        if (instance == null) {
            instance = new DisplayManager();
            return instance;
        }
        return instance;
    }

    public String getDisplayName(String rawName, String schemaDesc) {
        String dispName;
        ResourceBundle rb = (ResourceBundle)this.schemaToDispProps.get(schemaDesc);
        if (rb == null) {
            return LimeXMLUtils.processColName(rawName);
        }
        try {
            dispName = rb.getString(rawName);
        }
        catch (MissingResourceException mre) {
            String dispName2 = LimeXMLUtils.processColName(rawName);
            return dispName2;
        }
        dispName = DisplayManager.stripPreferredSize(dispName);
        return dispName;
    }

    public String getDisplayTitleForSchema(String schemaURI) {
        String common = LimeXMLSchema.getDisplayString(schemaURI);
        LimeXMLSchema sc = LimeXMLSchemaRepository.instance().getSchema(schemaURI);
        List fields = sc.getCanonicalizedFields();
        SchemaFieldInfo infoField = (SchemaFieldInfo)fields.get(0);
        String currField = infoField.getCanonicalizedFieldName();
        List currFieldList = XMLStringUtils.split(currField);
        String ancestorCanonicalized = (String)currFieldList.remove(0);
        return this.getDisplayName(ancestorCanonicalized + "__" + common, common);
    }

    public static String stripPreferredSize(String rawName) {
        int i = rawName.indexOf("^");
        if (i < 0) {
            return rawName;
        }
        return rawName.substring(0, i);
    }

    private void loadDisplayProperties(LimeXMLSchema schema) {
        try {
            String key = schema.getDescription();
            ResourceBundle rb = GUIMediator.getXMLResourceBundle(key);
            this.schemaToDispProps.put(key, rb);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

