/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.TableLine;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

final class SearchResultMenu {
    final ResultPanel PANEL;

    SearchResultMenu(ResultPanel rp) {
        this.PANEL = rp;
    }

    private static void add(String s, ActionListener l, JPopupMenu m, boolean enable) {
        JMenuItem item = new JMenuItem(s);
        item.addActionListener(l);
        item.setEnabled(enable);
        m.add(item);
    }

    JPopupMenu createMenu(TableLine line) {
        JPopupMenu menu = new JPopupMenu();
        SearchResultMenu.add(SearchMediator.DOWNLOAD_STRING, this.PANEL.DOWNLOAD_LISTENER, menu, line != null);
        SearchResultMenu.add(GUIMediator.getStringResource("LICENSE_CC_VIEW_LICENSE"), new LicenseListener(), menu, line != null && line.isLicenseAvailable());
        SearchResultMenu.add(SearchMediator.CHAT_STRING, this.PANEL.CHAT_LISTENER, menu, line != null && line.isChatEnabled());
        SearchResultMenu.add(SearchMediator.BITZI_LOOKUP_STRING, new BitziListener(), menu, line != null);
        SearchResultMenu.add(SearchMediator.BROWSE_HOST_STRING, this.PANEL.BROWSE_HOST_LISTENER, menu, line != null && line.isBrowseHostEnabled());
        SearchResultMenu.add(SearchMediator.BLOCK_STRING, new BlockListener(), menu, line != null);
        menu.addSeparator();
        SearchResultMenu.add(SearchMediator.REPEAT_SEARCH_STRING, new RepeatListener(), menu, this.PANEL.isRepeatSearchEnabled());
        SearchResultMenu.add(SearchMediator.STOP_STRING, this.PANEL.STOP_LISTENER, menu, !this.PANEL.isStopped());
        SearchResultMenu.add(SearchMediator.KILL_STRING, new CancelListener(), menu, this.PANEL.isKillable());
        if (line != null && line.isLaunchable()) {
            menu.addSeparator();
            SearchResultMenu.add(SearchMediator.LAUNCH_STRING, this.PANEL.DOWNLOAD_LISTENER, menu, true);
        }
        return menu;
    }

    private class RepeatListener
    implements ActionListener {
        private RepeatListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SearchResultMenu.this.PANEL.repeatSearch();
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SearchMediator.killSearch();
        }
    }

    private class BlockListener
    implements ActionListener {
        private BlockListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SearchResultMenu.this.PANEL.blockHost();
        }
    }

    private class BitziListener
    implements ActionListener {
        private BitziListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SearchResultMenu.this.PANEL.doBitziLookup();
        }
    }

    private class LicenseListener
    implements ActionListener {
        private LicenseListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SearchResultMenu.this.PANEL.showLicense();
        }
    }
}

