/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics.panes;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.GUIMediator;

public final class GraphAxisData {
    private static final int BYTES_PER_KILOBYTE = 1024;
    private final int X_INCREMENT;
    private final int X_PIXEL_VALUE;
    private final double ULTRAPEER_Y_PIXELS;
    private final double LEAF_Y_PIXELS;
    private final int ULTRAPEER_Y_INCREMENT;
    private final int LEAF_Y_INCREMENT;
    private final int ULTRAPEER_TOTAL_Y_VALUES;
    private final int LEAF_TOTAL_Y_VALUES;
    private final int Y_SCALE;
    private final String X_AXIS_LABEL;
    private final String Y_AXIS_LABEL;
    private static int DEFAULT_X_PIXELS = 2;
    private static int DEFAULT_X_INCREMENT = 20;
    private static final double DEFAULT_ULTRAPEER_Y_PIXELS = 0.35;
    private static final double DEFAULT_LEAF_Y_PIXELS = 3.0;
    private static final double DEFAULT_ULTRAPEER_Y_KILOBYTE_PIXELS = 2.0;
    private static final double DEFAULT_LEAF_Y_KILOBYTE_PIXELS = 3.0;
    private static final int DEFAULT_ULTRAPEER_Y_INCREMENT = 100;
    private static final int DEFAULT_LEAF_Y_INCREMENT = 10;
    private static final int DEFAULT_ULTRAPEER_Y_KILOBYTE_INCREMENT = 10;
    private static final int DEFAULT_LEAF_Y_KILOBYTE_INCREMENT = 5;
    private static final int DEFAULT_ULTRAPEER_TOTAL_Y_VALUES = 500;
    private static final int DEFAULT_LEAF_TOTAL_Y_VALUES = 60;
    private static final int DEFAULT_ULTRAPEER_TOTAL_Y_KILOBYTE_VALUES = 60;
    private static final int DEFAULT_LEAF_TOTAL_Y_KILOBYTE_VALUES = 20;

    GraphAxisData() {
        this(0.35, 3.0, 100, 10, 500, 60);
    }

    GraphAxisData(double ultrapeerYPixels, double leafYPixels, int ultrapeerYIncrement, int leafYIncrement, int ultrapeerTotalYValues, int leafTotalYValues) {
        this(ultrapeerYPixels, leafYPixels, ultrapeerYIncrement, leafYIncrement, ultrapeerTotalYValues, leafTotalYValues, 1, GUIMediator.getStringResource("DEFAULT_X_AXIS_LABEL"), GUIMediator.getStringResource("DEFAULT_Y_AXIS_LABEL"));
    }

    GraphAxisData(double ultrapeerYPixels, double leafYPixels, int ultrapeerYIncrement, int leafYIncrement, int ultrapeerTotalYValues, int leafTotalYValues, int yScale, String xLabel, String yLabel) {
        this(DEFAULT_X_PIXELS, ultrapeerYPixels, leafYPixels, DEFAULT_X_INCREMENT, ultrapeerYIncrement, leafYIncrement, ultrapeerTotalYValues, leafTotalYValues, yScale, xLabel, yLabel);
    }

    static GraphAxisData createKilobyteGraphData() {
        return new GraphAxisData(2.0, 3.0, 10, 5, 60, 20, 1024, GUIMediator.getStringResource("DEFAULT_X_AXIS_LABEL"), GUIMediator.getStringResource("Y_AXIS_BANDWIDTH_LABEL"));
    }

    static GraphAxisData createBandwidthGraphData() {
        return new GraphAxisData(0.6, 0.6, 60, 60, 200, 200, 1024, GUIMediator.getStringResource("DEFAULT_X_AXIS_LABEL"), GUIMediator.getStringResource("Y_AXIS_BANDWIDTH_LABEL"));
    }

    private GraphAxisData(int xPixelValue, double ultrapeerYPixels, double leafYPixels, int xIncrement, int ultrapeerYIncrement, int leafYIncrement, int ultrapeerTotalYValues, int leafTotalYValues, int yScale, String xAxisLabel, String yAxisLabel) {
        this.X_PIXEL_VALUE = xPixelValue;
        this.ULTRAPEER_Y_PIXELS = ultrapeerYPixels;
        this.LEAF_Y_PIXELS = leafYPixels;
        this.ULTRAPEER_Y_INCREMENT = ultrapeerYIncrement;
        this.LEAF_Y_INCREMENT = leafYIncrement;
        this.X_INCREMENT = xIncrement;
        this.ULTRAPEER_TOTAL_Y_VALUES = ultrapeerTotalYValues;
        this.LEAF_TOTAL_Y_VALUES = leafTotalYValues;
        this.Y_SCALE = yScale;
        this.X_AXIS_LABEL = xAxisLabel;
        this.Y_AXIS_LABEL = yAxisLabel;
    }

    public int getXPixelValue() {
        return this.X_PIXEL_VALUE;
    }

    public double getYPixelValue() {
        if (RouterService.isSupernode()) {
            return this.ULTRAPEER_Y_PIXELS;
        }
        return this.LEAF_Y_PIXELS;
    }

    public int getYScale() {
        return this.Y_SCALE;
    }

    public int getXIncrement() {
        return this.X_INCREMENT;
    }

    public int getYIncrement() {
        if (RouterService.isSupernode()) {
            return this.ULTRAPEER_Y_INCREMENT;
        }
        return this.LEAF_Y_INCREMENT;
    }

    public int getTotalXValues() {
        return 200;
    }

    public int getTotalYValues() {
        if (RouterService.isSupernode()) {
            return this.ULTRAPEER_TOTAL_Y_VALUES;
        }
        return this.LEAF_TOTAL_Y_VALUES;
    }

    public String getXAxisLabel() {
        return this.X_AXIS_LABEL;
    }

    public String getYAxisLabel() {
        return this.Y_AXIS_LABEL;
    }
}

