/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.TitledPaddedPanel;
import com.limegroup.gnutella.gui.statistics.panes.GraphAxisData;
import com.limegroup.gnutella.gui.statistics.panes.GraphPainter;
import com.limegroup.gnutella.gui.statistics.panes.PaneItem;
import com.limegroup.gnutella.gui.statistics.panes.PaneItemMainLabel;
import com.limegroup.gnutella.statistics.Statistic;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import javax.swing.Box;
import javax.swing.JComponent;

public class PaneItemImpl
implements PaneItem,
RefreshListener {
    private final TitledPaddedPanel CONTAINER = new TitledPaddedPanel();
    private static final Component HORIZONTAL_SEPARATOR = Box.createRigidArea(new Dimension(6, 0));
    private static final Component VERTICAL_SEPARATOR = Box.createRigidArea(new Dimension(0, 6));
    private final GraphPainter PAINTER;
    private final PaneItemMainLabel LABEL;

    public PaneItemImpl(String key) {
        this(key, new GraphAxisData());
    }

    public PaneItemImpl(String key, GraphAxisData data) {
        String title = "STATS_" + key + "_TITLE";
        String label = "STATS_" + key + "_LABEL";
        this.CONTAINER.setTitle(GUIMediator.getStringResource(title));
        this.LABEL = new PaneItemMainLabel(GUIMediator.getStringResource(label));
        this.add(this.LABEL.getLabel());
        this.PAINTER = new GraphPainter(data);
        this.add(this.PAINTER);
    }

    public JComponent getStatsComponent() {
        return this.PAINTER;
    }

    public Container getContainer() {
        return this.CONTAINER;
    }

    protected final void add(Component comp) {
        this.CONTAINER.add(comp);
    }

    protected final Component getHorizontalSeparator() {
        return HORIZONTAL_SEPARATOR;
    }

    protected final Component getVerticalSeparator() {
        return VERTICAL_SEPARATOR;
    }

    public void registerStatistic(Statistic stat, String displayName) {
        this.PAINTER.registerStatistic(stat, displayName);
    }

    public void refresh() {
        this.PAINTER.repaint();
    }

    public String toString() {
        return "PaneItemImpl: " + this.CONTAINER.getTitle();
    }

    public void componentResized(ComponentEvent e, Component comp) {
        this.LABEL.componentResized(e, comp);
    }
}

