/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tabs;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.tabs.Tab;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import javax.swing.Icon;
import javax.swing.JComponent;

abstract class AbstractTab
implements Tab,
ThemeObserver {
    private final String TITLE;
    private final String TOOL_TIP;
    private Icon _icon;
    private final String ICON_FILE;
    protected final int INDEX;

    AbstractTab(String KEY, int INDEX, String ICON) {
        this.INDEX = INDEX;
        this.TITLE = GUIMediator.getStringResource(KEY + "_TITLE");
        this.TOOL_TIP = GUIMediator.getStringResource(KEY + "_TIP");
        this.ICON_FILE = ICON;
        this._icon = GUIMediator.getThemeImage(this.ICON_FILE);
        ThemeMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        this._icon = GUIMediator.getThemeImage(this.ICON_FILE);
        GUIMediator.instance().updateTabIcon(this.INDEX);
    }

    public abstract void storeState(boolean var1);

    public abstract JComponent getComponent();

    public String getTitle() {
        return this.TITLE;
    }

    public String getToolTip() {
        return this.TOOL_TIP;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public int getIndex() {
        return this.INDEX;
    }

    public String toString() {
        return this.TITLE + " tab";
    }

    public void mouseClicked() {
    }
}

