/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LimeTextField;
import com.limegroup.gnutella.gui.search.DisplayManager;
import com.limegroup.gnutella.gui.search.SearchField;
import com.limegroup.gnutella.gui.xml.ComboBoxValue;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

public abstract class IndentingPanel
extends JPanel
implements Scrollable {
    private static final String KEY_PROP = "lime.canonKey";
    private static final String DEFAULT_PROP = "lime.defaultField";
    private static final int DEFAULT_FIELDS = 4;
    private Component focusRequestor;

    public IndentingPanel(LimeXMLSchema schema, ActionListener listener, Document document, UndoManager undoer, boolean expand, boolean indent, boolean searching) {
        this.setOpaque(false);
        int fieldsToShow = expand ? schema.getCanonicalizedFields().size() : 4;
        List fields = schema.getCanonicalizedFields();
        boolean firstTextFieldAdded = false;
        boolean defaultField = true;
        int added = 0;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridwidth = 0;
        for (int i = 0; i < fields.size(); ++i) {
            JComponent comp;
            SchemaFieldInfo infoField = (SchemaFieldInfo)fields.get(i);
            if (!searching && !infoField.isEditable()) continue;
            if (added == fieldsToShow) {
                this.addMoreOptions(c);
                defaultField = false;
            }
            if ((comp = this.addField(schema, infoField, c, defaultField, searching)) instanceof JTextField) {
                if (!firstTextFieldAdded) {
                    this.focusRequestor = comp;
                    firstTextFieldAdded = true;
                    if (document != null) {
                        ((JTextField)comp).setDocument(document);
                    }
                    if (undoer != null) {
                        ((LimeTextField)comp).setUndoManager(undoer);
                    }
                }
                ((JTextField)comp).addActionListener(listener);
            }
            ++added;
        }
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 0;
        this.add(Box.createGlue(), c);
        this.setFieldsVisible(false);
    }

    public void addMoreOptionsListener(ActionListener e) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof JCheckBox)) continue;
            ((JCheckBox)c).addActionListener(e);
        }
    }

    private void addMoreOptions(GridBagConstraints c) {
        JCheckBox moreOptions = new JCheckBox(GUIMediator.getStringResource("XML_SEARCH_MORE_OPTIONS_LABEL"));
        moreOptions.setOpaque(false);
        moreOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                IndentingPanel.this.setFieldsVisible(source.isSelected());
                IndentingPanel.this.invalidate();
                IndentingPanel.this.revalidate();
            }
        });
        c.insets = new Insets(2, 0, 5, 0);
        c.fill = 0;
        this.add((Component)moreOptions, c);
    }

    private JComponent getTextField(boolean searching) {
        return searching ? new SearchField(14) : new AutoCompleteTextField(30);
    }

    private JComboBox getOptions(SchemaFieldInfo infoField) {
        List values = infoField.getEnumerationList();
        int d = values.size();
        Object[] vals = new ComboBoxValue[d + 1];
        vals[0] = new ComboBoxValue("", "");
        for (int m = 0; m < d; ++m) {
            vals[m + 1] = new ComboBoxValue((NameValue)values.get(m));
        }
        Arrays.sort(vals);
        JComboBox<Object> comboBox = new JComboBox<Object>(vals);
        comboBox.setOpaque(false);
        return comboBox;
    }

    private JComponent addField(LimeXMLSchema schema, SchemaFieldInfo infoField, GridBagConstraints c, boolean defaultField, boolean searching) {
        String currField = infoField.getCanonicalizedFieldName();
        String fieldName = DisplayManager.instance().getDisplayName(currField, schema.getDescription());
        JLabel label = new JLabel(LimeXMLUtils.capitalizeFirst(fieldName));
        c.insets = new Insets(0, 0, 3, 0);
        c.fill = 2;
        this.add((Component)label, c);
        JComponent comp = null;
        switch (infoField.getFieldType()) {
            case 1: {
                comp = this.getTextField(searching);
                break;
            }
            case 2: {
                comp = this.getOptions(infoField);
                break;
            }
            default: {
                Assert.that(false, "bad type: " + infoField.getFieldType() + ", name: " + currField);
            }
        }
        c.insets = new Insets(0, 0, 5, 0);
        this.add((Component)comp, c);
        comp.putClientProperty(KEY_PROP, currField);
        if (!defaultField) {
            label.putClientProperty(DEFAULT_PROP, Boolean.FALSE);
            comp.putClientProperty(DEFAULT_PROP, Boolean.FALSE);
        }
        return comp;
    }

    private void setFieldsVisible(boolean viz) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Object key;
            Component c = this.getComponent(i);
            if (!(c instanceof JComponent) || (key = ((JComponent)c).getClientProperty(DEFAULT_PROP)) != Boolean.FALSE) continue;
            c.setVisible(viz);
        }
    }

    public void requestFirstFocus() {
        if (this.focusRequestor != null) {
            this.focusRequestor.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    protected JComponent getField(String fieldName) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Object key;
            Component c = this.getComponent(i);
            if (!(c instanceof JComponent) || (key = ((JComponent)c).getClientProperty(KEY_PROP)) == null || !key.equals(fieldName)) continue;
            return (JComponent)c;
        }
        return null;
    }

    public void clear() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.clearField(this.getComponent(i));
        }
    }

    protected void clearField(Component c) {
        if (c instanceof JTextField) {
            ((JTextField)c).setText(null);
        } else if (c instanceof JComboBox) {
            ((JComboBox)c).setSelectedIndex(0);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 0: {
                return visibleRect.width / 10;
            }
            case 1: {
                return visibleRect.height / 10;
            }
        }
        throw new IllegalArgumentException("Unknown orientation " + orientation);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 0: {
                return visibleRect.width;
            }
            case 1: {
                return visibleRect.height;
            }
        }
        throw new IllegalArgumentException("Unknown orientation " + orientation);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

