/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.xml.MetaEditorFrame;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.audio.AudioTabbedPane;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.xml.sax.SAXException;

public class MetaEditor
extends JDialog {
    private FileDesc fd;
    private String fileName;
    private Frame parent;
    private JButton advancedButton;
    private JButton cancelButton;
    private JButton okButton;
    private JTabbedPane tabbedPane;

    public MetaEditor(FileDesc fd, String fileName, Frame parent) {
        super(parent, true);
        this.fd = fd;
        this.fileName = fileName;
        this.parent = parent;
        this.initComponents();
        if (CommonUtils.isMacOSX() && CommonUtils.isJava14OrLater()) {
            this.tabbedPane.setFocusable(false);
        }
        this.advancedButton.setText(GUIMediator.getStringResource("META_EDITOR_ADVANCED_BUTTON_LABEL"));
        this.okButton.setText(GUIMediator.getStringResource("META_EDITOR_OK_BUTTON_LABEL"));
        this.cancelButton.setText(GUIMediator.getStringResource("META_EDITOR_CANCEL_BUTTON_LABEL"));
        this.setTitle(fd.getFile().getName());
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.requestFocus();
        this.okButton.updateUI();
        this.cancelButton.updateUI();
        this.advancedButton.updateUI();
        GUIUtils.addHideAction((JComponent)this.getContentPane());
        this.pack();
    }

    private void center(Window window) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - window.getSize().width) / 2;
        int y = (int)((float)(screen.height - window.getSize().height) / 3.333333f);
        window.setLocation(x, y);
    }

    public void show() {
        this.center(this);
        super.show();
    }

    private void removeMeta(LimeXMLSchema schema) {
        String uri = schema.getSchemaURI();
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection collection = map.getReplyCollection(uri);
        Assert.that(collection != null, "Trying to remove data from a non-existent collection");
        if (!collection.removeDoc(this.fd)) {
            GUIMediator.showError("ERROR_DEL_META_SYSTEM");
        }
    }

    private void saveMeta(MetaEditorTabbedPane pane) {
        String XMLString = pane.getInput();
        if (XMLString == null) {
            return;
        }
        if (XMLString.trim().length() == 0) {
            this.removeMeta(pane.getSchema());
            return;
        }
        LimeXMLDocument oldDoc = pane.getDocument();
        LimeXMLDocument newDoc = null;
        try {
            newDoc = new LimeXMLDocument(XMLString);
        }
        catch (SAXException e) {
            GUIMediator.showError("ERROR_SAVE_META_DOC");
            return;
        }
        catch (SchemaNotFoundException e) {
            GUIMediator.showError("ERROR_SAVE_META_DOC");
            return;
        }
        catch (IOException e) {
            GUIMediator.showError("ERROR_SAVE_META_DOC");
            return;
        }
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        String uri = newDoc.getSchemaURI();
        LimeXMLReplyCollection collection = map.getReplyCollection(uri);
        Assert.that(collection != null, "Cant add doc to nonexistent collection");
        if (oldDoc == null) {
            collection.addReply(this.fd, newDoc);
        } else {
            oldDoc = collection.replaceDoc(this.fd, newDoc);
        }
        if (LimeXMLUtils.isSupportedFormat(this.fileName)) {
            int committed = collection.mediaFileToDisk(this.fd, this.fileName, newDoc, false);
            switch (committed) {
                case 1: {
                    GUIMediator.showError("ERROR_SAVE_META_FILE");
                    break;
                }
                case 2: {
                    GUIMediator.showError("ERROR_SAVE_META_RW");
                    break;
                }
                case 3: {
                    GUIMediator.showError("ERROR_SAVE_META_ID3");
                    break;
                }
                case 4: {
                    GUIMediator.showError("ERROR_SAVE_META_ID3");
                    break;
                }
                case 5: {
                    this.cleanUpChanges("audios__audio__artist__", collection, oldDoc);
                    break;
                }
                case 6: {
                    this.cleanUpChanges("audios__audio__album__", collection, oldDoc);
                    break;
                }
                case 7: {
                    this.cleanUpChanges("audios__audio__year__", collection, oldDoc);
                    break;
                }
                case 8: {
                    this.cleanUpChanges("audios__audio__comments__", collection, oldDoc);
                    break;
                }
                case 9: {
                    this.cleanUpChanges("audios__audio__track__", collection, oldDoc);
                    break;
                }
                case 10: {
                    this.cleanUpChanges("audios__audio__genre__", collection, oldDoc);
                    break;
                }
                case 11: {
                    GUIMediator.showError("ERROR_SAVE_META_DISK");
                }
            }
        } else if (!collection.write()) {
            GUIMediator.showError("ERROR_SAVE_META_DISK");
        }
    }

    private void cleanUpChanges(String canonicalFieldName, LimeXMLReplyCollection collection, LimeXMLDocument oldDoc) {
        GUIMediator.showError("ERROR_SAVE_META_BAD");
        if (oldDoc == null) {
            collection.removeDoc(this.fd);
        } else {
            collection.replaceDoc(this.fd, oldDoc);
        }
    }

    private JTabbedPane createTabbedPane() {
        AudioTabbedPane tabbedPane = null;
        if (LimeXMLUtils.isSupportedAudioFormat(this.fileName)) {
            tabbedPane = new AudioTabbedPane(this.fd);
        }
        return tabbedPane;
    }

    private void initComponents() {
        this.tabbedPane = this.createTabbedPane();
        JPanel buttonPanel1 = new JPanel();
        JPanel cancelOKPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        JPanel spacer1 = new JPanel();
        JPanel advancedPanel = new JPanel();
        this.advancedButton = new JButton();
        JPanel spacer2 = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setCursor(new Cursor(0));
        this.setLocationRelativeTo(this);
        this.setName("MetaEditorDialog");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MetaEditor.this.doWindowClose(evt);
            }
        });
        this.tabbedPane.setMinimumSize(null);
        this.tabbedPane.setNextFocusableComponent(this.okButton);
        this.tabbedPane.setPreferredSize(null);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        buttonPanel1.setLayout(new BorderLayout());
        buttonPanel1.setMinimumSize(new Dimension(264, 40));
        buttonPanel1.setPreferredSize(new Dimension(0, 40));
        cancelOKPanel.setLayout(new GridBagLayout());
        this.cancelButton.setText("Cancel");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.setNextFocusableComponent(this.advancedButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MetaEditor.this.doCancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        cancelOKPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.setNextFocusableComponent(this.cancelButton);
        this.okButton.setSelected(true);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MetaEditor.this.doOK(evt);
            }
        });
        cancelOKPanel.add((Component)this.okButton, new GridBagConstraints());
        cancelOKPanel.add((Component)spacer1, new GridBagConstraints());
        buttonPanel1.add((Component)cancelOKPanel, "East");
        advancedPanel.setLayout(new GridBagLayout());
        this.advancedButton.setText("Advanced");
        this.advancedButton.setFocusPainted(false);
        this.advancedButton.setNextFocusableComponent(this.okButton);
        this.advancedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MetaEditor.this.doAdvanced(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        advancedPanel.add((Component)this.advancedButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        advancedPanel.add((Component)spacer2, gridBagConstraints);
        buttonPanel1.add((Component)advancedPanel, "West");
        this.getContentPane().add((Component)buttonPanel1, "South");
        this.pack();
    }

    private void doAdvanced(ActionEvent evt) {
        MetaEditorFrame frame = new MetaEditorFrame(this.fd, this.fileName, this.parent);
        this.setVisible(false);
        this.dispose();
        this.center(frame);
        frame.show();
        frame.dispose();
    }

    private void doWindowClose(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void doOK(ActionEvent evt) {
        GUIMediator.instance().schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    GUIMediator.safeInvokeAndWait(new Runnable(this){
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            LibraryMediator.instance().setAnnotateEnabled(false);
                        }
                    });
                    MetaEditor.this.saveMeta((MetaEditorTabbedPane)MetaEditor.this.tabbedPane);
                }
                catch (Throwable throwable) {
                    GUIMediator.safeInvokeAndWait(new Runnable(this){
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            LibraryMediator.instance().setAnnotateEnabled(true);
                        }
                    });
                    throw throwable;
                }
                GUIMediator.safeInvokeAndWait(new /* invalid duplicate definition of identical inner class */);
            }
        });
        this.setVisible(false);
        this.dispose();
    }

    private void doCancel(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

