/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.xml.ComboBoxValue;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public abstract class MetaEditorPanel
extends JPanel {
    private HashMap nameToComponent;
    private ArrayList checkboxes;
    protected final FileDesc fd;
    protected final LimeXMLDocument document;
    protected final LimeXMLSchema schema;
    protected final List uneditedNameValues;

    public MetaEditorPanel(FileDesc fd, LimeXMLSchema schema, LimeXMLDocument document) {
        this.fd = fd;
        this.schema = schema;
        this.document = document;
        this.nameToComponent = new HashMap();
        this.checkboxes = new ArrayList();
        this.uneditedNameValues = new LinkedList();
        this.addAllFields();
    }

    public FileDesc getFileDesc() {
        return this.fd;
    }

    public LimeXMLDocument getDocument() {
        return this.document;
    }

    public LimeXMLSchema getSchema() {
        return this.schema;
    }

    public String getValue(String name) {
        return this.document != null ? this.document.getValue(name) : null;
    }

    public void addComponent(String name, JComponent component) {
        this.addComponent(name, null, component);
    }

    public void addComponent(String name, JCheckBox checkbox, JComponent component) {
        this.nameToComponent.put(name, component);
        Iterator i = this.uneditedNameValues.iterator();
        while (i.hasNext()) {
            NameValue nv = (NameValue)i.next();
            if (!nv.getName().equals(name)) continue;
            i.remove();
            break;
        }
        if (checkbox != null) {
            this.link(checkbox, component);
        }
    }

    public JComponent getComponent(String name) {
        return (JComponent)this.nameToComponent.get(name);
    }

    public Iterator getComponentIterator() {
        return this.nameToComponent.keySet().iterator();
    }

    public Iterator getUneditedFieldsIterator() {
        return this.uneditedNameValues.iterator();
    }

    private void link(final JCheckBox checkbox, JComponent comp) {
        if (comp instanceof JTextComponent) {
            ((JTextComponent)comp).addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent evt) {
                    checkbox.setSelected(true);
                }
            });
            this.checkboxes.add(checkbox);
        } else if (comp instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)comp;
            comboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    checkbox.setSelected(true);
                }
            });
            if (comboBox.isEditable()) {
                JTextComponent editor = (JTextComponent)comboBox.getEditor().getEditorComponent();
                editor.addKeyListener(new KeyAdapter(){

                    public void keyTyped(KeyEvent evt) {
                        checkbox.setSelected(true);
                    }
                });
            }
            this.checkboxes.add(checkbox);
        }
    }

    public boolean hasChanged() {
        Iterator it = this.checkboxes.iterator();
        while (it.hasNext()) {
            if (!((JCheckBox)it.next()).isSelected()) continue;
            return true;
        }
        return false;
    }

    public void setCheckBoxesSelected(boolean selected) {
        Iterator it = this.checkboxes.iterator();
        while (it.hasNext()) {
            ((JCheckBox)it.next()).setSelected(selected);
        }
    }

    public void setCheckBoxesVisible(boolean visible) {
        Iterator it = this.checkboxes.iterator();
        while (it.hasNext()) {
            ((JCheckBox)it.next()).setVisible(visible);
        }
    }

    public void reset() {
        Iterator it = this.getComponentIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            JComponent comp = this.getComponent(name);
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setText("");
                continue;
            }
            if (!(comp instanceof JComboBox)) continue;
            ((JComboBox)comp).setSelectedIndex(0);
        }
        this.setCheckBoxesSelected(true);
    }

    public void prepareSave() {
    }

    protected void addEnums(List nameValues, List comboValues) {
        Iterator i = nameValues.iterator();
        while (i.hasNext()) {
            comboValues.add(new ComboBoxValue((NameValue)i.next()));
        }
    }

    private void addAllFields() {
        if (this.document != null) {
            Iterator i = this.document.getNameValueSet().iterator();
            while (i.hasNext()) {
                Map.Entry next = (Map.Entry)i.next();
                this.uneditedNameValues.add(new NameValue((String)next.getKey(), next.getValue()));
            }
        }
    }
}

