/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientManager {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$http$HttpClientManager == null ? (class$com$limegroup$gnutella$http$HttpClientManager = HttpClientManager.class$("com.limegroup.gnutella.http.HttpClientManager")) : class$com$limegroup$gnutella$http$HttpClientManager);
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int TIMEOUT = 8000;
    private static final int MAXIMUM_REDIRECTS = 10;
    private static final long IDLE_TIME = 30000L;
    private static final HttpConnectionManager MANAGER = new MultiThreadedHttpConnectionManager();
    static /* synthetic */ Class class$com$limegroup$gnutella$http$HttpClientManager;

    public static HttpClient getNewClient() {
        return HttpClientManager.getNewClient(5000, 8000);
    }

    public static HttpClient getNewClient(int connectTimeout, int soTimeout) {
        HttpClient client = new HttpClient(MANAGER);
        client.setConnectionTimeout(connectTimeout);
        client.setTimeout(soTimeout);
        int connectionType = ConnectionSettings.CONNECTION_METHOD.getValue();
        if (connectionType == 1) {
            client.getHostConfiguration().setProxy(ConnectionSettings.PROXY_HOST.getValue(), ConnectionSettings.PROXY_PORT.getValue());
        } else if (connectionType == 4 || connectionType == 5) {
            HostConfiguration hc = client.getHostConfiguration();
            String proxyHost = ConnectionSettings.PROXY_HOST.getValue();
            int proxyPort = ConnectionSettings.PROXY_PORT.getValue();
            String user = null;
            String pass = null;
            if (ConnectionSettings.PROXY_AUTHENTICATE.getValue()) {
                user = ConnectionSettings.PROXY_USERNAME.getValue();
                pass = ConnectionSettings.PROXY_PASS.getValue();
            }
            if (connectionType == 4) {
                hc.setSOCKSProxySettings(4, proxyHost, proxyPort, user, pass);
            } else {
                hc.setSOCKSProxySettings(5, proxyHost, proxyPort, user, pass);
            }
        }
        return client;
    }

    public static void executeMethodRedirecting(HttpClient client, HttpMethod methid) throws IOException, HttpException {
        HttpClientManager.executeMethodRedirecting(client, methid, 10);
    }

    public static void executeMethodRedirecting(HttpClient client, HttpMethod methid, int redirects) throws IOException, HttpException {
        block3: for (int i = 0; i < redirects; ++i) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Attempting connection (" + i + ") to " + methid.getURI().getEscapedURI());
            }
            client.executeMethod(methid);
            switch (methid.getStatusCode()) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    if (!methid.getFollowRedirects()) {
                        if (LOG.isInfoEnabled()) {
                            LOG.warn("Redirect requested but not supported");
                        }
                        throw new HttpException("Redirect requested");
                    }
                    Header locationHeader = methid.getResponseHeader("location");
                    if (locationHeader == null) {
                        if (LOG.isInfoEnabled()) {
                            LOG.warn("Redirect requested, no location header");
                        }
                        throw new HttpException("Redirected without a location");
                    }
                    String location = locationHeader.getValue();
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Redirected requested to: " + location);
                    }
                    URI newLocation = new URI(location.toCharArray());
                    Header[] requestHeaders = methid.getRequestHeaders();
                    methid.recycle();
                    HostConfiguration hc = methid.getHostConfiguration();
                    hc.setHost(newLocation.getHost(), newLocation.getPort(), newLocation.getScheme());
                    methid.setFollowRedirects(true);
                    for (int j = 0; j < requestHeaders.length; ++j) {
                        if (requestHeaders[j].getName().equals("Host")) continue;
                        methid.addRequestHeader(requestHeaders[j]);
                    }
                    methid.setPath(newLocation.getEscapedPath());
                    methid.setQueryString(newLocation.getEscapedQuery());
                    methid.removeRequestHeader("Authorization");
                    continue block3;
                }
                default: {
                    return;
                }
            }
        }
        throw new HttpException("Maximum redirects encountered, bailing");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ((MultiThreadedHttpConnectionManager)MANAGER).setIdleConnectionTime(30000L);
    }
}

