/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnType;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.GGEP;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class HUGEExtension {
    private GGEP _ggep = null;
    private Set _urns = null;
    private Set _urnTypes = null;
    private Set _miscBlocks = null;

    public GGEP getGGEP() {
        return this._ggep;
    }

    public Set getURNS() {
        if (this._urns == null) {
            return Collections.EMPTY_SET;
        }
        return this._urns;
    }

    public Set getURNTypes() {
        if (this._urnTypes == null) {
            return Collections.EMPTY_SET;
        }
        return this._urnTypes;
    }

    public Set getMiscBlocks() {
        if (this._miscBlocks == null) {
            return Collections.EMPTY_SET;
        }
        return this._miscBlocks;
    }

    public HUGEExtension(byte[] extsBytes) {
        int currIndex = 0;
        while (currIndex < extsBytes.length && extsBytes[currIndex] != 0) {
            int delimIndex;
            if (extsBytes[currIndex] == -61) {
                int[] endIndex = new int[]{currIndex + 1};
                try {
                    GGEP ggep = new GGEP(extsBytes, currIndex, endIndex);
                    if (this._ggep == null) {
                        this._ggep = ggep;
                    } else {
                        this._ggep.merge(ggep);
                    }
                }
                catch (BadGGEPBlockException ignored) {
                    // empty catch block
                }
                currIndex = endIndex[0];
                continue;
            }
            for (delimIndex = currIndex; delimIndex < extsBytes.length && extsBytes[delimIndex] != 28; ++delimIndex) {
            }
            if (delimIndex <= extsBytes.length) {
                try {
                    String curExtStr = new String(extsBytes, currIndex, delimIndex - currIndex, "UTF-8");
                    if (URN.isUrn(curExtStr)) {
                        URN urn = URN.createSHA1Urn(curExtStr);
                        if (this._urns == null) {
                            this._urns = new HashSet(1);
                        }
                        this._urns.add(urn);
                    } else if (UrnType.isSupportedUrnType(curExtStr)) {
                        if (UrnType.isSupportedUrnType(curExtStr)) {
                            if (this._urnTypes == null) {
                                this._urnTypes = new HashSet(1);
                            }
                            this._urnTypes.add(UrnType.createUrnType(curExtStr));
                        }
                    } else {
                        if (this._miscBlocks == null) {
                            this._miscBlocks = new HashSet(1);
                        }
                        this._miscBlocks.add(curExtStr);
                    }
                }
                catch (IOException bad) {
                    // empty catch block
                }
            }
            currIndex = delimIndex + 1;
        }
    }
}

