/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import java.io.IOException;
import java.io.OutputStream;

public final class ReplyNumberVendorMessage
extends VendorMessage {
    public static final int VERSION = 2;
    private static final byte UNSOLICITED = 1;

    ReplyNumberVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 12, version, payload);
        if (this.getPayload().length < 1) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
        if (this.getVersion() == 1 && this.getPayload().length != 1) {
            throw new BadPacketException("VERSION 1 UNSUPPORTED PAYLOAD LEN: " + this.getPayload().length);
        }
        if (this.getVersion() == 2 && this.getPayload().length != 2) {
            throw new BadPacketException("VERSION 2 UNSUPPORTED PAYLOAD LEN: " + this.getPayload().length);
        }
    }

    public ReplyNumberVendorMessage(GUID replyGUID, int numResults) {
        super(F_LIME_VENDOR_ID, 12, 2, ReplyNumberVendorMessage.derivePayload(numResults));
        this.setGUID(replyGUID);
    }

    public int getNumResults() {
        return ByteOrder.ubyte2int(this.getPayload()[0]);
    }

    public boolean canReceiveUnsolicited() {
        if (this.getVersion() == 1) {
            return true;
        }
        return (this.getPayload()[1] & 1) == 1;
    }

    private static byte[] derivePayload(int numResults) {
        if (numResults < 1 || numResults > 255) {
            throw new IllegalArgumentException("Number of results too big: " + numResults);
        }
        byte[] payload = new byte[2];
        byte[] bytes = new byte[2];
        ByteOrder.short2leb((short)numResults, bytes, 0);
        payload[0] = bytes[0];
        payload[1] = RouterService.canReceiveUnsolicited() ? (byte)1 : 0;
        return payload;
    }

    public boolean equals(Object other) {
        if (other instanceof ReplyNumberVendorMessage) {
            GUID myGuid = new GUID(this.getGUID());
            GUID otherGuid = new GUID(((VendorMessage)other).getGUID());
            int otherResults = ((ReplyNumberVendorMessage)other).getNumResults();
            return myGuid.equals(otherGuid) && this.getNumResults() == otherResults && super.equals(other);
        }
        return false;
    }

    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
        SentMessageStatHandler.UDP_REPLY_NUMBER.addMessage(this);
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

