/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;

public class SynMessage
extends UDPConnectionMessage {
    private byte _senderConnectionID;
    private int _protocolVersionNumber;

    public SynMessage(byte connectionID) {
        super((byte)0, (byte)0, 0L, SynMessage.buildByteArray(connectionID, 0), 3);
        this._senderConnectionID = connectionID;
        this._protocolVersionNumber = 0;
    }

    public SynMessage(byte connectionID, byte theirConnectionID) {
        super(theirConnectionID, (byte)0, 0L, SynMessage.buildByteArray(connectionID, 0), 3);
        this._senderConnectionID = connectionID;
        this._protocolVersionNumber = 0;
    }

    public SynMessage(byte[] guid, byte ttl, byte hops, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, payload);
        this._senderConnectionID = guid[4];
        this._protocolVersionNumber = SynMessage.getShortInt(guid[5], guid[6]);
    }

    public byte getSenderConnectionID() {
        return this._senderConnectionID;
    }

    public int getProtocolVersionNumber() {
        return this._protocolVersionNumber;
    }

    public String toString() {
        return "SynMessage DestID:" + this.getConnectionID() + " SrcID:" + this._senderConnectionID + " vNo:" + this._protocolVersionNumber;
    }
}

