/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.Chunk;
import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPBufferedInputStream
extends InputStream {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$udpconnect$UDPBufferedInputStream == null ? (class$com$limegroup$gnutella$udpconnect$UDPBufferedInputStream = UDPBufferedInputStream.class$("com.limegroup.gnutella.udpconnect.UDPBufferedInputStream")) : class$com$limegroup$gnutella$udpconnect$UDPBufferedInputStream);
    private static final int FOREVER = 36000000;
    protected Chunk _activeChunk;
    private UDPConnectionProcessor _processor;
    static /* synthetic */ Class class$com$limegroup$gnutella$udpconnect$UDPBufferedInputStream;

    public UDPBufferedInputStream(UDPConnectionProcessor p) {
        this._processor = p;
        this._activeChunk = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        boolean timedOut = false;
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            while (true) {
                this.checkForData();
                if (this._activeChunk != null && this._activeChunk.length > 0) {
                    --this._activeChunk.length;
                    return this._activeChunk.data[this._activeChunk.start++] & 0xFF;
                }
                if (this._activeChunk != null || !this._processor.isConnected()) break;
                if (timedOut) {
                    InterruptedIOException e = new InterruptedIOException();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("read() timed out for timeout " + this._processor.getReadTimeout(), e);
                    }
                    throw e;
                }
                this.waitOnData();
                timedOut = true;
            }
            return -1;
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        int origLen = len;
        int origOff = off;
        boolean timedOut = false;
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            while (true) {
                this.checkForData();
                if (this._activeChunk != null && this._activeChunk.length > 0) {
                    timedOut = false;
                    int wlength = Math.min(this._activeChunk.length, len);
                    System.arraycopy(this._activeChunk.data, this._activeChunk.start, b, off, wlength);
                    off += wlength;
                    this._activeChunk.start += wlength;
                    this._activeChunk.length -= wlength;
                    if ((len -= wlength) > 0) continue;
                    return origLen;
                }
                if (origLen != len) {
                    return origLen - len;
                }
                if (this._activeChunk != null || !this._processor.isConnected()) break;
                if (timedOut) {
                    InterruptedIOException e = new InterruptedIOException();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("read(byte [], int, int) timed out for timeout " + this._processor.getReadTimeout(), e);
                    }
                    throw e;
                }
                this.waitOnData();
                timedOut = true;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) throws IOException {
        int len;
        int origLen = len = (int)n;
        boolean timedOut = false;
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            while (true) {
                this.checkForData();
                if (this._activeChunk != null && this._activeChunk.length > 0) {
                    timedOut = false;
                    int wlength = Math.min(this._activeChunk.length, len);
                    this._activeChunk.start += wlength;
                    this._activeChunk.length -= wlength;
                    if ((len -= wlength) > 0) continue;
                    return origLen;
                }
                if (origLen != len) {
                    return origLen - len;
                }
                if (this._activeChunk != null || !this._processor.isConnected()) break;
                if (timedOut) {
                    InterruptedIOException e = new InterruptedIOException();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("skip() timed out for timeout " + this._processor.getReadTimeout(), e);
                    }
                    throw e;
                }
                this.waitOnData();
                timedOut = true;
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            if (this._activeChunk == null) {
                return 0;
            }
            return this._activeChunk.length;
        }
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) {
    }

    public void reset() {
    }

    public void close() throws IOException {
        this._processor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForData() {
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            if (this._activeChunk == null || this._activeChunk.length <= 0) {
                this._activeChunk = this._processor.getIncomingChunk();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnData() throws InterruptedIOException {
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            try {
                this._processor.wait(this._processor.getReadTimeout());
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeup() {
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            this._processor.notify();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

