/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.SynMessage;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPMultiplexor {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$udpconnect$UDPMultiplexor == null ? (class$com$limegroup$gnutella$udpconnect$UDPMultiplexor = UDPMultiplexor.class$("com.limegroup.gnutella.udpconnect.UDPMultiplexor")) : class$com$limegroup$gnutella$udpconnect$UDPMultiplexor);
    private static UDPMultiplexor _instance = new UDPMultiplexor();
    public static final byte UNASSIGNED_SLOT = 0;
    private volatile WeakReference[] _connections = new WeakReference[256];
    private int _lastConnectionID = 0;
    static /* synthetic */ Class class$com$limegroup$gnutella$udpconnect$UDPMultiplexor;

    public static UDPMultiplexor instance() {
        return _instance;
    }

    private UDPMultiplexor() {
    }

    public boolean isConnectedTo(InetAddress host) {
        WeakReference[] array = this._connections;
        if (this._lastConnectionID == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            UDPConnectionProcessor con;
            WeakReference conRef = array[i];
            if (conRef == null || (con = (UDPConnectionProcessor)conRef.get()) == null || !host.equals(con.getInetAddress())) continue;
            return true;
        }
        return false;
    }

    public synchronized byte register(UDPConnectionProcessor con) {
        int i;
        WeakReference[] copy = new WeakReference[this._connections.length];
        for (i = 0; i < this._connections.length; ++i) {
            copy[i] = this._connections[i];
        }
        for (i = 1; i <= copy.length; ++i) {
            int connID = (this._lastConnectionID + i) % 256;
            if (connID == 0 || copy[connID] != null && copy[connID].get() != null) continue;
            this._lastConnectionID = connID;
            copy[connID] = new WeakReference<UDPConnectionProcessor>(con);
            this._connections = copy;
            return (byte)connID;
        }
        return 0;
    }

    public synchronized void unregister(UDPConnectionProcessor con) {
        int connID = con.getConnectionID() & 0xFF;
        WeakReference[] copy = new WeakReference[this._connections.length];
        for (int i = 0; i < this._connections.length; ++i) {
            copy[i] = this._connections[i];
        }
        if (copy[connID] != null && copy[connID].get() == con) {
            copy[connID].clear();
            copy[connID] = null;
        }
        this._connections = copy;
    }

    public void routeMessage(UDPConnectionMessage msg, InetAddress senderIP, int senderPort) {
        WeakReference[] array = this._connections;
        int connID = msg.getConnectionID() & 0xFF;
        if (connID == 0 && msg instanceof SynMessage) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Receiving SynMessage :" + msg);
            }
            for (int i = 1; i < array.length; ++i) {
                UDPConnectionProcessor con = array[i] == null ? null : (UDPConnectionProcessor)array[i].get();
                if (con == null || !con.isConnecting() || !con.matchAddress(senderIP, senderPort)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("routeMessage to conn:" + i + " Syn:" + msg);
                }
                con.handleMessage(msg);
                break;
            }
        } else {
            UDPConnectionProcessor con = array[connID] == null ? null : (UDPConnectionProcessor)array[connID].get();
            if (con != null && con.matchAddress(senderIP, senderPort)) {
                con.handleMessage(msg);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

