/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public final class BrowseHostUploadState
extends UploadState {
    private final ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
    private static final boolean debugOn = false;

    public BrowseHostUploadState(HTTPUploader uploader) {
        super(uploader);
    }

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        if (!this.UPLOADER.getClientAcceptsXGnutellaQueryreplies()) {
            String str = "HTTP/1.1 406 Not Acceptable\r\n\r\n";
            ostream.write(str.getBytes());
            ostream.flush();
            this.debug("BHUS.doUpload(): client does not accept QRs.");
            return;
        }
        QueryRequest indexingQuery = QueryRequest.createBrowseHostQuery();
        Response[] responses = RouterService.getFileManager().query(indexingQuery);
        if (responses == null) {
            responses = new Response[]{};
        }
        Iterator iterator = RouterService.getMessageRouter().responsesToQueryReplies(responses, indexingQuery);
        try {
            while (iterator.hasNext()) {
                QueryReply queryReply = (QueryReply)iterator.next();
                queryReply.write(this.BAOS);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        String str = "HTTP/1.1 200 OK\r\n";
        ostream.write(str.getBytes());
        str = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        ostream.write(str.getBytes());
        str = "Content-Type: application/x-gnutella-packets\r\n";
        ostream.write(str.getBytes());
        str = "Content-Length: " + this.BAOS.size() + "\r\n";
        ostream.write(str.getBytes());
        this.writeProxies(ostream);
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
        ostream.write(this.BAOS.toByteArray());
        this.UPLOADER.setAmountUploaded(this.BAOS.size());
        this.debug("BHUS.doUpload(): returning.");
    }

    public boolean getCloseConnection() {
        return false;
    }

    private final void debug(String out) {
    }

    private final void debug(Exception out) {
    }
}

