/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.FileComparator;
import com.limegroup.gnutella.util.StringComparator;
import com.limegroup.gnutella.util.StringUtils;
import java.io.Serializable;
import java.util.Comparator;

public final class Comparators {
    private static final Comparator INT_COMPARATOR = new IntComparator();
    private static final Comparator LONG_COMPARATOR = new LongComparator();
    private static final Comparator INVERSE_LONG_COMPARATOR = new InverseLongComparator();
    private static final Comparator STRING_COMPARATOR = new StringComparator();
    private static final Comparator FILE_COMPARATOR = new FileComparator();
    private static final Comparator CASE_INSENSITIVE_STRING_COMPARATOR = new CaseInsensitiveStringComparator();

    private Comparators() {
    }

    public static Comparator integerComparator() {
        return INT_COMPARATOR;
    }

    public static Comparator longComparator() {
        return LONG_COMPARATOR;
    }

    public static Comparator inverseLongComparator() {
        return INVERSE_LONG_COMPARATOR;
    }

    public static Comparator stringComparator() {
        return STRING_COMPARATOR;
    }

    public static Comparator fileComparator() {
        return FILE_COMPARATOR;
    }

    public static Comparator caseInsensitiveStringComparator() {
        return CASE_INSENSITIVE_STRING_COMPARATOR;
    }

    public static int intCompareTo(Integer thisInt, Integer anotherInt) {
        int anotherVal;
        int thisVal = thisInt;
        return thisVal < (anotherVal = anotherInt.intValue()) ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public static int longCompareTo(Long firstLong, Long secondLong) {
        long secondVal;
        long firstVal = firstLong;
        return firstVal < (secondVal = secondLong.longValue()) ? -1 : (firstVal == secondVal ? 0 : 1);
    }

    public static final class CaseInsensitiveStringComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 263123571237995212L;

        public int compare(Object o1, Object o2) {
            return StringUtils.compareIgnoreCase((String)o1, (String)o2);
        }
    }

    private static final class InverseLongComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 316426787496198051L;

        private InverseLongComparator() {
        }

        public int compare(Object o1, Object o2) {
            return -Comparators.longCompareTo((Long)o1, (Long)o2);
        }
    }

    private static final class LongComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 226428887996180051L;

        private LongComparator() {
        }

        public int compare(Object o1, Object o2) {
            return Comparators.longCompareTo((Long)o1, (Long)o2);
        }
    }

    private static final class IntComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 830281396810831681L;

        private IntComparator() {
        }

        public int compare(Object o1, Object o2) {
            return Comparators.intCompareTo((Integer)o1, (Integer)o2);
        }
    }
}

