/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.settings.URLHandlerSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.PackagedMediaFileUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.WindowsLauncher;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public final class Launcher {
    private static boolean _macClassesLoadedSuccessfully = true;
    private static Method _openURL;
    static /* synthetic */ Class class$java$lang$String;

    private Launcher() {
    }

    public static int openURL(String url) throws IOException {
        if (CommonUtils.isWindows()) {
            return Launcher.openURLWindows(url);
        }
        if (CommonUtils.isMacOSX()) {
            Launcher.openURLMac(url);
        } else {
            Launcher.launchFileOther(url);
        }
        return -1;
    }

    private static int openURLWindows(String url) throws IOException {
        return new WindowsLauncher().openURL(url);
    }

    private static void openURLMac(String url) throws IOException {
        if (!_macClassesLoadedSuccessfully) {
            throw new IOException();
        }
        try {
            Object[] params = new Object[]{url};
            _openURL.invoke(null, params);
        }
        catch (NoSuchMethodError err) {
            throw new IOException();
        }
        catch (NoClassDefFoundError err) {
            throw new IOException();
        }
        catch (IllegalAccessException iae) {
            throw new IOException();
        }
        catch (InvocationTargetException ite) {
            throw new IOException();
        }
    }

    public static int launchFile(File file) throws IOException, SecurityException {
        String path = file.getCanonicalPath();
        String extCheckString = path.toLowerCase();
        if (extCheckString.endsWith(".pmf")) {
            if ((file = PackagedMediaFileUtils.preparePMFFile(file.toString())) == null) {
                return -1;
            }
            path = file.getCanonicalPath();
            extCheckString = path.toLowerCase();
        }
        if (!(extCheckString.endsWith(".exe") || extCheckString.endsWith(".vbs") || extCheckString.endsWith(".lnk") || extCheckString.endsWith(".bat") || extCheckString.endsWith(".sys") || extCheckString.endsWith(".com"))) {
            if (CommonUtils.isWindows()) {
                return Launcher.launchFileWindows(path);
            }
            if (CommonUtils.isMacOSX()) {
                Launcher.launchFileMacOSX(path);
            } else {
                Launcher.launchFileOther(path);
            }
        } else {
            throw new SecurityException();
        }
        return -1;
    }

    private static int launchFileWindows(String path) throws IOException {
        return new WindowsLauncher().launchFile(path);
    }

    private static void launchFileMacOSX(String file) throws IOException {
        Runtime.getRuntime().exec(new String[]{"open", file});
    }

    private static void loadMacClasses() throws IOException {
        try {
            Class<?> mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
            String openURLName = "openURL";
            Class[] openURLParams = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Launcher.class$("java.lang.String")) : class$java$lang$String};
            _openURL = mrjFileUtilsClass.getDeclaredMethod(openURLName, openURLParams);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException();
        }
        catch (NoSuchMethodException nsme) {
            throw new IOException();
        }
        catch (SecurityException se) {
            throw new IOException();
        }
    }

    private static void launchFileOther(String path) throws IOException {
        String handler = MediaType.getAudioMediaType().matches(path) ? URLHandlerSettings.AUDIO_PLAYER.getValue() : (MediaType.getVideoMediaType().matches(path) ? URLHandlerSettings.VIDEO_PLAYER.getValue() : (MediaType.getImageMediaType().matches(path) ? URLHandlerSettings.IMAGE_VIEWER.getValue() : URLHandlerSettings.BROWSER.getValue()));
        if (handler.indexOf("$URL$") != -1) {
            System.out.println("starting " + handler);
            StringTokenizer tok = new StringTokenizer(handler);
            String[] strs = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                strs[i] = StringUtils.replace(tok.nextToken(), "$URL$", path);
                System.out.print(" " + strs[i]);
                ++i;
            }
            try {
                Runtime.getRuntime().exec(strs);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("starting " + handler);
            String[] strs = new String[]{handler, path};
            Runtime.getRuntime().exec(strs);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (CommonUtils.isMacOSX()) {
            try {
                Launcher.loadMacClasses();
            }
            catch (IOException ioe) {
                _macClassesLoadedSuccessfully = false;
            }
        }
    }
}

