/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.util.Random;

public final class UUID {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final byte INDEX_TYPE = 6;
    private static final byte INDEX_VARIATION = 8;
    private static final byte TYPE_RANDOM_BASED = 4;
    private static final Random RANDOM = new Random();
    private final String uuid;

    private UUID(byte[] bytes) {
        this.uuid = UUID.genString(bytes);
    }

    public UUID(String uuid) {
        this.uuid = uuid.toLowerCase();
        if (uuid.length() != 36) {
            throw new IllegalArgumentException();
        }
    }

    public static UUID nextUUID() {
        byte[] bytes = new byte[16];
        RANDOM.nextBytes(bytes);
        bytes[6] = (byte)(bytes[6] & 0xF);
        bytes[6] = (byte)(bytes[6] | 0x40);
        bytes[8] = (byte)(bytes[8] & 0x3F);
        bytes[8] = (byte)(bytes[8] | 0xFFFFFF80);
        return new UUID(bytes);
    }

    private static String genString(byte[] info) {
        StringBuffer sb = new StringBuffer(32);
        for (int i = 0; i < 16; ++i) {
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                sb.append('-');
            }
            int hex = info[i] & 0xFF;
            sb.append(HEX[hex >> 4]);
            sb.append(HEX[hex & 0xF]);
        }
        return sb.toString();
    }

    public String toString() {
        return this.uuid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UUID) {
            UUID other = (UUID)o;
            return this.uuid.equals(other.uuid);
        }
        return false;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

