#!/bin/sh
#
# Runs LimeWire.  This script must be executed in your LimeWire
# install directory.
#
# We must set the J2SE_PREEMPTCLOSE environment variable to 1 to
# work around some limitations in the JDK1.3.  For more information
# see http://java.sun.com/j2se/1.3/relnotes.html#vm
#
J2SE_PREEMPTCLOSE=1
export J2SE_PREEMPTCLOSE

java -version 2> /dev/null
if [ $? -ne 0 ]; then
    echo
    echo "******************************************************************"
    echo "Error: Unable to find java."
    echo "Please make sure that java is in your PATH."
    echo "Visit http://www.java.com/en/download/manual.jsp for more information."
    echo "(LimeWire is tested against and works best with with Sun's JRE, Java 1.4+)"
    exit 1
fi

java -Dorg.apache.commons.logging.Log=org.apache.commons.logging.impl.NoOpLog -jar LimeWire.jar
if [ $? -ne 0 ]; then
    echo 
    echo "******************************************************************"
    echo "Something went wrong with LimeWire."
    echo "Maybe you're using the wrong version of Java?"
    echo "(LimeWire is tested against and works best with with Sun's JRE, Java 1.4+)"
fi    
