/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.marshaller;

import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAX2DOMEx
implements ContentHandler {
    private Node _node = null;
    private final Stack _nodeStk = new Stack();
    private final Document _document;

    public SAX2DOMEx(Node node) {
        this._node = node;
        this._nodeStk.push(this._node);
        this._document = node instanceof Document ? (Document)node : node.getOwnerDocument();
    }

    public SAX2DOMEx() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        this._document = factory.newDocumentBuilder().newDocument();
        this._node = this._document;
        this._nodeStk.push(this._document);
    }

    public Node getDOM() {
        return this._node;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String namespace, String localName, String qName, Attributes attrs) {
        Node parent = (Node)this._nodeStk.peek();
        Element element = this._document.createElementNS(namespace, qName);
        int length = attrs.getLength();
        int i = 0;
        while (i < length) {
            String namespaceuri = attrs.getURI(i);
            String value = attrs.getValue(i);
            String qname = attrs.getQName(i);
            if (namespaceuri == null || namespaceuri.equals("")) {
                element.setAttribute(qname, value);
            } else {
                element.setAttributeNS(namespaceuri, qname, value);
            }
            ++i;
        }
        parent.appendChild(element);
        this._nodeStk.push(element);
    }

    public void endElement(String namespace, String localName, String qName) {
        this._nodeStk.pop();
    }

    public void characters(char[] ch, int start, int length) {
        Node parent = (Node)this._nodeStk.peek();
        Text text = this._document.createTextNode(new String(ch, start, length));
        parent.appendChild(text);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        Node parent = (Node)this._nodeStk.peek();
        ProcessingInstruction node = this._document.createProcessingInstruction(target, data);
        parent.appendChild(node);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) {
    }

    public void startPrefixMapping(String prefix, String uri) {
        String qname;
        Element element;
        String value;
        Node currentNode = (Node)this._nodeStk.peek();
        if (null != currentNode && currentNode.getNodeType() == 1 && (value = (element = (Element)currentNode).getAttribute(qname = null != prefix && "".equals(prefix) || null == prefix ? "xmlns" : "xmlns:" + prefix)) == null) {
            element.setAttributeNS("http://www.w3.org/XML/1998/namespace", qname, uri);
        }
    }

    public void endPrefixMapping(String prefix) {
    }
}

