/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.unmarshaller;

import com.sun.xml.bind.TypeRegistry;
import com.sun.xml.bind.unmarshaller.ContentHandlerEx;
import com.sun.xml.bind.unmarshaller.Messages;
import com.sun.xml.bind.unmarshaller.SAXUnmarshallerHandler;
import com.sun.xml.bind.unmarshaller.Tracer;
import com.sun.xml.bind.unmarshaller.UnmarshallableObject;
import com.sun.xml.bind.unmarshaller.UnmarshallerImpl;
import com.sun.xml.bind.unmarshaller.UnmarshallingContext;
import com.sun.xml.bind.unmarshaller.UnreportedException;
import com.sun.xml.bind.util.AttributesImpl;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.ValidationEvent;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXUnmarshallerHandlerImpl
implements SAXUnmarshallerHandler,
UnmarshallingContext {
    private final TypeRegistry typeRegistry;
    private UnmarshallableObject result;
    private ContentHandlerEx[] handlers = new ContentHandlerEx[16];
    private int[] mementos = new int[16];
    private int handlerLen = 0;
    private StringBuffer buffer = new StringBuffer();
    private String[] nsBind = new String[16];
    private int nsLen = 0;
    private final Stack attStack = new Stack();
    private Runnable[] patchers = null;
    private int patchersLen = 0;
    private Hashtable idmap = null;
    private Locator locator;
    private final UnmarshallerImpl parent;
    private boolean aborted = false;
    private Tracer tracer;

    public SAXUnmarshallerHandlerImpl(UnmarshallerImpl _parent, TypeRegistry _reg) {
        this.parent = _parent;
        this.typeRegistry = _reg;
        this.startPrefixMapping("", "");
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public void startDocument() throws SAXException {
        this.result = null;
        this.handlerLen = 0;
        this.patchers = null;
        this.patchersLen = 0;
        this.aborted = false;
        this.attStack.clear();
    }

    public void endDocument() throws SAXException {
        this.runPatchers();
    }

    public void startElement(String uri, String local, String qName, Attributes atts) throws SAXException {
        try {
            if (this.result == null) {
                this.result = this.typeRegistry.createRootElement(uri, local);
                if (this.result == null) {
                    throw new SAXParseException(Messages.format("SAXUnmarshallerHandlerImpl.UnexpectedRootElement", qName), this.getLocator());
                }
                ContentHandlerEx unmarshaller = this.result.getUnmarshaller(this);
                this.pushContentHandler(unmarshaller, 0);
            }
            this.processText(true);
            this.getCurrentHandler().enterElement(uri, local, atts);
        }
        catch (UnreportedException e) {
            this.reportAndThrow(e);
        }
    }

    public final void endElement(String uri, String local, String qname) throws SAXException {
        try {
            this.processText(false);
            this.getCurrentHandler().leaveElement(uri, local);
        }
        catch (UnreportedException e) {
            this.reportAndThrow(e);
        }
    }

    public Object getResult() throws UnmarshalException {
        if (!this.aborted) {
            return this.result;
        }
        throw new UnmarshalException((String)null);
    }

    public void pushContentHandler(ContentHandlerEx handler, int memento) {
        if (this.handlerLen == this.handlers.length) {
            ContentHandlerEx[] h = new ContentHandlerEx[this.handlerLen * 2];
            int[] m = new int[this.handlerLen * 2];
            System.arraycopy(this.handlers, 0, h, 0, this.handlerLen);
            System.arraycopy(this.mementos, 0, m, 0, this.handlerLen);
            this.handlers = h;
            this.mementos = m;
        }
        this.handlers[this.handlerLen] = handler;
        this.mementos[this.handlerLen] = memento;
        ++this.handlerLen;
    }

    public void popContentHandler() throws UnreportedException {
        --this.handlerLen;
        this.handlers[this.handlerLen] = null;
        this.getCurrentHandler().leaveChild(this.mementos[this.handlerLen]);
    }

    public ContentHandlerEx getCurrentHandler() {
        return this.handlers[this.handlerLen - 1];
    }

    protected void consumeText(String str, boolean ignorable) throws UnreportedException {
        if (this.getCurrentHandler().isListState()) {
            StringTokenizer tokens = new StringTokenizer(str);
            while (tokens.hasMoreTokens()) {
                this.getCurrentHandler().text(tokens.nextToken());
            }
        } else {
            if (ignorable && str.trim().length() == 0) {
                return;
            }
            this.getCurrentHandler().text(str);
        }
    }

    private void processText(boolean ignorable) throws UnreportedException {
        this.consumeText(this.buffer.toString(), ignorable);
        if (this.buffer.length() < 1024) {
            this.buffer.setLength(0);
        } else {
            this.buffer = new StringBuffer();
        }
    }

    public final void characters(char[] buf, int start, int len) {
        this.buffer.append(buf, start, len);
    }

    public final void ignorableWhitespace(char[] buf, int start, int len) {
        this.characters(buf, start, len);
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (this.nsBind.length == this.nsLen) {
            String[] n = new String[this.nsLen * 2];
            System.arraycopy(this.nsBind, 0, n, 0, this.nsLen);
            this.nsBind = n;
        }
        this.nsBind[this.nsLen++] = prefix;
        this.nsBind[this.nsLen++] = uri;
    }

    public void endPrefixMapping(String prefix) {
        this.nsLen -= 2;
    }

    public String resolveNamespacePrefix(String prefix) {
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        int i = this.nsLen - 2;
        while (i >= 0) {
            if (prefix.equals(this.nsBind[i])) {
                return this.nsBind[i + 1];
            }
            i -= 2;
        }
        return null;
    }

    public void pushAttributes(Attributes atts) {
        String v;
        AttributesImpl a = new AttributesImpl(atts);
        int idx = a.getIndex("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (idx != -1 && ((v = a.getValue(idx).trim()).equals("false") || v.equals("0"))) {
            a.removeAttribute(idx);
        }
        this.attStack.push(a);
    }

    public void popAttributes() {
        this.attStack.pop();
    }

    public Attributes getUnconsumedAttributes() {
        return (Attributes)this.attStack.peek();
    }

    public int getAttribute(String uri, String local) {
        if (this.attStack.isEmpty()) {
            return -1;
        }
        Attributes a = (Attributes)this.attStack.peek();
        return a.getIndex(uri, local);
    }

    public void consumeAttribute(int idx) throws UnreportedException {
        AttributesImpl a = (AttributesImpl)this.attStack.peek();
        String uri = a.getURI(idx);
        String local = a.getLocalName(idx);
        String value = a.getValue(idx);
        a.removeAttribute(idx);
        this.getCurrentHandler().enterAttribute(uri, local);
        this.consumeText(value, false);
        this.getCurrentHandler().leaveAttribute(uri, local);
    }

    public void addPatcher(Runnable job) {
        if (this.patchers == null) {
            this.patchers = new Runnable[32];
        }
        if (this.patchers.length == this.patchersLen) {
            Runnable[] buf = new Runnable[this.patchersLen * 2];
            System.arraycopy(this.patchers, 0, buf, 0, this.patchersLen);
            this.patchers = buf;
        }
        this.patchers[this.patchersLen++] = job;
    }

    private void runPatchers() {
        if (this.patchers != null) {
            int i = 0;
            while (i < this.patchersLen) {
                this.patchers[i].run();
                ++i;
            }
        }
    }

    public String addToIdTable(String id) {
        if (this.idmap == null) {
            this.idmap = new Hashtable();
        }
        this.idmap.put(id, this.getCurrentHandler().owner());
        return id;
    }

    public UnmarshallableObject getObjectFromId(String id) {
        if (this.idmap == null) {
            return null;
        }
        return (UnmarshallableObject)this.idmap.get(id);
    }

    public void skippedEntity(String name) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void setDocumentLocator(Locator loc) {
        this.locator = loc;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public boolean handleEvent(ValidationEvent event) {
        try {
            boolean recover = this.parent.getEventHandler().handleEvent(event);
            if (!recover) {
                this.aborted = true;
            }
            return recover;
        }
        catch (JAXBException e) {
            return false;
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    public void reportAndThrow(UnreportedException e) throws SAXException {
        this.handleEvent(e.createValidationEvent());
        throw new SAXException((Exception)e.createUnmarshalException());
    }

    public String getBaseUri() {
        return null;
    }

    public boolean isUnparsedEntity(String s) {
        return true;
    }

    public boolean isNotation(String s) {
        return true;
    }

    public void setTracer(Tracer t) {
        this.tracer = t;
    }

    public Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = new Tracer.Standard();
        }
        return this.tracer;
    }
}

