/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.validator;

import com.sun.xml.bind.serializer.NamespaceContextImpl;
import com.sun.xml.bind.serializer.XMLSerializable;
import com.sun.xml.bind.validator.AbortValidationException;
import com.sun.xml.bind.validator.MSVValidator;
import com.sun.xml.bind.validator.Messages;
import com.sun.xml.bind.validator.ValidatableObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.NotIdentifiableEventImpl;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.xml.sax.SAXException;

class ValidationContext {
    private final HashSet validatedObjects = new HashSet();
    private final NamespaceContextImpl nsContext = new NamespaceContextImpl();
    private final boolean validateID;
    private final HashSet IDs = new HashSet();
    private final HashMap IDREFs = new HashMap();
    private final ValidationEventHandler eventHandler;

    ValidationContext(ValidationEventHandler _eventHandler, boolean validateID) {
        this.eventHandler = _eventHandler;
        this.validateID = validateID;
    }

    public void validate(ValidatableObject vo) throws SAXException, AbortValidationException {
        if (this.validatedObjects.add(vo)) {
            MSVValidator.validate(this, vo);
        } else {
            this.reportEvent(vo, Messages.format("ValidationContext.CycleDetected"));
        }
    }

    public NamespaceContextImpl getNamespaceContext() {
        return this.nsContext;
    }

    public String onID(XMLSerializable owner, String value) throws SAXException {
        if (!this.validateID) {
            return value;
        }
        if (!this.IDs.add(value)) {
            this.reportEvent((ValidatableObject)owner, Messages.format("ValidationContext.DuplicateId", value));
        }
        return value;
    }

    public String onIDREF(XMLSerializable referer, String value) throws SAXException {
        if (!this.validateID) {
            return value;
        }
        if (this.IDs.contains(value)) {
            return value;
        }
        this.IDREFs.put(value, referer);
        return value;
    }

    protected void reconcileIDs() throws SAXException {
        if (!this.validateID) {
            return;
        }
        Iterator itr = this.IDREFs.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            if (this.IDs.contains(e.getKey())) continue;
            ValidatableObject source = (ValidatableObject)e.getValue();
            this.reportEvent(source, (ValidationEvent)new NotIdentifiableEventImpl(1, Messages.format("ValidationContext.IdNotFound", e.getKey()), (ValidationEventLocator)new ValidationEventLocatorImpl((Object)source)));
        }
        this.IDREFs.clear();
    }

    public void reportEvent(ValidatableObject source, String formattedMessage) throws AbortValidationException {
        this.reportEvent(source, (ValidationEvent)new ValidationEventImpl(1, formattedMessage, (ValidationEventLocator)new ValidationEventLocatorImpl((Object)source)));
    }

    public void reportEvent(ValidatableObject source, Exception nestedException) throws AbortValidationException {
        this.reportEvent(source, (ValidationEvent)new ValidationEventImpl(1, nestedException.toString(), (ValidationEventLocator)new ValidationEventLocatorImpl((Object)source), (Throwable)nestedException));
    }

    public void reportEvent(ValidatableObject source, ValidationEvent event) throws AbortValidationException {
        boolean r;
        try {
            r = this.eventHandler.handleEvent(event);
        }
        catch (RuntimeException re) {
            r = false;
        }
        if (!r) {
            throw new AbortValidationException(event.getMessage());
        }
    }
}

