/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.LinkedList;
import phex.common.ThreadTracking;
import phex.utils.Logger;

public class ThreadPool {
    private static ThreadPool instance;
    private long suicideTime = 20000L;
    private long spawnTime = 500L;
    private LinkedList jobs = null;
    private int activeThreads = 0;
    private boolean askedToStop = false;

    public static ThreadPool getInstance() {
        if (instance == null) {
            instance = new ThreadPool();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.askedToStop = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Runnable runnable, String string) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.jobs == null) {
                this.jobs = new LinkedList();
                Worker worker = new Worker();
                worker.setDaemon(false);
                worker.start();
                JobMonitor jobMonitor = new JobMonitor();
                jobMonitor.setDaemon(true);
                jobMonitor.start();
            }
            this.jobs.addLast(new Job(runnable, string));
            this.notifyAll();
        }
    }

    public static void trackThreadHandling() {
        Logger.logMessage(Logger.FINEST, (short)255, "Active Threads in pool: " + ThreadPool.instance.activeThreads);
    }

    private class Worker
    extends Thread {
        Worker() {
            super(ThreadTracking.threadPoolGroup, "ThreadPool.Worker");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Job job = null;
            ThreadPool.this.activeThreads++;
            while (true) {
                ThreadPool threadPool = ThreadPool.this;
                synchronized (threadPool) {
                    long l = System.currentTimeMillis();
                    while (ThreadPool.this.jobs.isEmpty()) {
                        long l2 = System.currentTimeMillis() - l;
                        long l3 = ThreadPool.this.suicideTime - l2;
                        if (l3 < 0L) {
                            ThreadPool.this.activeThreads--;
                            return;
                        }
                        try {
                            ThreadPool.this.wait(l3);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (ThreadPool.this.askedToStop) {
                        ThreadPool.this.activeThreads--;
                        return;
                    }
                    job = (Job)ThreadPool.this.jobs.removeFirst();
                }
                try {
                    this.setName(job.getJobName());
                    job.getRunnable().run();
                }
                catch (Throwable throwable) {
                    Logger.logError(throwable);
                }
                this.setName("ThreadPool.Worker-" + Integer.toHexString(this.hashCode()));
            }
        }
    }

    private class JobMonitor
    extends Thread {
        JobMonitor() {
            super(ThreadTracking.threadPoolGroup, "JobMonitor");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                ThreadPool threadPool = ThreadPool.this;
                synchronized (threadPool) {
                    if (!ThreadPool.this.jobs.isEmpty()) {
                        Job job = (Job)ThreadPool.this.jobs.getFirst();
                        long l = System.currentTimeMillis();
                        long l2 = l - job.getRequestTime();
                        if (l2 > ThreadPool.this.spawnTime) {
                            Worker worker = new Worker();
                            worker.setDaemon(false);
                            worker.start();
                        }
                    }
                    try {
                        ThreadPool.this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class Job {
        private final Runnable runnable;
        private final String jobName;
        private final long requestTime;

        public Job(Runnable runnable, String string) {
            this.runnable = runnable;
            this.jobName = string;
            this.requestTime = System.currentTimeMillis();
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public String getJobName() {
            return this.jobName;
        }

        public long getRequestTime() {
            return this.requestTime;
        }
    }
}

