/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import phex.connection.FlowControlQueue;
import phex.host.Host;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.statistic.MessageCountStatistic;

public class MessageQueue {
    private static final int MAX_QUEUE_SIZE = 100;
    private static final int LONG_TIMEOUT = 10000;
    private static final int SHORT_TIMEOUT = 5000;
    private static final int PRIORITY_COUNT = 7;
    private static final int PRIORITY_URGENT = 0;
    private static final int PRIORITY_PUSH = 1;
    private static final int PRIORITY_QUERY_HIT = 2;
    private static final int PRIORITY_QUERY = 3;
    private static final int PRIORITY_PONG = 4;
    private static final int PRIORITY_PING = 5;
    private static final int PRIORITY_OTHER = 6;
    private Host host;
    private FlowControlQueue[] flowControlQueue;
    private int dropCount = 0;
    private int queuedCount;
    private int lastPriorityAdded;

    public MessageQueue(Host host) {
        this.host = host;
        this.flowControlQueue = new FlowControlQueue[7];
        this.flowControlQueue[0] = new FlowControlQueue(1, Integer.MAX_VALUE, 100, true);
        this.flowControlQueue[1] = new FlowControlQueue(6, 10000, 100, true);
        this.flowControlQueue[2] = new FlowControlQueue(4, 10000, 100, true);
        this.flowControlQueue[3] = new FlowControlQueue(3, 5000, 100, true);
        this.flowControlQueue[4] = new FlowControlQueue(1, 5000, 100, true);
        this.flowControlQueue[5] = new FlowControlQueue(1, 5000, 100, true);
        this.flowControlQueue[6] = new FlowControlQueue(1, Integer.MAX_VALUE, 100, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Message message) {
        int n = this.calculatePriority(message);
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.flowControlQueue[n].addMessage(message);
            int n2 = this.flowControlQueue[n].getAndResetDropCount();
            this.dropCount += n2;
            MessageCountStatistic.dropedMsgOutCounter.increment(n2);
            this.queuedCount += 1 - n2;
            this.lastPriorityAdded = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueuedMessages() throws IOException {
        int n;
        boolean bl = false;
        int n2 = n = this.lastPriorityAdded;
        block3: do {
            FlowControlQueue flowControlQueue = this.flowControlQueue[n2];
            flowControlQueue.initNewMessageBurst();
            while (true) {
                Message message;
                MessageQueue messageQueue = this;
                synchronized (messageQueue) {
                    message = flowControlQueue.removeMessage();
                    int n3 = flowControlQueue.getAndResetDropCount();
                    this.dropCount += n3;
                    MessageCountStatistic.dropedMsgOutCounter.increment(n3);
                    this.queuedCount = message == null ? (this.queuedCount -= n3) : (this.queuedCount -= 1 + n3);
                    if (this.queuedCount == 0) {
                        bl = true;
                    }
                    if (message == null) {
                        continue block3;
                    }
                }
                this.host.sendMessage(message);
            }
        } while (!bl && (n2 = (n2 + 1) % 7) != n);
        this.host.flushOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueuedMessageCount() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return this.queuedCount;
        }
    }

    public int getDropCount() {
        return this.dropCount;
    }

    private int calculatePriority(Message message) {
        MsgHeader msgHeader = message.getHeader();
        byte by = msgHeader.getPayload();
        switch (by) {
            case 0: {
                if (msgHeader.getHopsTaken() == 0 && msgHeader.getTTL() <= 2) {
                    return 0;
                }
                return 5;
            }
            case 1: {
                if (msgHeader.getHopsTaken() == 0 && msgHeader.getTTL() <= 2) {
                    return 0;
                }
                return 4;
            }
            case 64: {
                return 1;
            }
            case -127: {
                return 2;
            }
            case -128: {
                return 3;
            }
        }
        return 6;
    }
}

