/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import phex.connection.ConnectionConstants;
import phex.connection.handshake.HandshakeHandler;
import phex.connection.handshake.HandshakeStatus;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaders;

public class UltrapeerHandshakeHandler
extends HandshakeHandler
implements ConnectionConstants {
    private HostManager hostMgr = HostManager.getInstance();
    private NetworkHostsContainer hostContainer = this.hostMgr.getNetworkHostsContainer();

    public UltrapeerHandshakeHandler(Host host) {
        super(host);
    }

    public HTTPHeaders createAcceptHandshakeHeaders() {
        HTTPHeaders hTTPHeaders = super.createAcceptHandshakeHeaders();
        hTTPHeaders.addHeader(new HTTPHeader("X-Ultrapeer", "true"));
        hTTPHeaders.addHeader(new HTTPHeader("X-Query-Routing", "0.1"));
        hTTPHeaders.addHeader(new HTTPHeader("X-Ultrapeer-Query-Routing", "0.1"));
        return hTTPHeaders;
    }

    public HandshakeStatus createHandshakeResponse(HandshakeStatus handshakeStatus, boolean bl) {
        HTTPHeaders hTTPHeaders = handshakeStatus.getResponseHeaders();
        HTTPHeader hTTPHeader = hTTPHeaders.getHeader("X-Ultrapeer");
        if (bl) {
            if (hTTPHeader == null && !this.hostContainer.hasPeerSlotsAvailable()) {
                return new HandshakeStatus(503, "I am busy.", this.createRejectHandshakeHeaders());
            }
            HTTPHeaders hTTPHeaders2 = HTTPHeaders.EMPTY_HTTPHEADERS;
            HTTPHeader hTTPHeader2 = hTTPHeaders.getHeader("X-Ultrapeer-Needed");
            if (hTTPHeader2 != null && !hTTPHeader2.booleanValue() && !this.isBearshare(hTTPHeaders) && this.hostMgr.isAbleToBecomeLeafNode()) {
                hTTPHeaders2 = new HTTPHeaders(false);
                hTTPHeaders2.addHeader(new HTTPHeader("X-Ultrapeer", "false"));
            }
            return new HandshakeStatus(200, "OK", hTTPHeaders2);
        }
        if (!this.isConnectionAccepted(hTTPHeader)) {
            return new HandshakeStatus(503, "I am busy.", this.createRejectHandshakeHeaders());
        }
        HTTPHeaders hTTPHeaders3 = this.createAcceptHandshakeHeaders();
        if (hTTPHeader != null && Boolean.valueOf(hTTPHeader.getValue()).booleanValue()) {
            boolean bl2 = this.hostContainer.hasUltrapeerSlotsAvailable();
            String string = bl2 ? "true" : "false";
            hTTPHeaders3.addHeader(new HTTPHeader("X-Ultrapeer-Needed", string));
        }
        return new HandshakeStatus(200, "OK", hTTPHeaders3);
    }

    private boolean isConnectionAccepted(HTTPHeader hTTPHeader) {
        if (hTTPHeader == null) {
            return this.hostContainer.hasPeerSlotsAvailable();
        }
        if (Boolean.valueOf(hTTPHeader.getValue()).booleanValue() && (this.hostContainer.hasUltrapeerSlotsAvailable() || this.hostContainer.hasLeafSlotForUltrapeerAvailable())) {
            return true;
        }
        return this.hostContainer.hasLeafSlotsAvailable();
    }

    private boolean isBearshare(HTTPHeaders hTTPHeaders) {
        HTTPHeader hTTPHeader = hTTPHeaders.getHeader("User-Agent");
        return hTTPHeader != null && hTTPHeader.getValue().startsWith("BearShare");
    }
}

