/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import phex.common.AlternateLocation;
import phex.common.AlternateLocationContainer;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.connection.ConnectionFailedException;
import phex.connection.NetworkManager;
import phex.connection.SocketProvider;
import phex.download.FileNotAvailableException;
import phex.download.HostBusyException;
import phex.download.IDownloadCandidate;
import phex.download.IDownloadFile;
import phex.download.IDownloadSegment;
import phex.download.RangeUnavailableException;
import phex.download.RemotelyQueuedException;
import phex.download.WrongHTTPHeaderException;
import phex.host.HostAddress;
import phex.host.UnusableHostException;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRangeSet;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.http.XQueueParameters;
import phex.utils.GnutellaInputStream;
import phex.utils.Logger;
import phex.utils.URLUtil;

public class DownloadEngine {
    private static final int BUFFER_LENGTH = 1024;
    private IDownloadCandidate candidate;
    private IDownloadSegment segment;
    private IDownloadFile downloadFile;
    private RandomAccessFile raFile;
    private Socket socket;
    private GnutellaInputStream inStream;
    private boolean isPersistentConnection;
    private boolean isAcceptingNextSegment;
    private long fileOffset;

    public DownloadEngine(IDownloadFile iDownloadFile, IDownloadCandidate iDownloadCandidate) {
        this.downloadFile = iDownloadFile;
        this.candidate = iDownloadCandidate;
    }

    public DownloadEngine(Socket socket, IDownloadFile iDownloadFile, IDownloadCandidate iDownloadCandidate) {
        this(iDownloadFile, iDownloadCandidate);
        this.socket = socket;
    }

    public void connect(int n) throws IOException {
        if (this.socket == null) {
            HostAddress hostAddress = this.candidate.getHostAddress();
            Logger.logMessage(Logger.FINE, (short)2, "DownloadEngine - Connecting to " + hostAddress.getHostName() + ":" + hostAddress.getPort());
            try {
                this.socket = SocketProvider.connect(hostAddress, n);
            }
            catch (SocketException socketException) {
                throw new ConnectionFailedException(socketException.getMessage());
            }
        }
        this.inStream = new GnutellaInputStream(this.socket.getInputStream(), ServiceManager.getInstance().getDownloadBandwidthController());
        Logger.logMessage(Logger.FINE, (short)2, "Download Engine connected successfully.");
    }

    public void exchangeHTTPHandshake(IDownloadSegment iDownloadSegment) throws IOException, UnusableHostException, HTTPMessageException {
        HTTPHeader[] hTTPHeaderArray;
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string;
        this.isAcceptingNextSegment = false;
        this.segment = iDownloadSegment;
        long l = this.segment.getTransferStartPosition();
        this.fileOffset = this.segment.getTransferredDataSize();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.socket.getOutputStream());
        URN uRN = this.candidate.getResourceURN();
        if (uRN != null) {
            string = URLUtil.buildName2ResourceURL(uRN);
        } else {
            object6 = String.valueOf(this.candidate.getFileIndex());
            object5 = this.candidate.getFileName();
            object4 = new StringBuffer(6 + ((String)object6).length() + ((String)object5).length());
            ((StringBuffer)object4).append("/get/");
            ((StringBuffer)object4).append((String)object6);
            ((StringBuffer)object4).append('/');
            ((StringBuffer)object4).append(URLEncoder.encode((String)object5));
            string = ((StringBuffer)object4).toString();
        }
        object6 = new HTTPRequest("GET", string, true);
        ((HTTPRequest)object6).addHeader(new HTTPHeader("Host", this.candidate.getHostAddress().getFullHostName()));
        ((HTTPRequest)object6).addHeader(new HTTPHeader("Listen-IP", NetworkManager.getInstance().getLocalAddress().getFullHostName()));
        ((HTTPRequest)object6).addHeader(new HTTPHeader("Range", "bytes=" + l + "-"));
        ((HTTPRequest)object6).addHeader(new HTTPHeader("X-Queue", "0.1"));
        ((HTTPRequest)object6).addHeader(new HTTPHeader("Connection", "Keep-Alive"));
        object5 = this.downloadFile.getFileURN();
        if (object5 != null) {
            object4 = new AlternateLocationContainer((URN)object5);
            ((AlternateLocationContainer)object4).addContainer(this.downloadFile.getAltLocContainer());
            if (ServiceManager.sCfg.arePartialFilesShared) {
                object3 = NetworkManager.getInstance().getLocalAddress();
                try {
                    object2 = new URL(URLUtil.buildFullName2ResourceURL((HostAddress)object3, (URN)object5));
                    object = new AlternateLocation((URL)object2, (URN)object5, System.currentTimeMillis());
                    ((AlternateLocationContainer)object4).addAlternateLocation((AlternateLocation)object);
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.logError(malformedURLException);
                }
            }
            object3 = ((AlternateLocationContainer)object4).getAltLocHTTPHeadersForAddress(this.candidate.getHostAddress());
            ((HTTPRequest)object6).addHeaders((HTTPHeader[])object3);
        }
        if (ServiceManager.sCfg.isChatEnabled) {
            object4 = NetworkManager.getInstance().getLocalAddress();
            ((HTTPRequest)object6).addHeader(new HTTPHeader("Chat", ((HostAddress)object4).getFullHostName()));
        }
        object4 = ((HTTPRequest)object6).buildHTTPRequestString();
        Logger.logMessage(Logger.FINE, (short)2, "HTTP Request: " + (String)object4);
        outputStreamWriter.write((String)object4);
        outputStreamWriter.flush();
        object3 = HTTPProcessor.parseHTTPResponse(this.inStream);
        Logger.logMessage(Logger.FINE, (short)2, "HTTP Response: " + ((HTTPResponse)object3).buildHTTPResponseString());
        object2 = ((HTTPResponse)object3).getHeader("Server");
        if (object2 != null) {
            this.candidate.setVendor(((HTTPHeader)object2).getValue());
        }
        if ((object2 = ((HTTPResponse)object3).getHeader("Content-Range")) != null && (long)(n = this.parseStartOffset(((HTTPHeader)object2).getValue())) != l) {
            throw new IOException("Invalid 'CONTENT-RANGE' start offset.");
        }
        object2 = ((HTTPResponse)object3).getHeader("X-Gnutella-Content-URN");
        if (object2 != null) {
            object = ((HTTPHeader)object2).getValue();
            if (object5 != null) {
                if (!URN.isValidURN((String)object)) {
                    throw new IOException("Invalid X-GNUTELLA-CONTENT-URN: " + (String)object);
                }
                hTTPHeaderArray = new URN((String)object);
                if (!((URN)object5).equals((URN)hTTPHeaderArray)) {
                    throw new IOException("Required URN and content URN do not match.");
                }
            }
        }
        if ((object2 = ((HTTPResponse)object3).getHeader("Chat")) != null) {
            this.candidate.setChatSupported(true);
        }
        this.isPersistentConnection = false;
        object2 = ((HTTPResponse)object3).getHeader("X-Available-Ranges");
        if (object2 != null) {
            object = HTTPRangeSet.parseHTTPRangeSet(((HTTPHeader)object2).getValue());
            this.candidate.setAvailableRangeSet((HTTPRangeSet)object);
        }
        object2 = ((HTTPResponse)object3).getHeader("X-Queue");
        object = null;
        if (object2 != null) {
            object = XQueueParameters.parseHTTPRangeSet(((HTTPHeader)object2).getValue());
        }
        hTTPHeaderArray = ((HTTPResponse)object3).getHeaders("Alt-Location");
        int n2 = 0;
        while (n2 < hTTPHeaderArray.length) {
            this.parseAlternateLocations(hTTPHeaderArray[n2].getValue());
            ++n2;
        }
        hTTPHeaderArray = ((HTTPResponse)object3).getHeaders("X-Gnutella-Alternate-Location");
        int n3 = 0;
        while (n3 < hTTPHeaderArray.length) {
            this.parseAlternateLocations(hTTPHeaderArray[n3].getValue());
            ++n3;
        }
        int n4 = ((HTTPResponse)object3).getStatusCode();
        if (n4 >= 200 && n4 < 300) {
            Logger.logMessage(Logger.FINE, (short)2, "HTTP Handshake successfull.");
            return;
        }
        if (n4 == 503) {
            if (object != null) {
                throw new RemotelyQueuedException((XQueueParameters)object);
            }
            throw new HostBusyException();
        }
        if (n4 == 403) {
            throw new UnusableHostException("Request Forbidden");
        }
        if (n4 == 408) {
            throw new HostBusyException();
        }
        if (n4 == 404 || n4 == 410) {
            throw new FileNotAvailableException();
        }
        if (n4 == 416) {
            throw new RangeUnavailableException();
        }
        throw new IOException("Unknown HTTP code: " + n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDownload(File file) throws IOException {
        Logger.logMessage(Logger.FINE, (short)2, "Download Engine starts download.");
        boolean bl = false;
        this.raFile = new RandomAccessFile(file, "rw");
        try {
            this.segment.downloadStartNotify();
            this.raFile.seek(this.fileOffset);
            byte[] byArray = new byte[1024];
            long l = this.segment.getTransferDataSize();
            long l2 = this.segment.getTransferredDataSize();
            while (l > l2) {
                long l3 = l - l2;
                int n = this.inStream.read(byArray, 0, (int)Math.min(1024L, l3));
                if (n == -1) break;
                this.raFile.write(byArray, 0, n);
                this.segment.setTransferredDataSize(l2 += (long)n);
                l = this.segment.getTransferDataSize();
            }
            bl = true;
            Object var12_8 = null;
            this.stopDownload();
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            this.stopDownload();
            throw throwable;
        }
    }

    public void stopDownload() {
        block9: {
            if (this.inStream != null) {
                this.inStream.close();
            }
            if (this.segment != null) {
                this.segment.downloadStopNotify();
            }
            if (this.raFile != null) {
                try {
                    this.raFile.getFD().sync();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.raFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.socket == null) break block9;
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isAcceptingNextSegment() {
        return this.isAcceptingNextSegment;
    }

    private void parseAlternateLocations(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string2 = stringTokenizer.nextToken().trim();
                AlternateLocation alternateLocation = AlternateLocation.parse(string2);
                if (alternateLocation == null) continue;
                this.downloadFile.addDownloadCandidate(alternateLocation);
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
    }

    private int parseStartOffset(String string) throws WrongHTTPHeaderException {
        try {
            string = string.toLowerCase();
            int n = string.indexOf("bytes") + 6;
            String string2 = string.substring(n).trim();
            if (string2.charAt(0) == '*') {
                return 0;
            }
            n = string2.indexOf(45);
            String string3 = string2.substring(0, n);
            int n2 = Integer.parseInt(string3);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            Logger.logWarning(numberFormatException);
            throw new WrongHTTPHeaderException("Number error while parsing content range: " + string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new WrongHTTPHeaderException("Error while parsing content range: " + string);
        }
    }
}

