/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.bind.JAXBException;
import phex.actions.view.ActionViewAbout;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.gui.actions.ExitPhexAction;
import phex.gui.actions.FWAction;
import phex.gui.actions.FWToggleAction;
import phex.gui.actions.FilteredPortsAction;
import phex.gui.actions.OpenURLAction;
import phex.gui.actions.RescanSharedFilesAction;
import phex.gui.actions.ViewOptionsAction;
import phex.gui.common.BaseFrame;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.DesktopIndicatorListener;
import phex.gui.common.FWLogoPanel;
import phex.gui.common.FWMenu;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.SkinLookAndFeelLoader;
import phex.gui.common.SplashWindow;
import phex.gui.common.StatusBar;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.MonitorTab;
import phex.gui.tabs.NetworkTab;
import phex.gui.tabs.SWDownloadTab;
import phex.gui.tabs.SearchTab;
import phex.gui.tabs.SecurityTab;
import phex.gui.tabs.ShareTab;
import phex.gui.tabs.StatisticsTab;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITab;

public class MainFrame
extends BaseFrame {
    public static final int NETWORK_TAB_ID = 1000;
    public static final int SEARCH_TAB_ID = 1001;
    public static final int MONITOR_TAB_ID = 1002;
    public static final int DOWNLOAD_TAB_ID = 1003;
    public static final int SHARE_TAB_ID = 1004;
    public static final int SECURITY_TAB_ID = 1005;
    public static final int STATISTICS_TAB_ID = 1006;
    public static final int LIBRARY_TAB_ID = 1007;
    public static final int NETWORK_TAB_INDEX = 0;
    public static final int SEARCH_TAB_INDEX = 1;
    public static final int MONITOR_TAB_INDEX = 2;
    public static final int DOWNLOAD_TAB_INDEX = 3;
    public static final int SHARE_TAB_INDEX = 4;
    public static final int SECURITY_TAB_INDEX = 5;
    public static final int STATISTICS_TAB_INDEX = 6;
    public static final int LIBRARY_TAB_INDEX = 7;
    private JTabbedPane tabbedPane;
    private JPanel logoPanel;
    private Timer refresher;
    private NetworkTab networkTab;
    private SearchTab searchTab;
    private MonitorTab monitorTab;
    private ShareTab shareTab;
    private SWDownloadTab swDownloadTab;
    private SecurityTab securityTab;
    private StatisticsTab statisticsTab;
    static /* synthetic */ Class class$phex$gui$common$MainFrame;

    public MainFrame(SplashWindow splashWindow, XJBGUISettings xJBGUISettings) {
        SkinLookAndFeelLoader.tryLoadingSkinLookAndFeel();
        this.setFonts();
        BaseFrame.setAllFramesLookAndFeel(ServiceManager.sCfg.mLFClassName);
        this.setupComponents(xJBGUISettings);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        DesktopIndicator desktopIndicator = GUIRegistry.getInstance().getDesktopIndicator();
        if (desktopIndicator != null) {
            desktopIndicator.addDesktopIndicatorListener(new DesktopIndicatorHandler());
        }
        this.pack();
        BaseFrame.centerAndSizeWindow(this, 7, 8);
        this.setTitle();
        splashWindow.dispose();
        this.setVisible(true);
        this.refresher = new Timer(1000, new RefreshHandler());
        this.refresher.start();
    }

    private void setupComponents(XJBGUISettings xJBGUISettings) {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setMinimumSize(new Dimension(50, 50));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Component component = MainFrame.this.tabbedPane.getSelectedComponent();
                if (component instanceof FWTab) {
                    ((FWTab)component).tabSelectedNotify();
                }
            }
        });
        this.networkTab = new NetworkTab(this);
        this.networkTab.initComponent(xJBGUISettings);
        XJBGUITab xJBGUITab = GUIUtils.getXJBGUITabById(xJBGUISettings, 1000);
        boolean bl = true;
        if (xJBGUITab != null) {
            bl = xJBGUITab.isVisible();
        }
        this.setTabVisible(this.networkTab, bl);
        this.searchTab = new SearchTab(this);
        this.searchTab.initComponent(xJBGUISettings);
        xJBGUITab = GUIUtils.getXJBGUITabById(xJBGUISettings, 1001);
        bl = true;
        if (xJBGUITab != null) {
            bl = xJBGUITab.isVisible();
        }
        this.setTabVisible(this.searchTab, bl);
        this.monitorTab = new MonitorTab(this);
        this.monitorTab.initComponent(xJBGUISettings);
        xJBGUITab = GUIUtils.getXJBGUITabById(xJBGUISettings, 1002);
        bl = true;
        if (xJBGUITab != null) {
            bl = xJBGUITab.isVisible();
        }
        this.setTabVisible(this.monitorTab, bl);
        this.swDownloadTab = new SWDownloadTab(this);
        this.swDownloadTab.initComponent(xJBGUISettings);
        xJBGUITab = GUIUtils.getXJBGUITabById(xJBGUISettings, 1003);
        bl = true;
        if (xJBGUITab != null) {
            bl = xJBGUITab.isVisible();
        }
        this.setTabVisible(this.swDownloadTab, bl);
        this.shareTab = new ShareTab(this);
        this.shareTab.initComponent(xJBGUISettings);
        xJBGUITab = GUIUtils.getXJBGUITabById(xJBGUISettings, 1004);
        bl = true;
        if (xJBGUITab != null) {
            bl = xJBGUITab.isVisible();
        }
        this.setTabVisible(this.shareTab, bl);
        this.securityTab = new SecurityTab();
        this.securityTab.initComponent(xJBGUISettings);
        xJBGUITab = GUIUtils.getXJBGUITabById(xJBGUISettings, 1005);
        bl = true;
        if (xJBGUITab != null) {
            bl = xJBGUITab.isVisible();
        }
        this.setTabVisible(this.securityTab, bl);
        this.statisticsTab = new StatisticsTab();
        this.statisticsTab.initComponent(xJBGUISettings);
        xJBGUITab = GUIUtils.getXJBGUITabById(xJBGUISettings, 1006);
        bl = true;
        if (xJBGUITab != null) {
            bl = xJBGUITab.isVisible();
        }
        this.setTabVisible(this.statisticsTab, bl);
        if (this.tabbedPane.getTabCount() == 0) {
            this.getContentPane().add("Center", this.getLogoPanel());
        } else {
            this.tabbedPane.setSelectedIndex(0);
            this.getContentPane().add("Center", this.tabbedPane);
        }
        JMenuBar jMenuBar = this.createMenuBar();
        this.setJMenuBar(jMenuBar);
        JToolBar jToolBar = this.createFWToolbar();
        if (jToolBar != null) {
            this.getContentPane().add("North", jToolBar);
        }
        StatusBar statusBar = new StatusBar();
        this.getContentPane().add("South", statusBar);
        BaseFrame.updateComponentsUI();
    }

    public void setTitle() {
        StringBuffer stringBuffer = new StringBuffer(Environment.getPhexVendor());
        if (NetworkManager.getInstance().isNetworkJoined()) {
            stringBuffer.append(" - ");
            stringBuffer.append(ServiceManager.sCfg.mCurrentNetwork);
        }
        if (ServiceManager.sCfg.mProxyUse) {
            stringBuffer.append("  (via Proxy Server)");
        }
        super.setTitle(stringBuffer.toString());
    }

    public void setTabVisible(FWTab fWTab, boolean bl) {
        if (bl) {
            int n;
            int n2 = this.tabbedPane.getTabCount();
            int n3 = fWTab.getIndex();
            if (n2 == 0) {
                n = 0;
            } else {
                n = n2;
                FWTab fWTab2 = (FWTab)this.tabbedPane.getComponentAt(n - 1);
                int n4 = fWTab2.getIndex();
                while (n4 > n3) {
                    if (--n == 0) break;
                    fWTab2 = (FWTab)this.tabbedPane.getComponentAt(n - 1);
                    n4 = fWTab2.getIndex();
                }
            }
            int n5 = this.tabbedPane.getTabCount();
            if (n5 == 0) {
                this.getContentPane().remove(this.getLogoPanel());
                this.getContentPane().add("Center", this.tabbedPane);
                this.tabbedPane.setVisible(true);
                this.getContentPane().invalidate();
                this.getContentPane().repaint();
            }
            this.tabbedPane.insertTab(fWTab.getName(), fWTab.getIcon(), fWTab, fWTab.getToolTip(), n);
            this.tabbedPane.setSelectedIndex(n);
            if (n5 == 0) {
                fWTab.setVisible(true);
            }
        } else {
            this.tabbedPane.remove(fWTab);
            if (this.tabbedPane.getTabCount() == 0) {
                this.getContentPane().remove(this.tabbedPane);
                this.getContentPane().add("Center", this.getLogoPanel());
                this.getContentPane().invalidate();
                this.getContentPane().repaint();
                this.tabbedPane.setVisible(false);
            }
        }
    }

    public void setSelectedTab(int n) {
        FWTab fWTab = this.getTab(n);
        this.setSelectedTab(fWTab);
    }

    public FWTab getSelectedTab() {
        if (this.tabbedPane.getTabCount() == 0) {
            return null;
        }
        return (FWTab)this.tabbedPane.getSelectedComponent();
    }

    public void setSelectedTab(FWTab fWTab) {
        if (fWTab == null) {
            return;
        }
        FWToggleAction fWToggleAction = fWTab.getToggleTabViewAction();
        if (!fWToggleAction.isSelected()) {
            fWToggleAction.actionPerformed(new ActionEvent(this, 0, null));
        }
        this.tabbedPane.setSelectedComponent(fWTab);
    }

    public FWTab getTab(int n) {
        switch (n) {
            case 1000: {
                return this.networkTab;
            }
            case 1001: {
                return this.searchTab;
            }
            case 1002: {
                return this.monitorTab;
            }
            case 1003: {
                return this.swDownloadTab;
            }
            case 1004: {
                return this.shareTab;
            }
        }
        Logger.logWarning((short)32, "Unknown tab id: " + n);
        return null;
    }

    public NetworkTab getNetworkTab() {
        return this.networkTab;
    }

    public SearchTab getSearchTab() {
        return this.searchTab;
    }

    public void saveGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        this.networkTab.appendXJBGUISettings(xJBGUISettings);
        this.searchTab.appendXJBGUISettings(xJBGUISettings);
        this.monitorTab.appendXJBGUISettings(xJBGUISettings);
        this.swDownloadTab.appendXJBGUISettings(xJBGUISettings);
        this.shareTab.appendXJBGUISettings(xJBGUISettings);
        this.securityTab.appendXJBGUISettings(xJBGUISettings);
        this.statisticsTab.appendXJBGUISettings(xJBGUISettings);
    }

    private JPanel getLogoPanel() {
        if (this.logoPanel == null) {
            ImageIcon imageIcon = new ImageIcon((class$phex$gui$common$MainFrame == null ? (class$phex$gui$common$MainFrame = MainFrame.class$("phex.gui.common.MainFrame")) : class$phex$gui$common$MainFrame).getResource("/phex/resources/splash.jpg"));
            Image image = imageIcon.getImage();
            this.logoPanel = new FWLogoPanel(image);
            this.logoPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        return this.logoPanel;
    }

    private JToolBar createFWToolbar() {
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setShowText(false);
        fWToolBar.addAction(GUIRegistry.getInstance().getGlobalAction("ExitPhexAction"));
        fWToolBar.addSeparator();
        fWToolBar.addAction(GUIRegistry.getInstance().getGlobalAction("ConnectNetworkAction"));
        fWToolBar.addAction(GUIRegistry.getInstance().getGlobalAction("DisconnectNetworkAction"));
        fWToolBar.addSeparator();
        fWToolBar.addAction(this.networkTab.getToggleTabViewAction());
        fWToolBar.addAction(this.searchTab.getToggleTabViewAction());
        fWToolBar.addAction(this.monitorTab.getToggleTabViewAction());
        fWToolBar.addAction(this.swDownloadTab.getToggleTabViewAction());
        fWToolBar.addAction(this.shareTab.getToggleTabViewAction());
        fWToolBar.addAction(this.securityTab.getToggleTabViewAction());
        fWToolBar.addAction(this.statisticsTab.getToggleTabViewAction());
        return fWToolBar;
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(Localizer.getString("Network"));
        jMenu.setMnemonic(Localizer.getChar("NetworkMnemonic"));
        FWAction fWAction = GUIRegistry.getInstance().getGlobalAction("ConnectNetworkAction");
        jMenu.add(fWAction);
        fWAction = GUIRegistry.getInstance().getGlobalAction("DisconnectNetworkAction");
        jMenu.add(fWAction);
        jMenu.addSeparator();
        fWAction = GUIRegistry.getInstance().getGlobalAction("SwitchNetworkAction");
        jMenu.add(fWAction);
        jMenu.addSeparator();
        fWAction = GUIRegistry.getInstance().getGlobalAction("ExitPhexAction");
        jMenu.add(fWAction);
        jMenuBar.add(jMenu);
        FWMenu fWMenu = new FWMenu(Localizer.getString("View"));
        fWMenu.setMnemonic(Localizer.getChar("ViewMnemonic"));
        fWMenu.addAction(this.networkTab.getToggleTabViewAction());
        fWMenu.addAction(this.searchTab.getToggleTabViewAction());
        fWMenu.addAction(this.monitorTab.getToggleTabViewAction());
        fWMenu.addAction(this.swDownloadTab.getToggleTabViewAction());
        fWMenu.addAction(this.shareTab.getToggleTabViewAction());
        fWMenu.addAction(this.securityTab.getToggleTabViewAction());
        fWMenu.addAction(this.statisticsTab.getToggleTabViewAction());
        jMenuBar.add(fWMenu);
        FWMenu fWMenu2 = new FWMenu(Localizer.getString("Settings"));
        fWMenu2.setMnemonic(Localizer.getChar("SettingsMnemonic"));
        fWAction = new ViewOptionsAction();
        fWMenu2.addAction(fWAction);
        fWMenu2.addSeparator();
        fWAction = new FilteredPortsAction();
        fWMenu2.addAction(fWAction);
        fWMenu2.addSeparator();
        fWAction = new RescanSharedFilesAction();
        fWMenu2.addAction(fWAction);
        jMenuBar.add(fWMenu2);
        FWMenu fWMenu3 = new FWMenu(Localizer.getString("Help"));
        fWMenu3.setMnemonic(Localizer.getChar("HelpMnemonic"));
        fWMenu3.addAction(new OpenURLAction(Localizer.getString("PhexHomepage"), "http://phex.kouk.de", GUIRegistry.getInstance().getIconFactory().getIcon("Network"), Localizer.getString("TTTPhexHomepage"), new Integer(Localizer.getChar("PhexHomepageMnemonic")), null));
        fWMenu3.addAction(new OpenURLAction(Localizer.getString("PhexForum"), "http://www.gnutellaforums.com/forumdisplay.php?s=&forumid=16", GUIRegistry.getInstance().getIconFactory().getIcon("Network"), Localizer.getString("TTTPhexForum"), new Integer(Localizer.getChar("PhexForumMnemonic")), null));
        fWMenu3.addSeparator();
        fWMenu3.addAction(new ActionViewAbout());
        jMenuBar.add(fWMenu3);
        return jMenuBar;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RefreshHandler
    implements ActionListener {
        private RefreshHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.networkTab.refresh();
        }
    }

    private class DesktopIndicatorHandler
    implements DesktopIndicatorListener {
        private DesktopIndicatorHandler() {
        }

        public void onDesktopIndicatorClicked(DesktopIndicator desktopIndicator) {
            MainFrame.this.show();
            desktopIndicator.hideIndicator();
            if (MainFrame.this.getState() != 0) {
                MainFrame.this.setState(0);
            }
            MainFrame.this.requestFocus();
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ExitPhexAction.performCloseGUIAction();
        }
    }
}

