/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.xml.bind.JAXBException;
import phex.chat.ChatManager;
import phex.common.Cfg;
import phex.common.ExpiryDate;
import phex.common.MediaType;
import phex.common.ServiceManager;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.gui.actions.FWAction;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWTable;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.common.MainFrame;
import phex.gui.dialogs.DownloadConfigDialog;
import phex.gui.models.FWSortedTableModel;
import phex.gui.models.FWTableColumnModel;
import phex.gui.models.SearchComboBoxModel;
import phex.gui.models.SearchFilterComboBoxModel;
import phex.gui.models.SearchTableModel;
import phex.gui.renderer.MediaTypeListRenderer;
import phex.gui.renderer.SearchFilterListRenderer;
import phex.gui.renderer.SearchListRenderer;
import phex.gui.tabs.FWTab;
import phex.interfaces.IFind;
import phex.query.BrowseHostResults;
import phex.query.QueryManager;
import phex.query.Search;
import phex.query.SearchContainer;
import phex.query.SearchFilter;
import phex.query.SearchFilterContainer;
import phex.security.PhexSecurityManager;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.StrUtil;
import phex.utils.URLUtil;
import phex.xml.ObjectFactory;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITable;
import phex.xml.XJBGUITableColumnList;

public class SearchTab
extends FWTab
implements IFind {
    private static final String SEARCH_TABLE_IDENTIFIER = "SearchTable";
    private static final RemoteFile[] EMPTY_REMOTE_FILE_ARRAY = new RemoteFile[0];
    private SizeDefinition[] sizeDefinitions = new SizeDefinition[]{new SizeDefinition("BytesToken", 1L), new SizeDefinition("KBToken", 1024L), new SizeDefinition("MBToken", 0x100000L), new SizeDefinition("GBToken", 0x40000000L)};
    private JPanel topPanel;
    private JPanel searchConfigPanel;
    private DefaultComboBoxModel searchComboModel;
    private JComboBox searchTermComboBox;
    private JButton submitSearchBtn;
    private JPanel filterConfigPanel;
    private JTextField filterTextTF;
    private JComboBox mediaTypeComboBox;
    private JTextField maxSearchResultsTF;
    private JComboBox minFileSizeUnitComboBox;
    private JTextField minFileSizeTF;
    private JTextField minHostSpeed;
    private JComboBox minHostRatingComboBox;
    private JComboBox filterNameComboBox;
    private JButton saveFilterButton;
    private JButton resetFilterButton;
    private SearchContainer searchContainer;
    private SearchFilterContainer searchFilterContainer;
    private MainFrame mainFrame;
    private JLabel mSearchResultLabel;
    private JComboBox searchResultCombo;
    private SearchComboBoxModel searchResultModel;
    private JButton searchStartStopButton;
    private JButton removeSearchBtn;
    private JComboBox filterComboBox;
    private JButton removeFilterBtn;
    private FWTable searchTable;
    private JScrollPane searchTableScrollPane;
    private FWTableColumnModel searchColumnModel;
    private SearchTableModel searchModel;
    private JPopupMenu searchResultPopup;
    private static final String QUICK_DOWNLOAD_ACTION_KEY = "SWQuickDownloadAction";
    private static final String CONFIG_DOWNLOAD_ACTION_KEY = "SWConfigDownloadAction";
    private static final String VIEW_BITZI_TICKET_ACTION_KEY = "ViewBitziTicketAction";
    private static final String CHAT_TO_HOST_ACTION_KEY = "ChatToHostAction";
    private static final String BROWSE_HOST_ACTION_KEY = "BrowseHostAction";
    private static final String FILTER_HOST_ACTION_KEY = "FilterHostAction";

    public SearchTab(MainFrame mainFrame) {
        super(1001, Localizer.getString("Search"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"), Localizer.getString("TTTSearchTab"), Localizer.getChar("SearchMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("SearchAccelerator")), 1);
        this.mainFrame = mainFrame;
        QueryManager queryManager = QueryManager.getInstance();
        this.searchContainer = queryManager.getSearchContainer();
        this.searchFilterContainer = queryManager.getSearchFilterContainer();
    }

    public void initComponent(XJBGUISettings xJBGUISettings) {
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 2, 0, 2);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 2, 4));
        this.topPanel = new JPanel(new GridBagLayout());
        this.topPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("SearchConditions")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.add((Component)this.topPanel, gridBagConstraints);
        this.searchConfigPanel = new JPanel(new GridBagLayout());
        this.searchConfigPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 4));
        JLabel jLabel = new JLabel(Localizer.getString("SearchTerm") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.searchConfigPanel.add((Component)jLabel, gridBagConstraints);
        SubmitSearchHandler submitSearchHandler = new SubmitSearchHandler();
        this.searchComboModel = new DefaultComboBoxModel<Object>(ServiceManager.sCfg.searchTermHistory.toArray());
        this.searchTermComboBox = new JComboBox(this.searchComboModel);
        this.searchTermComboBox.setEditable(true);
        JTextField jTextField = (JTextField)this.searchTermComboBox.getEditor().getEditorComponent();
        Keymap keymap = JTextField.addKeymap("SearchTermEditor", jTextField.getKeymap());
        jTextField.setKeymap(keymap);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), submitSearchHandler);
        GUIUtils.assignKeymapToComboBoxEditor(keymap, this.searchTermComboBox);
        this.searchTermComboBox.setSelectedItem("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.searchConfigPanel.add((Component)this.searchTermComboBox, gridBagConstraints);
        this.submitSearchBtn = new JButton(Localizer.getString("Search"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"));
        Insets insets3 = this.submitSearchBtn.getMargin();
        this.submitSearchBtn.setMargin(new Insets(insets3.top - 1, insets3.left, insets3.bottom - 1, insets3.right));
        this.submitSearchBtn.addActionListener(submitSearchHandler);
        this.submitSearchBtn.setToolTipText(Localizer.getString("TTTSearch"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.searchConfigPanel.add((Component)this.submitSearchBtn, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.topPanel.add((Component)jPanel, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("Searches") + Localizer.getChar("ColonSign") + " ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.searchResultModel = new SearchComboBoxModel();
        this.searchResultModel.addListDataListener(new SearchUpdateChangeListener());
        this.searchResultCombo = new JComboBox(this.searchResultModel);
        this.searchResultCombo.setRenderer(new SearchListRenderer());
        this.searchResultCombo.setEditable(false);
        this.searchResultCombo.addActionListener(new SearchComboActionHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.searchResultCombo, gridBagConstraints);
        this.searchStartStopButton = new JButton(Localizer.getString("Stop"));
        this.searchStartStopButton.setMargin(insets);
        this.searchStartStopButton.setToolTipText(Localizer.getString("TTTStartStopSearch"));
        this.searchStartStopButton.setEnabled(false);
        this.searchStartStopButton.addActionListener(new SearchButtonHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.searchStartStopButton, gridBagConstraints);
        this.removeSearchBtn = new JButton(Localizer.getString("Remove"));
        this.removeSearchBtn.setMargin(insets);
        this.removeSearchBtn.setToolTipText(Localizer.getString("TTTRemoveSearch"));
        this.removeSearchBtn.setEnabled(true);
        this.removeSearchBtn.addActionListener(new SearchButtonHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.removeSearchBtn, gridBagConstraints);
        jLabel = new JLabel(Localizer.getChar("DashSign") + " " + Localizer.getString("Filters") + Localizer.getChar("ColonSign") + " ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.filterComboBox = new JComboBox(new SearchFilterComboBoxModel());
        this.filterComboBox.addActionListener(new FilterSelectionHandler());
        this.filterComboBox.setRenderer(new SearchFilterListRenderer());
        this.filterComboBox.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.filterComboBox, gridBagConstraints);
        final JButton jButton = new JButton(Localizer.getString("Edit"));
        jButton.setMargin(insets);
        jButton.setActionCommand("OpenFilter");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("OpenFilter")) {
                    jButton.setActionCommand("CloseFilter");
                    SearchTab.this.filterConfigPanel.setVisible(true);
                } else {
                    jButton.setActionCommand("OpenFilter");
                    SearchTab.this.filterConfigPanel.setVisible(false);
                }
                SearchTab.this.topPanel.setMinimumSize(SearchTab.this.topPanel.getPreferredSize());
            }
        });
        jButton.setToolTipText(Localizer.getString("TTTEditFilter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel.add((Component)jButton, gridBagConstraints);
        this.removeFilterBtn = new JButton(Localizer.getString("Remove"));
        this.removeFilterBtn.addActionListener(new SearchButtonHandler());
        this.removeFilterBtn.setMargin(insets);
        this.removeFilterBtn.setToolTipText(Localizer.getString("TTTRemoveFilter"));
        this.removeFilterBtn.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.removeFilterBtn, gridBagConstraints);
        this.filterConfigPanel = new JPanel(new GridBagLayout());
        this.filterConfigPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 4));
        jLabel = new JLabel(Localizer.getString("RefineSearch") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.filterConfigPanel.add((Component)jLabel, gridBagConstraints);
        this.filterTextTF = new JTextField(20);
        this.filterTextTF.setToolTipText(Localizer.getString("TTTResultFilter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.filterConfigPanel.add((Component)this.filterTextTF, gridBagConstraints);
        this.mediaTypeComboBox = new JComboBox<MediaType>(MediaType.getAllMediaTypes());
        this.mediaTypeComboBox.setRenderer(new MediaTypeListRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.filterConfigPanel.add((Component)this.mediaTypeComboBox, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.filterConfigPanel.add((Component)jPanel2, gridBagConstraints);
        this.saveFilterButton = new JButton(Localizer.getString("SaveFilterAs") + Localizer.getChar("ColonSign") + ' ');
        this.saveFilterButton.setMargin(insets2);
        this.saveFilterButton.setToolTipText(Localizer.getString("TTTSaveFilter"));
        this.saveFilterButton.addActionListener(new SearchButtonHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.saveFilterButton, gridBagConstraints);
        this.filterNameComboBox = new JComboBox(new SearchFilterComboBoxModel());
        this.filterNameComboBox.setRenderer(new SearchFilterListRenderer());
        this.filterNameComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.filterNameComboBox, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MaxSearchResults") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.filterConfigPanel.add((Component)jLabel, gridBagConstraints);
        this.maxSearchResultsTF = new IntegerTextField(4, 5);
        this.maxSearchResultsTF.setToolTipText(Localizer.getString("TTTMaxSearchResults"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.filterConfigPanel.add((Component)this.maxSearchResultsTF, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.filterConfigPanel.add((Component)jPanel3, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MinFileSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel3.add((Component)jLabel, gridBagConstraints);
        this.minFileSizeUnitComboBox = new JComboBox<SizeDefinition>(this.sizeDefinitions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        jPanel3.add((Component)this.minFileSizeUnitComboBox, gridBagConstraints);
        jLabel = new JLabel(Localizer.getChar("ColonSign") + " ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)jLabel, gridBagConstraints);
        this.minFileSizeTF = new IntegerTextField(10, 12);
        this.minFileSizeTF.setToolTipText(Localizer.getString("TTTMinFileSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.filterConfigPanel.add((Component)this.minFileSizeTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MinSpeed") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.filterConfigPanel.add((Component)jLabel, gridBagConstraints);
        this.minHostSpeed = new IntegerTextField(6, 9);
        this.minHostSpeed.setToolTipText(Localizer.getString("TTTMinSpeed"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.filterConfigPanel.add((Component)this.minHostSpeed, gridBagConstraints);
        jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.filterConfigPanel.add((Component)jPanel3, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MinRating") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        jPanel3.add((Component)jLabel, gridBagConstraints);
        Object[] objectArray = new Object[]{new Short(0), new Short(1), new Short(2), new Short(3), new Short(4), new Short(5), new Short(6), new Short(7), new Short(8)};
        this.minHostRatingComboBox = new JComboBox<Object>(objectArray);
        this.minHostRatingComboBox.setToolTipText(Localizer.getString("TTTMinRating"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        jPanel3.add((Component)this.minHostRatingComboBox, gridBagConstraints);
        this.resetFilterButton = new JButton(Localizer.getString("Reset"));
        this.resetFilterButton.setMargin(insets2);
        this.resetFilterButton.setToolTipText(Localizer.getString("TTTResetFilter"));
        this.resetFilterButton.addActionListener(new SearchButtonHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        gridBagConstraints.anchor = 17;
        this.filterConfigPanel.add((Component)this.resetFilterButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.topPanel.add((Component)this.searchConfigPanel, gridBagConstraints);
        this.filterConfigPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("ResultFilter")));
        this.topPanel.setMinimumSize(this.topPanel.getPreferredSize());
        this.filterConfigPanel.setMinimumSize(this.filterConfigPanel.getPreferredSize());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.topPanel.add((Component)this.filterConfigPanel, gridBagConstraints);
        this.filterConfigPanel.setVisible(false);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)jPanel4, gridBagConstraints);
        this.mSearchResultLabel = new JLabel(Localizer.getString("NoSearchSelected"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        jPanel4.add((Component)this.mSearchResultLabel, gridBagConstraints);
        this.searchModel = new SearchTableModel(this);
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, SEARCH_TABLE_IDENTIFIER);
        this.buildSearchTableColumnModel(xJBGUITable);
        MouseHandler mouseHandler = new MouseHandler();
        this.searchTable = new FWTable((TableModel)new FWSortedTableModel(this.searchModel), this.searchColumnModel);
        this.searchTable.activateAllHeaderActions();
        this.searchTable.setAutoResizeMode(0);
        this.searchTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.searchTable.addMouseListener(mouseHandler);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.searchTableScrollPane = FWTable.createFWTableScrollPane(this.searchTable);
        this.searchTableScrollPane.addMouseListener(mouseHandler);
        jPanel4.add((Component)this.searchTableScrollPane, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4), BorderFactory.createEtchedBorder()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        jPanel4.add((Component)jPanel5, gridBagConstraints);
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        jPanel5.add((Component)fWToolBar, gridBagConstraints);
        this.searchResultPopup = new JPopupMenu();
        FWAction fWAction = new SWQuickDownloadAction();
        this.addTabAction(QUICK_DOWNLOAD_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        fWAction = new SWConfigDownloadAction();
        this.addTabAction(CONFIG_DOWNLOAD_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        fWAction = new ViewBitziTicketAction();
        this.addTabAction(VIEW_BITZI_TICKET_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        this.searchResultPopup.addSeparator();
        fWAction = new BrowseHostAction();
        this.addTabAction(BROWSE_HOST_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        fWAction = new ChatToHostAction();
        this.addTabAction(CHAT_TO_HOST_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        fWAction = new BanHostAction();
        this.addTabAction(FILTER_HOST_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        this.minFileSizeUnitComboBox.setSelectedIndex(1);
        this.resetFilterSettings();
        this.updateFilterPanel();
    }

    public void updateUI() {
        super.updateUI();
        GUIUtils.adjustComboBoxHeight(this.searchResultCombo);
        GUIUtils.adjustComboBoxHeight(this.filterComboBox);
        GUIUtils.adjustComboBoxHeight(this.filterNameComboBox);
        GUIUtils.adjustComboBoxHeight(this.mediaTypeComboBox);
        GUIUtils.adjustComboBoxHeight(this.minFileSizeUnitComboBox);
        GUIUtils.adjustComboBoxHeight(this.minHostRatingComboBox);
        if (this.searchTermComboBox != null) {
            GUIUtils.adjustComboBoxHeight(this.searchTermComboBox);
            ListCellRenderer listCellRenderer = this.searchTermComboBox.getRenderer();
            if (listCellRenderer != null) {
                FontMetrics fontMetrics = this.searchTermComboBox.getFontMetrics(this.searchTermComboBox.getFont());
                int n = fontMetrics.getMaxAdvance() * 15;
                int n2 = fontMetrics.getMaxAdvance() * 8;
                Dimension dimension = this.searchTermComboBox.getMaximumSize();
                dimension.width = Math.max(n2, Math.min(n, dimension.width));
                dimension = this.searchTermComboBox.getPreferredSize();
                dimension.width = Math.max(n2, Math.min(n, dimension.width));
            }
        }
        if (this.searchTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.searchTableScrollPane);
        }
    }

    public void appendXJBGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        super.appendXJBGUISettings(xJBGUISettings);
        XJBGUITableColumnList xJBGUITableColumnList = this.searchColumnModel.createXJBGUITableColumnList();
        XJBGUITable xJBGUITable = ObjectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(SEARCH_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
    }

    public void startStopSearch() {
        Search search = (Search)this.searchResultCombo.getSelectedItem();
        if (search == null) {
            return;
        }
        if (search.isSearching()) {
            search.stopSearching();
        } else {
            search.startSearching();
        }
    }

    public void findInResult(boolean bl, boolean bl2, String string) {
        int n = this.searchTable.getSelectedRow();
        n = bl2 ? ++n : --n;
        if (!bl) {
            string = string.toLowerCase();
        }
        int n2 = n;
        int n3 = this.searchTable.getRowCount();
        int n4 = this.searchTable.getColumnCount();
        while (!(bl2 ? n2 >= n3 : n2 < 0)) {
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                Object object = this.searchTable.getValueAt(n2, n5);
                if (object != null && (n6 = bl ? object.toString().indexOf(string) : object.toString().toLowerCase().indexOf(string)) != -1) {
                    this.searchTable.clearSelection();
                    this.searchTable.addRowSelectionInterval(n2, n2);
                    this.searchTable.scrollRectToVisible(this.searchTable.getCellRect(n2, 0, true));
                    return;
                }
                ++n5;
            }
            if (bl2) {
                ++n2;
                continue;
            }
            --n2;
        }
        JOptionPane.showMessageDialog(this, Localizer.getString("NoMoreResultsFound"), Localizer.getString("Find"), 1);
    }

    private void removeSearch() {
        Search search = (Search)this.searchResultCombo.getSelectedItem();
        if (search != null) {
            this.searchContainer.removeSearch(search);
        }
    }

    private void removeFilter() {
        SearchFilter searchFilter = (SearchFilter)this.filterComboBox.getSelectedItem();
        if (searchFilter != null) {
            SearchFilterContainer searchFilterContainer = QueryManager.getInstance().getSearchFilterContainer();
            searchFilterContainer.removeSearchFilter(searchFilter);
        }
    }

    private void resetFilterSettings() {
        Document document = this.filterTextTF.getDocument();
        try {
            document.remove(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            Logger.logWarning(badLocationException);
        }
        this.mediaTypeComboBox.setSelectedItem("AnyMediaType");
        this.maxSearchResultsTF.setText("9999");
        this.minFileSizeTF.setText("0");
        this.minHostSpeed.setText("0");
        this.minHostRatingComboBox.setSelectedIndex(0);
    }

    private void saveFilterSettings() {
        Object object;
        SearchFilter searchFilter;
        int n;
        MediaType mediaType = (MediaType)this.mediaTypeComboBox.getSelectedItem();
        String string = this.maxSearchResultsTF.getText().trim();
        String string2 = this.minHostSpeed.getText().trim();
        String string3 = this.minFileSizeTF.getText().trim();
        String string4 = this.filterTextTF.getText().trim();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.displayWrongNumberFormatError(this.maxSearchResultsTF);
            return;
        }
        int n2 = 0;
        try {
            if (string2.length() > 0) {
                n2 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.displayWrongNumberFormatError(this.minHostSpeed);
            return;
        }
        long l = 0L;
        try {
            if (string3.length() > 0) {
                l = Integer.parseInt(string3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.displayWrongNumberFormatError(this.minFileSizeTF);
            return;
        }
        SizeDefinition sizeDefinition = (SizeDefinition)this.minFileSizeUnitComboBox.getSelectedItem();
        long l2 = sizeDefinition.getMultiplier();
        long l3 = l2 * l;
        short s = (Short)this.minHostRatingComboBox.getSelectedItem();
        Object object2 = this.filterNameComboBox.getSelectedItem();
        if (object2 instanceof SearchFilter) {
            searchFilter = (SearchFilter)object2;
        } else {
            object = QueryManager.getInstance().getSearchFilterContainer();
            String string5 = ((String)object2).trim();
            if (string5.length() == 0) {
                JOptionPane.showMessageDialog(this, Localizer.getString("NoFilterName"), Localizer.getString("NoFilterNameTitle"), 0);
                this.filterNameComboBox.requestFocus();
                return;
            }
            searchFilter = ((SearchFilterContainer)object).getSearchFilterWithName(string5);
            if (searchFilter == null) {
                searchFilter = new SearchFilter(string5);
                ((SearchFilterContainer)object).addSearchFilter(searchFilter);
            }
        }
        searchFilter.updateSearchFilter(string4, n2, s, mediaType, n, l3);
        object = (Search)this.searchResultCombo.getSelectedItem();
        if (object != null) {
            ((Search)object).updateSearchFilter(searchFilter);
        }
    }

    public RemoteFile[] getSelectedRemoteFiles() {
        Search search = (Search)this.searchResultCombo.getSelectedItem();
        if (search == null) {
            return null;
        }
        int[] nArray = this.searchTable.getSelectedRows();
        if (nArray.length == 0) {
            return EMPTY_REMOTE_FILE_ARRAY;
        }
        int[] nArray2 = this.searchTable.convertRowIndicesToModel(nArray);
        RemoteFile[] remoteFileArray = search.getQueryHits(nArray2);
        return remoteFileArray;
    }

    private RemoteFile getSelectedRemoteFile() {
        Search search = (Search)this.searchResultCombo.getSelectedItem();
        if (search == null) {
            return null;
        }
        int n = this.searchTable.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.searchTable.convertRowIndexToModel(n);
        RemoteFile remoteFile = search.getQueryHit(n2);
        return remoteFile;
    }

    public int getResultSelectedCount() {
        return this.searchTable.getSelectedRowCount();
    }

    public Search getSelectedSearchResult() {
        return (Search)this.searchResultCombo.getSelectedItem();
    }

    private void displayWrongNumberFormatError(JTextField jTextField) {
        jTextField.requestFocus();
        jTextField.selectAll();
        JOptionPane.showMessageDialog(this, Localizer.getString("WrongNumberFormat"), Localizer.getString("FormatError"), 0);
    }

    private void updateSearchResultLabel() {
        Search search = (Search)this.searchResultCombo.getSelectedItem();
        if (search != null) {
            this.updateSearchResultLabel(search);
        } else {
            this.searchStartStopButton.setEnabled(false);
            this.mSearchResultLabel.setText(Localizer.getString("NoSearchSelected"));
        }
    }

    private void updateSearchResultLabel(final Search search) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string;
                SearchTab.this.searchStartStopButton.setEnabled(true);
                if (search.isSearching()) {
                    SearchTab.this.searchStartStopButton.setText(Localizer.getString("Stop"));
                } else {
                    SearchTab.this.searchStartStopButton.setText(Localizer.getString("Start"));
                }
                if (search instanceof BrowseHostResults && ((BrowseHostResults)search).getBrowseHostError() != 0) {
                    Object[] objectArray = new Object[]{new Integer(((BrowseHostResults)search).getBrowseHostError())};
                    string = Localizer.getFormatedString("SearchStatusError", objectArray);
                } else {
                    Integer n = search.isSearching() ? new Integer(1) : new Integer(0);
                    Object[] objectArray = new Object[]{new Integer(search.getQueryHitCount()), new Integer(search.getLocallyFilteredCount()), n};
                    string = Localizer.getFormatedString("SearchStatus", objectArray);
                }
                SearchTab.this.mSearchResultLabel.setText(string);
            }
        });
    }

    private void buildSearchTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = SearchTableModel.getColumnIdArray();
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.searchColumnModel = new FWTableColumnModel(this.searchModel, nArray, xJBGUITableColumnList);
    }

    private void updateFilterPanel() {
        SearchFilter searchFilter = (SearchFilter)this.filterComboBox.getSelectedItem();
        if (searchFilter == null) {
            return;
        }
        this.filterTextTF.setText(searchFilter.getFilterString());
        this.mediaTypeComboBox.setSelectedItem(searchFilter.getMediaType());
        this.maxSearchResultsTF.setText(String.valueOf(searchFilter.getMaxResults()));
        long l = searchFilter.getMinFileSize();
        this.minFileSizeUnitComboBox.setSelectedIndex(0);
        int n = this.sizeDefinitions.length - 1;
        while (n >= 0) {
            SizeDefinition sizeDefinition = this.sizeDefinitions[n];
            long l2 = l % sizeDefinition.getMultiplier();
            if (l2 == 0L) {
                this.minFileSizeUnitComboBox.setSelectedIndex(n);
                l /= sizeDefinition.getMultiplier();
                break;
            }
            --n;
        }
        this.minFileSizeTF.setText(String.valueOf(l));
        this.minHostSpeed.setText(String.valueOf(searchFilter.getMinSpeed()));
        this.minHostRatingComboBox.setSelectedIndex(searchFilter.getMinRating());
        this.filterNameComboBox.setSelectedItem(searchFilter);
    }

    private class SizeDefinition {
        private String representation;
        private long multiplier;

        public SizeDefinition(String string, long l) {
            this.representation = Localizer.getString(string);
            this.multiplier = l;
        }

        public long getMultiplier() {
            return this.multiplier;
        }

        public String toString() {
            return this.representation;
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == SearchTab.this.searchTable) {
                SearchTab.this.getTabAction(SearchTab.QUICK_DOWNLOAD_ACTION_KEY).actionPerformed(null);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == SearchTab.this.searchTable || component == SearchTab.this.searchTableScrollPane) {
                SearchTab.this.searchResultPopup.show(component, n, n2);
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SearchTab.this.refreshTabActions();
        }
    }

    private class SearchButtonHandler
    implements ActionListener {
        private SearchButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object object = actionEvent.getSource();
                if (object == SearchTab.this.searchStartStopButton) {
                    SearchTab.this.startStopSearch();
                } else if (object == SearchTab.this.removeSearchBtn) {
                    SearchTab.this.removeSearch();
                } else if (object == SearchTab.this.saveFilterButton) {
                    SearchTab.this.saveFilterSettings();
                } else if (object == SearchTab.this.removeFilterBtn) {
                    SearchTab.this.removeFilter();
                } else if (object == SearchTab.this.resetFilterButton) {
                    SearchTab.this.resetFilterSettings();
                }
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
    }

    private class BanHostAction
    extends FWAction {
        public BanHostAction() {
            super(Localizer.getString("BanHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Ban"), Localizer.getString("TTTBanHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFile[] remoteFileArray = SearchTab.this.getSelectedRemoteFiles();
            PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
            int n = 0;
            while (n < remoteFileArray.length) {
                try {
                    phexSecurityManager.createIPAccessRule(Localizer.getString("UserBanned"), true, (byte)1, remoteFileArray[n].getHostAddress().getHostIP(), null, false, ExpiryDate.SESSION_EXPIRY_DATE, true);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                ++n;
            }
        }

        public void refreshActionState() {
            if (SearchTab.this.searchTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFile remoteFile = SearchTab.this.getSelectedRemoteFile();
            if (remoteFile == null) {
                return;
            }
            if (!remoteFile.getQueryHitHost().isBrowseHostSupported()) {
                return;
            }
            SearchContainer searchContainer = QueryManager.getInstance().getSearchContainer();
            searchContainer.createBrowseHostSearch(remoteFile.getHostAddress(), null);
        }

        public void refreshActionState() {
            RemoteFile remoteFile;
            if (SearchTab.this.searchTable.getSelectedRowCount() == 1 && (remoteFile = SearchTab.this.getSelectedRemoteFile()) != null && remoteFile.getQueryHitHost().isBrowseHostSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFile remoteFile = SearchTab.this.getSelectedRemoteFile();
            if (remoteFile == null) {
                return;
            }
            if (!remoteFile.getQueryHitHost().isChatSupported()) {
                return;
            }
            ChatManager.getInstance().openChat(remoteFile.getHostAddress());
        }

        public void refreshActionState() {
            RemoteFile remoteFile;
            if (SearchTab.this.searchTable.getSelectedRowCount() == 1 && (remoteFile = SearchTab.this.getSelectedRemoteFile()) != null && remoteFile.getQueryHitHost().isChatSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getIconFactory().getIcon("Bitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                RemoteFile remoteFile = SearchTab.this.getSelectedRemoteFile();
                if (remoteFile == null) {
                    return;
                }
                String string = URLUtil.buildBitziLookupURL(remoteFile.getURN());
                try {
                    BrowserLauncher.openURL(string);
                }
                catch (IOException iOException) {
                    Logger.logWarning(iOException);
                    Object[] objectArray = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int n = JOptionPane.showOptionDialog(SearchTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, objectArray, Localizer.getString("Yes"));
                    if (n != 0) break block3;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                }
            }
        }

        public void refreshActionState() {
            if (SearchTab.this.searchTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class SubmitSearchHandler
    extends AbstractAction
    implements ActionListener {
        private SubmitSearchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string = (String)SearchTab.this.searchTermComboBox.getEditor().getItem();
            SearchTab.this.searchComboModel.setSelectedItem(string);
            string = string.trim();
            if (string.length() == 0) {
                return;
            }
            if (string.length() < Cfg.MIN_SEARCH_TERM_LENGTH) {
                Object[] objectArray = new Object[]{new Integer(Cfg.MIN_SEARCH_TERM_LENGTH)};
                GUIUtils.showErrorMessage(Localizer.getFormatedString("MinSearchTerm", objectArray));
                SearchTab.this.searchTermComboBox.getEditor().selectAll();
                ((JComponent)((Object)SearchTab.this.searchTermComboBox.getEditor())).requestFocus();
                return;
            }
            Search search = SearchTab.this.searchContainer.getRunningSearch(string);
            if (search != null) {
                SearchTab.this.searchResultCombo.setSelectedItem(search);
                return;
            }
            Search search2 = SearchTab.this.searchContainer.createSearch(string);
            SearchFilter searchFilter = (SearchFilter)SearchTab.this.filterComboBox.getSelectedItem();
            if (searchFilter != null) {
                search2.updateSearchFilter(searchFilter);
            }
            if ((n = SearchTab.this.searchComboModel.getIndexOf(string)) < 0) {
                SearchTab.this.searchComboModel.insertElementAt(string, 0);
                if (SearchTab.this.searchComboModel.getSize() > ServiceManager.sCfg.maxConnectToHistorySize) {
                    SearchTab.this.searchComboModel.removeElementAt(SearchTab.this.searchComboModel.getSize() - 1);
                }
                this.saveSearchList();
            } else if (n > 0) {
                SearchTab.this.searchComboModel.removeElementAt(n);
                SearchTab.this.searchComboModel.insertElementAt(string, 0);
                this.saveSearchList();
            }
            SearchTab.this.searchComboModel.setSelectedItem("");
        }

        private void saveSearchList() {
            int n = SearchTab.this.searchComboModel.getSize();
            ArrayList arrayList = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(SearchTab.this.searchComboModel.getElementAt(n2));
                ++n2;
            }
            ServiceManager.sCfg.searchTermHistory.clear();
            ServiceManager.sCfg.searchTermHistory.addAll(arrayList);
            ServiceManager.sCfg.save();
        }
    }

    private class SWConfigDownloadAction
    extends FWAction {
        public SWConfigDownloadAction() {
            super(Localizer.getString("Download"), GUIRegistry.getInstance().getIconFactory().getIcon("ConfigDownload"), Localizer.getString("TTTDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFile remoteFile = SearchTab.this.getSelectedRemoteFile();
            if (remoteFile == null) {
                return;
            }
            RemoteFile remoteFile2 = new RemoteFile(remoteFile);
            DownloadConfigDialog downloadConfigDialog = new DownloadConfigDialog(remoteFile2);
            downloadConfigDialog.show();
            if (remoteFile2.isInDownloadQueue()) {
                remoteFile.setInDownloadQueue(true);
                GUIUtils.fireTableChanged(SearchTab.this.searchTable, SearchTab.this.searchModel);
            }
        }

        public void refreshActionState() {
            if (SearchTab.this.searchTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class SWQuickDownloadAction
    extends FWAction {
        public SWQuickDownloadAction() {
            super(Localizer.getString("QuickDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Download"), Localizer.getString("TTTQuickDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwarmingManager swarmingManager = SwarmingManager.getInstance();
            RemoteFile[] remoteFileArray = SearchTab.this.getSelectedRemoteFiles();
            int n = 0;
            while (n < remoteFileArray.length) {
                remoteFileArray[n].setInDownloadQueue(true);
                SWDownloadFile[] sWDownloadFileArray = swarmingManager.getDownloadFiles(remoteFileArray[n].getFileSize(), remoteFileArray[n].getURN());
                if (sWDownloadFileArray.length > 0) {
                    int n2 = 0;
                    while (n2 < sWDownloadFileArray.length) {
                        sWDownloadFileArray[n2].addDownloadCandidate(remoteFileArray[n]);
                        ++n2;
                    }
                } else {
                    RemoteFile remoteFile = new RemoteFile(remoteFileArray[n]);
                    String string = StrUtil.createNaturalSearchTerm(remoteFile.getFilename());
                    swarmingManager.addFileToDownload(remoteFile, ServiceManager.sCfg.mDownloadDir + File.separator + remoteFile.getFilename(), string);
                }
                GUIUtils.fireTableChanged(SearchTab.this.searchTable, SearchTab.this.searchModel);
                ++n;
            }
        }

        public void refreshActionState() {
            if (SearchTab.this.searchTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class SearchComboActionHandler
    implements ActionListener {
        private SearchComboActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Search search = (Search)SearchTab.this.searchResultCombo.getSelectedItem();
            if (search != null) {
                SearchFilter searchFilter = search.getSearchFilter();
                if (searchFilter == null) {
                    searchFilter = (SearchFilter)SearchTab.this.filterComboBox.getSelectedItem();
                    if (searchFilter != null) {
                        search.updateSearchFilter(searchFilter);
                    }
                } else {
                    SearchTab.this.filterComboBox.setSelectedItem(searchFilter);
                }
            }
            SearchTab.this.updateSearchResultLabel();
            GUIUtils.fireTableChanged(SearchTab.this.searchTable, SearchTab.this.searchModel);
        }
    }

    private class FilterSelectionHandler
    implements ActionListener {
        private FilterSelectionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchFilter searchFilter;
            Search search = (Search)SearchTab.this.searchResultCombo.getSelectedItem();
            if (search != null && (searchFilter = (SearchFilter)SearchTab.this.filterComboBox.getSelectedItem()) != null) {
                search.updateSearchFilter(searchFilter);
            }
            SearchTab.this.updateFilterPanel();
        }
    }

    private class SearchUpdateChangeListener
    implements ListDataListener {
        private SearchUpdateChangeListener() {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            if (listDataEvent.getType() == 0) {
                Search search = (Search)SearchTab.this.searchResultCombo.getSelectedItem();
                if (search == null) {
                    return;
                }
                SearchTab.this.updateSearchResultLabel(search);
                GUIUtils.fireTableChanged(SearchTab.this.searchTable, SearchTab.this.searchModel);
            } else {
                SearchTab.this.updateSearchResultLabel();
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }
    }
}

